/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;
import xyz.cofe.xml.ElementHelper;
import xyz.cofe.xml.XmlUtil;

public class NodeHelper
implements Node {
    public final Node node;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(NodeHelper.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(NodeHelper.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(NodeHelper.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(NodeHelper.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(NodeHelper.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(NodeHelper.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(NodeHelper.class.getName()).log(Level.SEVERE, null, ex);
    }

    public NodeHelper(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("node==null");
        }
        this.node = node;
    }

    @Override
    public String getNodeName() {
        return this.node.getNodeName();
    }

    @Override
    public String getNodeValue() throws DOMException {
        return this.node.getNodeValue();
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
        this.node.setNodeValue(nodeValue);
    }

    @Override
    public short getNodeType() {
        return this.node.getNodeType();
    }

    @Override
    public Node getParentNode() {
        return this.node.getParentNode();
    }

    @Override
    public NodeList getChildNodes() {
        return this.node.getChildNodes();
    }

    @Override
    public Node getFirstChild() {
        return this.node.getFirstChild();
    }

    @Override
    public Node getLastChild() {
        return this.node.getLastChild();
    }

    @Override
    public Node getPreviousSibling() {
        return this.node.getPreviousSibling();
    }

    @Override
    public Node getNextSibling() {
        return this.node.getNextSibling();
    }

    @Override
    public NamedNodeMap getAttributes() {
        return this.node.getAttributes();
    }

    @Override
    public Document getOwnerDocument() {
        return this.node.getOwnerDocument();
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        return this.node.insertBefore(newChild, refChild);
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        return this.node.replaceChild(newChild, oldChild);
    }

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        return this.node.removeChild(oldChild);
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        return this.node.appendChild(newChild);
    }

    @Override
    public boolean hasChildNodes() {
        return this.node.hasChildNodes();
    }

    @Override
    public Node cloneNode(boolean deep) {
        return this.node.cloneNode(deep);
    }

    @Override
    public void normalize() {
        this.node.normalize();
    }

    @Override
    public boolean isSupported(String feature, String version) {
        return this.node.isSupported(feature, version);
    }

    @Override
    public String getNamespaceURI() {
        return this.node.getNamespaceURI();
    }

    @Override
    public String getPrefix() {
        return this.node.getPrefix();
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
        this.node.setPrefix(prefix);
    }

    @Override
    public String getLocalName() {
        return this.node.getLocalName();
    }

    @Override
    public boolean hasAttributes() {
        return this.node.hasAttributes();
    }

    @Override
    public String getBaseURI() {
        return this.node.getBaseURI();
    }

    @Override
    public short compareDocumentPosition(Node other) throws DOMException {
        return this.node.compareDocumentPosition(other);
    }

    @Override
    public String getTextContent() throws DOMException {
        return this.node.getTextContent();
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
        this.node.setTextContent(textContent);
    }

    @Override
    public boolean isSameNode(Node other) {
        return this.node.isSameNode(other);
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        return this.node.lookupPrefix(namespaceURI);
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        return this.node.isDefaultNamespace(namespaceURI);
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        return this.node.lookupNamespaceURI(prefix);
    }

    @Override
    public boolean isEqualNode(Node arg) {
        return this.node.isEqualNode(arg);
    }

    @Override
    public Object getFeature(String feature, String version) {
        return this.node.getFeature(feature, version);
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        return this.node.setUserData(key, data, handler);
    }

    @Override
    public Object getUserData(String key) {
        return this.node.getUserData(key);
    }

    public List<ElementHelper> getElements() {
        ArrayList<ElementHelper> els = new ArrayList<ElementHelper>();
        for (Element e : XmlUtil.elements(this.node)) {
            if (e == null) continue;
            els.add(new ElementHelper(e));
        }
        return els;
    }

    public String xpathString(String xpath) {
        return XmlUtil.xpath(this.node, xpath).getString();
    }

    public List<ElementHelper> xpathElements(String xpath) {
        NodeList nl = XmlUtil.xpath(this.node, xpath).getNodeList();
        ArrayList<ElementHelper> els = new ArrayList<ElementHelper>();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!(n instanceof Element)) continue;
            els.add(new ElementHelper((Element)n));
        }
        return els;
    }
}

