/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.xml;

import java.io.FileInputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import xyz.cofe.collection.BasicVisitor;
import xyz.cofe.collection.NodesExtracter;
import xyz.cofe.collection.Visitor;
import xyz.cofe.io.fn.IOFun;
import xyz.cofe.io.fs.File;
import xyz.cofe.iter.Eterable;
import xyz.cofe.iter.TreeIterBuilder;
import xyz.cofe.iter.TreeStep;
import xyz.cofe.text.Text;
import xyz.cofe.xml.FormatXMLWriter;
import xyz.cofe.xml.XMLNodeIterable;

public class XmlUtil {
    private static String trasformErrorResult = "XSLT ERROR";
    private static DocumentBuilderFactory docBuilderFactory = null;
    private static DocumentBuilder builder = null;
    private static XPathFactory xpathFactory = null;
    private static XPath xpath = null;

    public static Transformer createXSLT(String xslStyle) {
        try {
            if (xslStyle == null) {
                return null;
            }
            StringReader stringReader = new StringReader(xslStyle);
            StreamSource source = new StreamSource(stringReader);
            Transformer t = TransformerFactory.newInstance().newTransformer(source);
            return t;
        }
        catch (TransformerConfigurationException ex) {
            throw new Error(ex.getMessage(), ex);
        }
    }

    public static Transformer createXSLT(URL urlXSLT, Charset cs) {
        String text;
        if (urlXSLT == null) {
            return null;
        }
        if (cs == null) {
            return null;
        }
        try {
            text = IOFun.readText((URL)urlXSLT, (Charset)cs);
        }
        catch (IOException ex) {
            throw new Error(ex.getMessage(), ex);
        }
        if (text == null) {
            return null;
        }
        return XmlUtil.createXSLT(text);
    }

    public static Transformer createXSLT(java.io.File xsltFile, Charset cs) {
        String text;
        if (xsltFile == null) {
            return null;
        }
        if (cs == null) {
            return null;
        }
        try {
            text = IOFun.readText((java.io.File)xsltFile, (Charset)cs);
        }
        catch (IOException ex) {
            throw new Error(ex.getMessage(), ex);
        }
        return XmlUtil.createXSLT(text);
    }

    public static String toStringXSLT(Transformer trans, String xml, String errResult) {
        if (trans == null) {
            return errResult;
        }
        if (xml == null) {
            return errResult;
        }
        StringReader sread = new StringReader(xml);
        StringWriter swriter = new StringWriter();
        try {
            FormatXMLWriter fxmlWriter = new FormatXMLWriter(swriter);
            fxmlWriter.setWriteStartDocument(false);
            StAXResult result = new StAXResult(fxmlWriter);
            StreamSource source = new StreamSource(sread);
            trans.transform(source, result);
            fxmlWriter.flush();
        }
        catch (TransformerException ex) {
            throw new Error(ex.getMessage(), ex);
        }
        catch (XMLStreamException ex) {
            throw new Error(ex.getMessage(), ex);
        }
        return swriter.toString();
    }

    public static String toStringXSLT(String xsl, String srcXml) {
        if (xsl == null) {
            throw new IllegalArgumentException("xsl == null");
        }
        Transformer trfm = XmlUtil.createXSLT(xsl);
        if (trfm == null) {
            return null;
        }
        return XmlUtil.toStringXSLT(trfm, srcXml);
    }

    public static String toStringXSLT(Transformer trans, String xml) {
        return XmlUtil.toStringXSLT(trans, xml, trasformErrorResult);
    }

    public static void write(Node doc, final XMLStreamWriter writer) {
        if (writer == null) {
            throw new IllegalArgumentException("writer==null");
        }
        if (doc == null) {
            throw new IllegalArgumentException("doc == null");
        }
        final HashSet failedElements = new HashSet();
        Visitor<Node> v = new Visitor<Node>(){

            public boolean enter(Node n) {
                block31: {
                    block34: {
                        block33: {
                            block32: {
                                block30: {
                                    if (!(n instanceof Element)) break block30;
                                    String namespaceURI = n.getNamespaceURI();
                                    String prefix = n.getPrefix();
                                    String name = n.getNodeName();
                                    if (namespaceURI == null) {
                                        try {
                                            writer.writeStartElement(name);
                                        }
                                        catch (XMLStreamException ex) {
                                            Logger.getLogger(XmlUtil.class.getName()).log(Level.SEVERE, null, ex);
                                            failedElements.add(n);
                                            return false;
                                        }
                                    }
                                    if (prefix != null) {
                                        try {
                                            writer.writeStartElement(prefix, name, namespaceURI);
                                        }
                                        catch (XMLStreamException ex) {
                                            Logger.getLogger(XmlUtil.class.getName()).log(Level.SEVERE, null, ex);
                                        }
                                    } else {
                                        try {
                                            writer.writeStartElement(namespaceURI, name);
                                        }
                                        catch (XMLStreamException ex) {
                                            Logger.getLogger(XmlUtil.class.getName()).log(Level.SEVERE, null, ex);
                                        }
                                    }
                                    if (!n.hasAttributes()) break block31;
                                    NamedNodeMap nnm = n.getAttributes();
                                    for (int i = 0; i < nnm.getLength(); ++i) {
                                        Node nAttr = nnm.item(i);
                                        if (nAttr == null) continue;
                                        String attrNamespaceURI = nAttr.getNamespaceURI();
                                        String attrPrefix = nAttr.getPrefix();
                                        String attrName = nAttr.getNodeName();
                                        String attrValue = nAttr.getTextContent();
                                        if (attrNamespaceURI != null && attrPrefix != null && attrName != null) {
                                            try {
                                                writer.writeAttribute(attrPrefix, attrNamespaceURI, attrName, attrValue == null ? "" : attrValue);
                                            }
                                            catch (XMLStreamException ex) {
                                                Logger.getLogger(XmlUtil.class.getName()).log(Level.SEVERE, null, ex);
                                            }
                                            continue;
                                        }
                                        if (attrNamespaceURI != null && attrPrefix == null && attrName != null) {
                                            try {
                                                writer.writeAttribute(attrNamespaceURI, attrName, attrValue == null ? "" : attrValue);
                                            }
                                            catch (XMLStreamException ex) {
                                                Logger.getLogger(XmlUtil.class.getName()).log(Level.SEVERE, null, ex);
                                            }
                                            continue;
                                        }
                                        if (attrNamespaceURI != null || attrPrefix != null || attrName == null) continue;
                                        try {
                                            writer.writeAttribute(attrName, attrValue == null ? "" : attrValue);
                                            continue;
                                        }
                                        catch (XMLStreamException ex) {
                                            Logger.getLogger(XmlUtil.class.getName()).log(Level.SEVERE, null, ex);
                                        }
                                    }
                                    break block31;
                                }
                                if (!(n instanceof Text)) break block32;
                                Text txt = (Text)n;
                                String value = txt.getNodeValue();
                                try {
                                    writer.writeCharacters(value);
                                }
                                catch (XMLStreamException ex) {
                                    Logger.getLogger(XmlUtil.class.getName()).log(Level.SEVERE, null, ex);
                                }
                                break block31;
                            }
                            if (!(n instanceof CDATASection)) break block33;
                            CDATASection cdata = (CDATASection)n;
                            try {
                                writer.writeCData(cdata.getNodeValue());
                            }
                            catch (XMLStreamException ex) {
                                Logger.getLogger(XmlUtil.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            break block31;
                        }
                        if (!(n instanceof Comment)) break block34;
                        Comment comment = (Comment)n;
                        try {
                            writer.writeComment(comment.getNodeValue());
                        }
                        catch (XMLStreamException ex) {
                            Logger.getLogger(XmlUtil.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        break block31;
                    }
                    if (!(n instanceof ProcessingInstruction)) break block31;
                    ProcessingInstruction instr = (ProcessingInstruction)n;
                    String target = instr.getTarget();
                    String data = instr.getData();
                    if (data != null) {
                        try {
                            writer.writeProcessingInstruction(target, data);
                        }
                        catch (XMLStreamException ex) {
                            Logger.getLogger(XmlUtil.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    } else {
                        try {
                            writer.writeProcessingInstruction(target);
                        }
                        catch (XMLStreamException ex) {
                            Logger.getLogger(XmlUtil.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
                return true;
            }

            public void exit(Node n) {
                if (n instanceof Element) {
                    if (failedElements.contains(n)) {
                        return;
                    }
                    try {
                        writer.writeEndElement();
                    }
                    catch (XMLStreamException ex) {
                        Logger.getLogger(XmlUtil.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        };
        XmlUtil.visit(v, doc);
    }

    public static void write(Node node, java.io.File file, Charset cs) {
        if (node == null) {
            throw new IllegalArgumentException("node==null");
        }
        if (file == null) {
            throw new IllegalArgumentException("file==null");
        }
        if (cs == null) {
            cs = Charset.forName("utf-8");
        }
        FormatXMLWriter fwr = null;
        try {
            fwr = new FormatXMLWriter(file, cs);
            XmlUtil.write(node, fwr);
            fwr.flush();
            fwr.close();
        }
        catch (XMLStreamException ex) {
            throw new IOError(ex);
        }
    }

    public static void write(Node node, java.io.File file) {
        XmlUtil.write(node, file, null);
    }

    public static void write(Node node, Path file, Charset cs) {
        if (node == null) {
            throw new IllegalArgumentException("node==null");
        }
        if (file == null) {
            throw new IllegalArgumentException("file==null");
        }
        if (cs == null) {
            cs = Charset.forName("utf-8");
        }
        FormatXMLWriter fwr = null;
        try {
            fwr = new FormatXMLWriter(file, cs);
            XmlUtil.write(node, fwr);
            fwr.flush();
            fwr.close();
        }
        catch (XMLStreamException ex) {
            throw new IOError(ex);
        }
    }

    public static void write(Node node, Path file) {
        XmlUtil.write(node, file, null);
    }

    public static void write(Node node, File file, Charset cs) {
        if (node == null) {
            throw new IllegalArgumentException("node==null");
        }
        if (file == null) {
            throw new IllegalArgumentException("file==null");
        }
        if (cs == null) {
            cs = Charset.forName("utf-8");
        }
        FormatXMLWriter fwr = null;
        try {
            fwr = new FormatXMLWriter(file, cs);
            XmlUtil.write(node, fwr);
            fwr.flush();
            fwr.close();
        }
        catch (XMLStreamException ex) {
            throw new IOError(ex);
        }
    }

    public static void write(Node node, File file) {
        XmlUtil.write(node, file, null);
    }

    public static void write(Node node, Writer writer) {
        if (node == null) {
            throw new IllegalArgumentException("node==null");
        }
        if (writer == null) {
            throw new IllegalArgumentException("writer==null");
        }
        FormatXMLWriter fwr = null;
        try {
            fwr = new FormatXMLWriter(writer);
            XmlUtil.write(node, fwr);
            fwr.flush();
        }
        catch (XMLStreamException ex) {
            throw new IOError(ex);
        }
    }

    public static String writeAsString(Node node) {
        StringWriter sw = new StringWriter();
        XmlUtil.write(node, sw);
        return sw.toString();
    }

    public static void write(Node node, OutputStream writer, Charset cs) {
        if (node == null) {
            throw new IllegalArgumentException("node==null");
        }
        if (writer == null) {
            throw new IllegalArgumentException("writer==null");
        }
        if (cs == null) {
            cs = Charset.forName("utf-8");
        }
        FormatXMLWriter fwr = null;
        try {
            fwr = new FormatXMLWriter(writer, cs);
            XmlUtil.write(node, fwr);
            fwr.flush();
        }
        catch (XMLStreamException ex) {
            throw new IOError(ex);
        }
    }

    public static void write(Node node, OutputStream writer) {
        if (node == null) {
            throw new IllegalArgumentException("node==null");
        }
        if (writer == null) {
            throw new IllegalArgumentException("writer==null");
        }
        XmlUtil.write(node, writer, null);
    }

    public static Document parseXml(java.io.File file) {
        if (file == null) {
            throw new IllegalArgumentException("file==null");
        }
        FileInputStream fin = null;
        Document doc = null;
        try {
            fin = new FileInputStream(file);
            doc = XmlUtil.parseXml(fin);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException ex1) {
                    throw new IOError(ex1);
                }
            }
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parseXml(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file==null");
        }
        InputStream fin = null;
        Document doc = null;
        try {
            fin = file.readStream(new OpenOption[0]);
            doc = XmlUtil.parseXml(fin);
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException ex1) {
                    throw new IOError(ex1);
                }
            }
        }
        return doc;
    }

    public static Document parseXml(Path file) {
        if (file == null) {
            throw new IllegalArgumentException("file==null");
        }
        InputStream fin = null;
        Document doc = null;
        try {
            fin = Files.newInputStream(file, new OpenOption[0]);
            doc = XmlUtil.parseXml(fin);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException ex1) {
                    throw new IOError(ex1);
                }
            }
        }
        return doc;
    }

    public static Document parseXml(InputStream xml) {
        if (xml == null) {
            throw new IllegalArgumentException("xml == null");
        }
        DocumentBuilder b = XmlUtil.docBuilder();
        Document res = null;
        if (b != null) {
            InputSource inSrc = new InputSource(xml);
            try {
                res = b.parse(inSrc);
            }
            catch (IOException | SAXException ex) {
                throw new Error(ex.getMessage(), ex);
            }
        }
        return res;
    }

    public static Document parseXml(Reader xml) throws IOException, SAXException {
        if (xml == null) {
            throw new IllegalArgumentException("xml == null");
        }
        DocumentBuilder b = XmlUtil.docBuilder();
        Document res = null;
        if (b != null) {
            InputSource inSrc = new InputSource(xml);
            try {
                res = b.parse(inSrc);
            }
            catch (SAXException ex) {
                throw new Error(ex.getMessage(), ex);
            }
            catch (IOException ex) {
                throw new Error(ex.getMessage(), ex);
            }
        }
        return res;
    }

    public static Document parseXml(String xml) {
        if (xml == null) {
            throw new IllegalArgumentException("xml == null");
        }
        DocumentBuilder b = XmlUtil.docBuilder();
        Document res = null;
        if (b != null) {
            StringReader strRD = new StringReader(xml);
            InputSource inSrc = new InputSource(strRD);
            try {
                res = b.parse(inSrc);
            }
            catch (SAXException ex) {
                throw new Error(ex.getMessage(), ex);
            }
            catch (IOException ex) {
                throw new Error(ex.getMessage(), ex);
            }
            finally {
                strRD.close();
            }
        }
        return res;
    }

    public static String toXMLString(NodeList nodeList) {
        if (nodeList == null) {
            throw new IllegalArgumentException("nodeList == null");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            sb.append(XmlUtil.toXMLString(nodeList.item(i)));
        }
        return sb.toString();
    }

    public static String toXMLString(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("doc == null");
        }
        StringWriter sw = new StringWriter();
        DOMSource srcDom = new DOMSource(node);
        StreamResult resStrm = new StreamResult();
        resStrm.setWriter(sw);
        TransformerFactory tfact = TransformerFactory.newInstance();
        try {
            Transformer transformer = tfact.newTransformer();
            transformer.transform(srcDom, resStrm);
        }
        catch (TransformerConfigurationException ex) {
            Logger.getLogger(XmlUtil.class.getName()).log(Level.SEVERE, null, ex);
            throw new Error(ex.getMessage(), ex);
        }
        catch (TransformerException ex) {
            Logger.getLogger(XmlUtil.class.getName()).log(Level.SEVERE, null, ex);
            throw new Error(ex.getMessage(), ex);
        }
        return sw.toString();
    }

    public static DocumentBuilderFactory docBuilderFactory() {
        if (docBuilderFactory == null) {
            docBuilderFactory = DocumentBuilderFactory.newInstance();
        }
        return docBuilderFactory;
    }

    public static DocumentBuilder docBuilder() {
        if (builder == null) {
            try {
                builder = XmlUtil.docBuilderFactory().newDocumentBuilder();
            }
            catch (ParserConfigurationException ex) {
                builder = null;
                throw new Error(ex.getMessage(), ex);
            }
        }
        return builder;
    }

    public static Document createDocument() {
        DocumentBuilder b = XmlUtil.docBuilder();
        Document res = null;
        if (b != null) {
            res = b.newDocument();
        }
        return res;
    }

    public static void visit(Visitor<Node> visitor, Node start) {
        if (start == null) {
            throw new IllegalArgumentException("start==null");
        }
        if (visitor == null) {
            throw new IllegalArgumentException("visitor==null");
        }
        BasicVisitor.visit(visitor, (Object)start, XmlUtil.followers());
    }

    public static Eterable<Node> children(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("node==null");
        }
        if (!node.hasChildNodes()) {
            return Eterable.empty();
        }
        return XmlUtil.iterable(node.getChildNodes());
    }

    public static Eterable<Element> elements(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("node==null");
        }
        if (!node.hasChildNodes()) {
            return Eterable.empty();
        }
        return XmlUtil.iterable(node.getChildNodes()).filter(Predicates.isElement).map(from -> from instanceof Element ? (Element)from : null);
    }

    public static Eterable<Node> iterable(NodeList nl) {
        return new XMLNodeIterable(nl);
    }

    public static Eterable<TreeStep<Node>> tree(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("node==null");
        }
        TreeIterBuilder e = Eterable.tree((Object)node, XmlUtil.followers());
        return e.go();
    }

    public static Eterable<Node> walk(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("node==null");
        }
        return Eterable.tree((Object)node, XmlUtil.followers()).walk();
    }

    public static boolean isElement(Node node) {
        return node instanceof Element;
    }

    public static boolean isText(Node node) {
        return node instanceof Text;
    }

    public static boolean isComment(Node node) {
        return node instanceof Comment;
    }

    public static boolean isDocument(Node node) {
        return node instanceof Document;
    }

    public static String getTagName(Node node) {
        if (!(node instanceof Element)) {
            return node.getNodeName();
        }
        return ((Element)node).getTagName();
    }

    public static String getText(Node n) {
        if (n == null) {
            throw new IllegalArgumentException("n == null");
        }
        final StringBuilder sb = new StringBuilder();
        Visitor<Node> v = new Visitor<Node>(){

            public boolean enter(Node n) {
                if (n instanceof Text) {
                    sb.append(n.getNodeValue());
                }
                return true;
            }

            public void exit(Node n) {
            }
        };
        XmlUtil.visit(v, n);
        return sb.toString();
    }

    public static Map<String, String> asMap(NamedNodeMap nnm) {
        if (nnm == null) {
            throw new IllegalArgumentException("nnm==null");
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int ai = 0; ai < nnm.getLength(); ++ai) {
            Node na = nnm.item(ai);
            if (na == null) continue;
            String name = na.getNodeName();
            String value = na.getNodeValue();
            if (name == null) continue;
            if (value == null) {
                value = "";
            }
            map.put(name, value);
        }
        return map;
    }

    public static Map<String, String> getAttrs(Node n) {
        if (n == null) {
            throw new IllegalArgumentException("n==null");
        }
        if (!(n instanceof Element)) {
            return new LinkedHashMap<String, String>();
        }
        Element el = (Element)n;
        NamedNodeMap nnm = el.getAttributes();
        if (nnm != null) {
            return XmlUtil.asMap(nnm);
        }
        return new LinkedHashMap<String, String>();
    }

    public static String getAttribute(Node n, String name) {
        if (n == null) {
            throw new IllegalArgumentException("n == null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name == null");
        }
        NamedNodeMap nnm = n.getAttributes();
        if (nnm != null) {
            for (int ai = 0; ai < nnm.getLength(); ++ai) {
                Node na = nnm.item(ai);
                if (na == null) continue;
                String aname = na.getNodeName();
                String avalue = na.getNodeValue();
                if (aname == null || !name.equals(aname)) continue;
                return avalue;
            }
        }
        return null;
    }

    public static NodesExtracter<Node, Node> followers() {
        return XmlUtil.followers(true);
    }

    public static NodesExtracter<Node, Node> followers(final boolean detectCycle) {
        return new NodesExtracter<Node, Node>(){
            protected Set<Node> visited;

            public Iterable<Node> extract(Node from) {
                Document d;
                Element e;
                if (from == null) {
                    return null;
                }
                if (detectCycle) {
                    if (this.visited == null) {
                        this.visited = new LinkedHashSet<Node>();
                    }
                    if (this.visited.contains(from)) {
                        Logger.getLogger(XmlUtil.class.getName()).log(Level.WARNING, "detect cycle in xml dom");
                        return null;
                    }
                    this.visited.add(from);
                }
                if (from instanceof Element) {
                    return XmlUtil.iterable(((Element)from).getChildNodes());
                }
                if (from instanceof Document && (e = (d = (Document)from).getDocumentElement()) instanceof Node) {
                    return Eterable.single((Object)e);
                }
                return null;
            }
        };
    }

    public static synchronized XPathFactory getXPathFactory() {
        if (xpathFactory == null) {
            xpathFactory = XPathFactory.newInstance();
        }
        return xpathFactory;
    }

    public static synchronized XPath getXPath() {
        XPathFactory f;
        if (xpath == null && (f = XmlUtil.getXPathFactory()) != null) {
            xpath = f.newXPath();
        }
        return xpath;
    }

    public static XPathQuery xpath(Node node, String query) {
        if (node == null) {
            throw new IllegalArgumentException("node==null");
        }
        if (query == null) {
            throw new IllegalArgumentException("query==null");
        }
        return new XPathQuery(node, query);
    }

    public static class Predicates {
        public static final Predicate<Node> isElement = value -> {
            if (value == null) {
                return false;
            }
            return value instanceof Element;
        };

        public static Predicate<Node> nodeName(Predicate<String> nodeNamePredicate) {
            return value -> {
                if (value == null) {
                    return false;
                }
                if (nodeNamePredicate == null) {
                    return false;
                }
                return nodeNamePredicate.test(value.getNodeName());
            };
        }

        public static Predicate<Node> nodeName(String nodeName, boolean ignoreCase) {
            return Predicates.nodeName(ignoreCase ? Text.Predicates.equalsIgnoreCase((String)nodeName) : Text.Predicates.equals((String)nodeName));
        }

        public static Predicate<Node> and(Predicate<Node> ... preds) {
            return xyz.cofe.ecolls.Predicates.and((Predicate[])preds);
        }

        public static Predicate<Node> or(Predicate<Node> ... preds) {
            return xyz.cofe.ecolls.Predicates.or((Predicate[])preds);
        }

        public static Predicate<Node> not(Predicate<Node> pred) {
            return xyz.cofe.ecolls.Predicates.not(pred);
        }
    }

    public static class XPathQuery {
        protected XPath xpath;
        protected Node context;
        protected String query = null;

        public XPathQuery(Node node) {
            this.context = node;
        }

        public XPathQuery(Node node, String queryString) {
            this.context = node;
            this.query = queryString;
        }

        public XPathQuery(Node node, XPath xpath) {
            this.context = node;
            this.xpath = xpath;
        }

        public XPathQuery(Node node, String queryString, XPath xpath) {
            this.context = node;
            this.query = queryString;
            this.xpath = xpath;
        }

        public XPathQuery(XPathQuery sample) {
            if (sample != null) {
                this.xpath = sample.xpath;
                this.context = sample.context;
                this.query = sample.query;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public XPathQuery clone() {
            XPathQuery xPathQuery = this;
            synchronized (xPathQuery) {
                return new XPathQuery(this.context, this.xpath);
            }
        }

        public synchronized XPath getXpath() {
            if (this.xpath == null) {
                this.xpath = XmlUtil.getXPath();
            }
            return this.xpath;
        }

        public synchronized void setXpath(XPath xpath) {
            this.xpath = xpath;
        }

        public XPathQuery xpath(XPath xpath) {
            this.setXpath(xpath);
            return this;
        }

        public synchronized Node getContext() {
            return this.context;
        }

        public synchronized void setContext(Node context) {
            this.context = context;
        }

        public XPathQuery context(Node node) {
            this.setContext(node);
            return this;
        }

        public synchronized String getQuery() {
            return this.query;
        }

        public synchronized void setQuery(String query) {
            this.query = query;
        }

        public XPathQuery query(String query) {
            this.setQuery(query);
            return this;
        }

        public synchronized String getString() {
            XPath xpath = this.getXpath();
            if (xpath == null) {
                throw new IllegalStateException("xpath not set");
            }
            if (this.context == null) {
                throw new IllegalStateException("node not set");
            }
            if (this.query == null) {
                throw new IllegalStateException("query not set");
            }
            try {
                return (String)xpath.evaluate(this.query, this.context, XPathConstants.STRING);
            }
            catch (XPathExpressionException ex) {
                throw new Error(ex.getMessage(), ex);
            }
        }

        public String as(String defaultValue) {
            String v = this.getString();
            return v != null ? v : defaultValue;
        }

        public synchronized NodeList getNodeList() {
            XPath xpath = this.getXpath();
            if (xpath == null) {
                throw new IllegalStateException("xpath not set");
            }
            if (this.context == null) {
                throw new IllegalStateException("node not set");
            }
            if (this.query == null) {
                throw new IllegalStateException("query not set");
            }
            try {
                return (NodeList)xpath.evaluate(this.query, this.context, XPathConstants.NODESET);
            }
            catch (XPathExpressionException ex) {
                throw new Error(ex.getMessage(), ex);
            }
        }

        public NodeList as(NodeList defaultValue) {
            NodeList v = this.getNodeList();
            return v != null ? v : defaultValue;
        }

        public synchronized Node getNode() {
            XPath xpath = this.getXpath();
            if (xpath == null) {
                throw new IllegalStateException("xpath not set");
            }
            if (this.context == null) {
                throw new IllegalStateException("context not set");
            }
            if (this.query == null) {
                throw new IllegalStateException("query not set");
            }
            try {
                return (Node)xpath.evaluate(this.query, this.context, XPathConstants.NODE);
            }
            catch (XPathExpressionException ex) {
                throw new Error(ex.getMessage(), ex);
            }
        }

        public Node as(Node defaultValue) {
            Node v = this.getNode();
            return v != null ? v : defaultValue;
        }

        public synchronized Double getDouble() {
            XPath xpath = this.getXpath();
            if (xpath == null) {
                throw new IllegalStateException("xpath not set");
            }
            if (this.context == null) {
                throw new IllegalStateException("node not set");
            }
            if (this.query == null) {
                throw new IllegalStateException("query not set");
            }
            try {
                return (Double)xpath.evaluate(this.query, this.context, XPathConstants.NUMBER);
            }
            catch (XPathExpressionException ex) {
                throw new Error(ex.getMessage(), ex);
            }
        }

        public Double as(Double defaultValue) {
            Double v = this.getDouble();
            return v != null ? v : defaultValue;
        }

        public synchronized Boolean getBoolean() {
            XPath xpath = this.getXpath();
            if (xpath == null) {
                throw new IllegalStateException("xpath not set");
            }
            if (this.context == null) {
                throw new IllegalStateException("node not set");
            }
            if (this.query == null) {
                throw new IllegalStateException("query not set");
            }
            try {
                return (Boolean)xpath.evaluate(this.query, this.context, XPathConstants.BOOLEAN);
            }
            catch (XPathExpressionException ex) {
                throw new Error(ex.getMessage(), ex);
            }
        }

        public Boolean as(Boolean defaultValue) {
            Boolean v = this.getBoolean();
            return v != null ? v : defaultValue;
        }
    }
}

