/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.xml.stream.path;

import java.util.function.Predicate;
import javax.xml.stream.events.XMLEvent;
import xyz.cofe.text.Text;
import xyz.cofe.xml.stream.path.ParentMatcher;
import xyz.cofe.xml.stream.path.PathExpression;
import xyz.cofe.xml.stream.path.TagMatcher;

public class Expressions {
    private static PathExpression rootPath = value -> {
        if (value == null) {
            return false;
        }
        for (XMLEvent e : value) {
            if (e.isStartDocument()) continue;
            return false;
        }
        return true;
    };

    public static PathExpression rootPath() {
        return rootPath;
    }

    public static PathExpression andPath(PathExpression ... expressions) {
        if (expressions == null) {
            throw new IllegalArgumentException("expressions==null");
        }
        PathExpression[] exp = expressions;
        return value -> {
            for (PathExpression e : exp) {
                if (e == null || e.test(value)) continue;
                return false;
            }
            return true;
        };
    }

    public static PathExpression orPath(PathExpression ... expressions) {
        if (expressions == null) {
            throw new IllegalArgumentException("expressions==null");
        }
        PathExpression[] exp = expressions;
        return value -> {
            for (PathExpression e : exp) {
                if (e == null || !e.test(value)) continue;
                return true;
            }
            return false;
        };
    }

    public static PathExpression notPath(PathExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression==null");
        }
        PathExpression exp = expression;
        return value -> !exp.test(value);
    }

    public static PathExpression parentPath(PathExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression==null");
        }
        return new ParentMatcher(expression);
    }

    public static PathExpression hasAttribute(String name, boolean ignoreCase) {
        if (name == null) {
            throw new IllegalArgumentException("name==null");
        }
        return new TagMatcher(TagMatcher.hasAttribute(name, ignoreCase));
    }

    public static PathExpression hasAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name==null");
        }
        return new TagMatcher(TagMatcher.hasAttribute(name, false));
    }

    public static PathExpression attr(Predicate<String> namePredicate, Predicate<String> valuePredicate) {
        if (namePredicate == null) {
            throw new IllegalArgumentException("namePredicate==null");
        }
        if (valuePredicate == null) {
            throw new IllegalArgumentException("valuePredicate==null");
        }
        return new TagMatcher(TagMatcher.attr(namePredicate, valuePredicate));
    }

    public static PathExpression attrIsNumeric(String attrName) {
        return Expressions.attr(Text.Predicates.equals((String)attrName), Text.Predicates.isNumeric());
    }

    public static PathExpression tagNameEquals(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name==null");
        }
        return new TagMatcher(TagMatcher.nameEquals(name));
    }

    public static PathExpression tagNameEqualsIgnoreCase(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name==null");
        }
        return new TagMatcher(TagMatcher.nameEqualsIgnoreCase(name));
    }

    public static PathExpression tagNameMatches(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name==null");
        }
        return new TagMatcher(TagMatcher.nameMatches(name));
    }
}

