/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.xml.stream.path;

import java.util.List;
import xyz.cofe.collection.Pointer;
import xyz.cofe.text.Text;
import xyz.cofe.text.lex.Keyword;
import xyz.cofe.text.lex.Keywords;
import xyz.cofe.text.lex.KeywordsParser;
import xyz.cofe.text.lex.LexerUtil;
import xyz.cofe.text.lex.ListLexer;
import xyz.cofe.text.lex.TagName;
import xyz.cofe.text.lex.TagNameParser;
import xyz.cofe.text.lex.Token;
import xyz.cofe.text.lex.WhiteSpace;
import xyz.cofe.text.lex.WhiteSpaceParser;
import xyz.cofe.xml.stream.path.Expressions;
import xyz.cofe.xml.stream.path.PathExpression;

public class PathParser {
    public PathExpression parse(String text) {
        if (text == null) {
            throw new IllegalArgumentException("text==null");
        }
        List<Token> toks = this.lexParse(text);
        Pointer ptr = new Pointer(toks);
        return this.parsePath((Pointer<Token>)ptr);
    }

    protected PathExpression tagPattern(Pointer<Token> ptr) {
        Keyword k;
        Token t = (Token)ptr.lookup(0);
        if (t == null) {
            return null;
        }
        if (t instanceof Keyword && (k = (Keyword)t).getKeyword().equals("*")) {
            ptr.move(1);
            return Expressions.tagNameMatches(Text.wildcard((String)"*", (boolean)false, (boolean)true).pattern());
        }
        if (t instanceof TagName) {
            TagName tn = (TagName)t;
            ptr.move(1);
            return Expressions.tagNameEquals(tn.getLocalName());
        }
        return null;
    }

    protected PathExpression parsePath(Pointer<Token> ptr) {
        Keyword k;
        PathExpression eTag;
        PathExpression e = null;
        boolean rootExp = false;
        Token t = null;
        t = (Token)ptr.lookup(0);
        if (t == null) {
            return null;
        }
        boolean rootPath = false;
        if (t instanceof Keyword) {
            Keyword k2 = (Keyword)t;
            if (k2.getKeyword().equals("/")) {
                e = Expressions.rootPath();
                ptr.move(1);
                rootExp = true;
            } else {
                return null;
            }
        }
        if ((eTag = this.tagPattern(ptr)) == null) {
            return e;
        }
        PathExpression pathExpression = e = e != null ? Expressions.andPath(Expressions.parentPath(e), eTag) : eTag;
        while ((t = (Token)ptr.lookup(0)) instanceof Keyword && (k = (Keyword)t).getKeyword().equals("/")) {
            ptr.move(1);
            eTag = this.tagPattern(ptr);
            if (eTag == null) break;
            e = Expressions.andPath(Expressions.parentPath(e), eTag);
        }
        return e;
    }

    protected ListLexer createLexer() {
        ListLexer ll = new ListLexer();
        KeywordsParser kw = new KeywordsParser("op");
        kw.setKeywords(new Keywords(false).put("/").put("*"));
        ll.getParsers().add(kw);
        TagNameParser tn = new TagNameParser("tag");
        ll.getParsers().add(tn);
        WhiteSpaceParser ws = new WhiteSpaceParser("ws");
        ll.getParsers().add(ws);
        return ll;
    }

    protected List<Token> lexParse(String text) {
        ListLexer ll = this.createLexer();
        List toks = ll.parse(text, obj -> System.out.println("lexer error " + obj));
        toks = LexerUtil.filter((List)toks, (Class[])new Class[]{WhiteSpace.class});
        return toks;
    }
}

