/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.xml.stream.path;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.graph.Path;
import xyz.cofe.fn.Fn2;
import xyz.cofe.typeconv.ExtendedCastGraph;
import xyz.cofe.typeconv.TypeCastGraph;
import xyz.cofe.xml.stream.path.PathExpression;
import xyz.cofe.xml.stream.path.PathMatch;
import xyz.cofe.xml.stream.path.PathParser;
import xyz.cofe.xml.stream.path.XEventPath;
import xyz.cofe.xml.stream.path.XVisitor;

public class XVisitorAdapter
implements XVisitor {
    protected final List<PathPattern> pathPatterns = new ArrayList<PathPattern>();
    protected final List<ContentPattern> contentPatterns = new ArrayList<ContentPattern>();
    protected TypeCastGraph typeCastGraph;

    public XVisitorAdapter() {
        TypeCastGraph tcg = this.getTypeCastGraph();
        Method[] methods = this.getClass().getMethods();
        PathParser parser = new PathParser();
        for (Method m : methods) {
            ContentPatternMethod mcd;
            Path p;
            PathMatch pm = m.getAnnotation(PathMatch.class);
            if (pm == null) continue;
            Class<?>[] params = m.getParameterTypes();
            if (params.length == 1) {
                if (XEventPath.class.equals(params[0])) {
                    PathPatternMethod mpd;
                    if (pm.enter().length() > 0) {
                        mpd = new PathPatternMethod();
                        mpd.setExpression(parser.parse(pm.enter()));
                        mpd.setEnter(true);
                        mpd.setExit(false);
                        mpd.setOwner(this);
                        mpd.setMethod(m);
                        this.pathPatterns.add(mpd);
                    }
                    if (pm.exit().length() <= 0) continue;
                    mpd = new PathPatternMethod();
                    mpd.setExpression(parser.parse(pm.exit()));
                    mpd.setEnter(false);
                    mpd.setExit(true);
                    mpd.setOwner(this);
                    mpd.setMethod(m);
                    this.pathPatterns.add(mpd);
                    continue;
                }
                if (!String.class.equals(params[0]) || pm.content().length() <= 0) continue;
                ContentPatternMethod mcd2 = new ContentPatternMethod();
                mcd2.setTypeCastGraph(tcg);
                mcd2.setExpression(parser.parse(pm.content()));
                mcd2.setMethod(m);
                mcd2.setOwner(this);
                mcd2.setArgs(new int[]{2});
                this.contentPatterns.add(mcd2);
                continue;
            }
            if (params.length != 2) continue;
            if (XEventPath.class.equals(params[0]) && (p = tcg.findPath(String.class, params[1])) != null && pm.content().length() > 0) {
                mcd = new ContentPatternMethod();
                mcd.setTypeCastGraph(tcg);
                mcd.setExpression(parser.parse(pm.content()));
                mcd.setMethod(m);
                mcd.setOwner(this);
                mcd.setArgs(new int[]{1, 2});
                this.contentPatterns.add(mcd);
            }
            if (!XEventPath.class.equals(params[1]) || (p = tcg.findPath(String.class, params[0])) == null || pm.content().length() <= 0) continue;
            mcd = new ContentPatternMethod();
            mcd.setTypeCastGraph(tcg);
            mcd.setExpression(parser.parse(pm.content()));
            mcd.setMethod(m);
            mcd.setOwner(this);
            mcd.setArgs(new int[]{2, 1});
            this.contentPatterns.add(mcd);
        }
    }

    public List<PathPattern> getPathPatterns() {
        return this.pathPatterns;
    }

    public List<ContentPattern> getContentPatterns() {
        return this.contentPatterns;
    }

    public PatternBuilder pattern(String expr) {
        return new PatternBuilder(this).expression(expr);
    }

    public PatternBuilder pattern(PathExpression expr) {
        return new PatternBuilder(this).expression(expr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeCastGraph getTypeCastGraph() {
        XVisitorAdapter xVisitorAdapter = this;
        synchronized (xVisitorAdapter) {
            if (this.typeCastGraph != null) {
                return this.typeCastGraph;
            }
            this.typeCastGraph = new ExtendedCastGraph();
            return this.typeCastGraph;
        }
    }

    public void setTypeCastGraph(TypeCastGraph typeCastGraph) {
        this.typeCastGraph = typeCastGraph;
    }

    public XVisitorAdapter typeCast(TypeCastGraph tc) {
        this.typeCastGraph = tc;
        return this;
    }

    @Override
    public void enter(XEventPath path) {
        if (path == null) {
            return;
        }
        for (PathPattern mpd : this.pathPatterns) {
            if (mpd == null || mpd.getExpression() == null || !mpd.isEnter() || !mpd.getExpression().test(path)) continue;
            mpd.delegate(path);
        }
    }

    @Override
    public void exit(XEventPath path) {
        if (path == null) {
            return;
        }
        for (PathPattern mpd : this.pathPatterns) {
            if (mpd == null || mpd.getExpression() == null || !mpd.isExit() || !mpd.getExpression().test(path)) continue;
            mpd.delegate(path);
        }
    }

    @Override
    public void characters(XEventPath path, String text) {
        if (path == null) {
            return;
        }
        for (ContentPattern mcd : this.contentPatterns) {
            if (mcd == null || mcd.getExpression() == null || !mcd.getExpression().test(path)) continue;
            mcd.delegate(path, text);
        }
    }

    public static class PathPatternMethod
    extends PathPatternAbstract {
        private Object owner;
        private Method method;

        public PathPatternMethod() {
        }

        public PathPatternMethod(PathExpression pexp, boolean enter, boolean exit, Object ownr, Method meth) {
            super(pexp, enter, exit);
            this.owner = ownr;
            this.method = meth;
        }

        public Object getOwner() {
            return this.owner;
        }

        public void setOwner(Object owner) {
            this.owner = owner;
        }

        public Method getMethod() {
            return this.method;
        }

        public void setMethod(Method method) {
            this.method = method;
        }

        @Override
        public void delegate(XEventPath path) {
            try {
                this.method.invoke(this.owner, path);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(XVisitorAdapter.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(XVisitorAdapter.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(XVisitorAdapter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static class ContentPatternMethod
    extends ContentPatternAbstract {
        private Object owner;
        private Method method;
        private TypeCastGraph typeCastGraph;
        public static final int ARG_PATH = 1;
        public static final int ARG_CONTENT = 2;
        private int[] args = new int[0];

        public Object getOwner() {
            return this.owner;
        }

        public void setOwner(Object owner) {
            this.owner = owner;
        }

        public Method getMethod() {
            return this.method;
        }

        public void setMethod(Method method) {
            this.method = method;
        }

        public TypeCastGraph getTypeCastGraph() {
            return this.typeCastGraph;
        }

        public void setTypeCastGraph(TypeCastGraph typeCastGraph) {
            this.typeCastGraph = typeCastGraph;
        }

        public int[] getArgs() {
            return this.args;
        }

        public void setArgs(int[] args) {
            this.args = args;
        }

        @Override
        public void delegate(XEventPath path, String content) {
            try {
                int[] args = this.args;
                if (args == null) {
                    throw new IllegalStateException("property args is null");
                }
                Object[] params = new Object[args.length];
                block8: for (int ai = 0; ai < args.length; ++ai) {
                    switch (args[ai]) {
                        case 1: {
                            params[ai] = path;
                            continue block8;
                        }
                        case 2: {
                            Object val;
                            Class<?> trgtCls = this.method.getParameterTypes()[ai];
                            String str = content;
                            params[ai] = val = this.typeCastGraph.cast((Object)str, trgtCls);
                        }
                    }
                }
                this.method.invoke(this.owner, params);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(XVisitorAdapter.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(XVisitorAdapter.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(XVisitorAdapter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static class PatternBuilder {
        protected XVisitorAdapter xVisitorAdapter;
        protected PathExpression expression;

        public PatternBuilder(XVisitorAdapter xv) {
            this.xVisitorAdapter = xv;
        }

        public XVisitorAdapter getXVisitorAdapter() {
            return this.xVisitorAdapter;
        }

        public void setXVisitorAdapter(XVisitorAdapter xVisitorAdapter) {
            this.xVisitorAdapter = xVisitorAdapter;
        }

        public PathExpression getExpression() {
            return this.expression;
        }

        public void setExpression(PathExpression expression) {
            this.expression = expression;
        }

        public PatternBuilder expression(PathExpression exp) {
            this.expression = exp;
            return this;
        }

        public PatternBuilder expression(String exp) {
            if (exp != null) {
                PathParser parser = new PathParser();
                this.expression = parser.parse(exp);
            } else {
                this.expression = null;
            }
            return this;
        }

        public EnterPatternBuilder enter(Consumer<XEventPath> ... consumer) {
            EnterPatternBuilder b = new EnterPatternBuilder();
            b.setPatternBuilder(this);
            for (Consumer<XEventPath> r : consumer) {
                b = (EnterPatternBuilder)b.consumer(r);
            }
            return b;
        }

        public ExitPatternBuilder exit(Consumer<XEventPath> ... consumer) {
            ExitPatternBuilder b = new ExitPatternBuilder();
            b.setPatternBuilder(this);
            for (Consumer<XEventPath> r : consumer) {
                b = (ExitPatternBuilder)b.consumer(r);
            }
            return b;
        }

        public TextPatternBuilder text(Fn2<XEventPath, String, Object> ... consumer) {
            TextPatternBuilder b = new TextPatternBuilder();
            b.setPatternBuilder(this);
            for (Fn2<XEventPath, String, Object> r : consumer) {
                b = (TextPatternBuilder)b.consumer(r);
            }
            return b;
        }

        public TextPatternBuilder text(Consumer<String> ... consumer) {
            TextPatternBuilder b = new TextPatternBuilder();
            b.setPatternBuilder(this);
            for (Consumer<String> r : consumer) {
                b = (TextPatternBuilder)b.consumer(r);
            }
            return b;
        }
    }

    public static interface PathPattern {
        public PathExpression getExpression();

        public boolean isEnter();

        public boolean isExit();

        public void delegate(XEventPath var1);
    }

    public static interface ContentPattern {
        public PathExpression getExpression();

        public void delegate(XEventPath var1, String var2);
    }

    static class TextPatternBuilder
    extends ContentPatternBuilder<TextPatternBuilder> {
        TextPatternBuilder() {
        }

        @Override
        protected TextPatternBuilder result() {
            return this;
        }

        public PatternBuilder listen() {
            ContentPatternAbstract ptrn = this.buildContentPattern();
            PatternBuilder pb = this.getPatternBuilder();
            pb.getXVisitorAdapter().getContentPatterns().add(ptrn);
            return pb;
        }
    }

    public static class ExitPatternBuilder
    extends TagPatternBuilder<ExitPatternBuilder> {
        @Override
        protected ExitPatternBuilder result() {
            return this;
        }

        public PatternBuilder listen() {
            PathPatternAbstract ptrn = this.buildPathPattern();
            ptrn.setEnter(false);
            ptrn.setExit(true);
            PatternBuilder pb = this.getPatternBuilder();
            pb.getXVisitorAdapter().getPathPatterns().add(ptrn);
            return pb;
        }
    }

    public static class EnterPatternBuilder
    extends TagPatternBuilder<EnterPatternBuilder> {
        @Override
        protected EnterPatternBuilder result() {
            return this;
        }

        public PatternBuilder listen() {
            PathPatternAbstract ptrn = this.buildPathPattern();
            ptrn.setEnter(true);
            ptrn.setExit(false);
            PatternBuilder pb = this.getPatternBuilder();
            pb.getXVisitorAdapter().getPathPatterns().add(ptrn);
            return pb;
        }
    }

    public static abstract class TagPatternBuilder<T> {
        protected PatternBuilder patternBuilder;
        protected List<Consumer<XEventPath>> consumers;

        public PatternBuilder getPatternBuilder() {
            return this.patternBuilder;
        }

        public void setPatternBuilder(PatternBuilder patternBuilder) {
            this.patternBuilder = patternBuilder;
        }

        public List<Consumer<XEventPath>> getConsumers() {
            if (this.consumers != null) {
                return this.consumers;
            }
            this.consumers = new ArrayList<Consumer<XEventPath>>();
            return this.consumers;
        }

        public void setConsumers(List<Consumer<XEventPath>> consumers) {
            this.consumers = consumers;
        }

        protected abstract T result();

        public T consumer(Consumer<XEventPath> consumer) {
            if (consumer == null) {
                throw new IllegalArgumentException("consumer == null");
            }
            this.getConsumers().add(consumer);
            return this.result();
        }

        public PathPatternAbstract buildPathPattern() {
            final ArrayList<Consumer<XEventPath>> recivers = new ArrayList<Consumer<XEventPath>>(this.getConsumers());
            PathPatternAbstract ppa = new PathPatternAbstract(){

                @Override
                public void delegate(XEventPath path) {
                    for (Consumer r : recivers) {
                        r.accept(path);
                    }
                }
            };
            ppa.setExpression(this.getPatternBuilder().getExpression());
            return ppa;
        }
    }

    public static abstract class ContentPatternBuilder<T> {
        protected PatternBuilder patternBuilder;
        protected List<Fn2<XEventPath, String, Object>> consumers;

        public PatternBuilder getPatternBuilder() {
            return this.patternBuilder;
        }

        public void setPatternBuilder(PatternBuilder patternBuilder) {
            this.patternBuilder = patternBuilder;
        }

        public List<Fn2<XEventPath, String, Object>> getConsumers() {
            if (this.consumers != null) {
                return this.consumers;
            }
            this.consumers = new ArrayList<Fn2<XEventPath, String, Object>>();
            return this.consumers;
        }

        public void setConsumers(List<Fn2<XEventPath, String, Object>> consumers) {
            this.consumers = consumers;
        }

        protected abstract T result();

        public T consumer(Fn2<XEventPath, String, Object> consumer) {
            if (consumer == null) {
                throw new IllegalArgumentException("consumer == null");
            }
            this.getConsumers().add(consumer);
            return this.result();
        }

        public T consumer(Consumer<String> consumer) {
            if (consumer == null) {
                throw new IllegalArgumentException("consumer == null");
            }
            this.getConsumers().add((Fn2<XEventPath, String, Object>)((Fn2)(arg1, arg2) -> {
                consumer.accept((String)arg2);
                return null;
            }));
            return this.result();
        }

        public ContentPatternAbstract buildContentPattern() {
            final ArrayList<Fn2<XEventPath, String, Object>> recivers = new ArrayList<Fn2<XEventPath, String, Object>>(this.getConsumers());
            ContentPatternAbstract ppa = new ContentPatternAbstract(){

                @Override
                public void delegate(XEventPath path, String content) {
                    for (Fn2 r : recivers) {
                        r.apply((Object)path, (Object)content);
                    }
                }
            };
            ppa.setExpression(this.getPatternBuilder().getExpression());
            return ppa;
        }
    }

    public static abstract class ContentPatternAbstract
    implements ContentPattern {
        private PathExpression expression;

        @Override
        public PathExpression getExpression() {
            return this.expression;
        }

        public void setExpression(PathExpression expression) {
            this.expression = expression;
        }

        @Override
        public abstract void delegate(XEventPath var1, String var2);
    }

    public static abstract class PathPatternAbstract
    implements PathPattern {
        private PathExpression expression;
        private boolean enter;
        private boolean exit;

        public PathPatternAbstract() {
        }

        public PathPatternAbstract(PathExpression pexp, boolean enter, boolean exit) {
            this.expression = pexp;
            this.enter = enter;
            this.exit = exit;
        }

        @Override
        public PathExpression getExpression() {
            return this.expression;
        }

        public void setExpression(PathExpression expression) {
            this.expression = expression;
        }

        @Override
        public boolean isEnter() {
            return this.enter;
        }

        public void setEnter(boolean enter) {
            this.enter = enter;
        }

        @Override
        public boolean isExit() {
            return this.exit;
        }

        public void setExit(boolean exit) {
            this.exit = exit;
        }
    }
}

