/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.xml.stream.path;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Source;
import xyz.cofe.xml.stream.path.XEventPath;
import xyz.cofe.xml.stream.path.XVisitor;

public class XmlReader {
    public XmlReader(URL url, Charset cs, XVisitor visitor) throws IOException, XMLStreamException {
        if (url == null) {
            throw new IllegalArgumentException("url==null");
        }
        if (visitor == null) {
            throw new IllegalArgumentException("visitor==null");
        }
        if (cs == null) {
            cs = Charset.defaultCharset();
        }
        InputStream in = url.openStream();
        InputStreamReader reader = new InputStreamReader(in, cs);
        this.init(reader, visitor);
        reader.close();
    }

    public XmlReader(URL url, XVisitor visitor) throws IOException, XMLStreamException {
        if (url == null) {
            throw new IllegalArgumentException("url==null");
        }
        if (visitor == null) {
            throw new IllegalArgumentException("visitor==null");
        }
        InputStream in = url.openStream();
        this.init(in, visitor);
        in.close();
    }

    public XmlReader(File file, XVisitor visitor) throws IOException, XMLStreamException {
        if (file == null) {
            throw new IllegalArgumentException("file==null");
        }
        if (visitor == null) {
            throw new IllegalArgumentException("visitor==null");
        }
        FileInputStream fin = new FileInputStream(file);
        this.init(fin, visitor);
        fin.close();
    }

    public XmlReader(File file, Charset cs, XVisitor visitor) throws IOException, XMLStreamException {
        if (file == null) {
            throw new IllegalArgumentException("file==null");
        }
        if (visitor == null) {
            throw new IllegalArgumentException("visitor==null");
        }
        if (cs == null) {
            cs = Charset.defaultCharset();
        }
        FileInputStream fin = new FileInputStream(file);
        InputStreamReader reader = new InputStreamReader((InputStream)fin, cs);
        this.init(reader, visitor);
        fin.close();
    }

    public XmlReader(Path file, Charset cs, XVisitor visitor) throws IOException, XMLStreamException {
        if (file == null) {
            throw new IllegalArgumentException("file==null");
        }
        if (visitor == null) {
            throw new IllegalArgumentException("visitor==null");
        }
        if (cs == null) {
            cs = Charset.defaultCharset();
        }
        InputStream fin = Files.newInputStream(file, new OpenOption[0]);
        InputStreamReader reader = new InputStreamReader(fin, cs);
        this.init(reader, visitor);
        fin.close();
    }

    public XmlReader(Path file, XVisitor visitor) throws IOException, XMLStreamException {
        if (file == null) {
            throw new IllegalArgumentException("file==null");
        }
        if (visitor == null) {
            throw new IllegalArgumentException("visitor==null");
        }
        InputStream fin = Files.newInputStream(file, new OpenOption[0]);
        this.init(fin, visitor);
        fin.close();
    }

    public XmlReader(xyz.cofe.io.fs.File file, Charset cs, XVisitor visitor) throws IOException, XMLStreamException {
        if (file == null) {
            throw new IllegalArgumentException("file==null");
        }
        if (visitor == null) {
            throw new IllegalArgumentException("visitor==null");
        }
        if (cs == null) {
            cs = Charset.defaultCharset();
        }
        InputStream fin = file.readStream(new OpenOption[0]);
        InputStreamReader reader = new InputStreamReader(fin, cs);
        this.init(reader, visitor);
        fin.close();
    }

    public XmlReader(xyz.cofe.io.fs.File file, XVisitor visitor) throws IOException, XMLStreamException {
        if (file == null) {
            throw new IllegalArgumentException("file==null");
        }
        if (visitor == null) {
            throw new IllegalArgumentException("visitor==null");
        }
        InputStream fin = file.readStream(new OpenOption[0]);
        this.init(fin, visitor);
        fin.close();
    }

    public XmlReader(Reader reader, XVisitor visitor) throws XMLStreamException {
        if (reader == null) {
            throw new IllegalArgumentException("reader==null");
        }
        if (visitor == null) {
            throw new IllegalArgumentException("visitor==null");
        }
        this.init(reader, visitor);
    }

    public XmlReader(InputStream stream, Charset cs, XVisitor visitor) throws XMLStreamException {
        if (stream == null) {
            throw new IllegalArgumentException("stream==null");
        }
        if (cs == null) {
            throw new IllegalArgumentException("cs==null");
        }
        if (visitor == null) {
            throw new IllegalArgumentException("visitor==null");
        }
        InputStreamReader reader = new InputStreamReader(stream, cs);
        this.init(reader, visitor);
    }

    public XmlReader(InputStream stream, XVisitor visitor) throws XMLStreamException {
        if (stream == null) {
            throw new IllegalArgumentException("stream==null");
        }
        if (visitor == null) {
            throw new IllegalArgumentException("visitor==null");
        }
        this.init(stream, visitor);
    }

    public XmlReader(String source, XVisitor visitor) throws XMLStreamException {
        if (source == null) {
            throw new IllegalArgumentException("source==null");
        }
        if (visitor == null) {
            throw new IllegalArgumentException("visitor==null");
        }
        StringReader reader = new StringReader(source);
        this.init(reader, visitor);
    }

    public XmlReader(Source source, XVisitor visitor) throws XMLStreamException {
        if (source == null) {
            throw new IllegalArgumentException("source==null");
        }
        if (visitor == null) {
            throw new IllegalArgumentException("visitor==null");
        }
        this.init(source, visitor);
    }

    public XmlReader(XMLStreamReader source, XVisitor visitor) throws XMLStreamException {
        if (source == null) {
            throw new IllegalArgumentException("source==null");
        }
        if (visitor == null) {
            throw new IllegalArgumentException("visitor==null");
        }
        this.init(source, visitor);
    }

    public XmlReader(XMLEventReader source, XVisitor visitor) throws XMLStreamException {
        if (source == null) {
            throw new IllegalArgumentException("source==null");
        }
        if (visitor == null) {
            throw new IllegalArgumentException("visitor==null");
        }
        this.init(source, visitor);
    }

    protected void init(Reader reader, XVisitor visitor) throws XMLStreamException {
        if (reader == null) {
            throw new IllegalArgumentException("reader==null");
        }
        if (visitor == null) {
            throw new IllegalArgumentException("visitor==null");
        }
        XMLEventReader xmlReader = XMLInputFactory.newFactory().createXMLEventReader(reader);
        this.read(xmlReader, visitor, new XEventPath());
    }

    protected void init(InputStream reader, XVisitor visitor) throws XMLStreamException {
        if (reader == null) {
            throw new IllegalArgumentException("reader==null");
        }
        if (visitor == null) {
            throw new IllegalArgumentException("visitor==null");
        }
        XMLEventReader xmlReader = XMLInputFactory.newFactory().createXMLEventReader(reader);
        this.read(xmlReader, visitor, new XEventPath());
    }

    protected void init(XMLEventReader reader, XVisitor visitor) throws XMLStreamException {
        if (reader == null) {
            throw new IllegalArgumentException("reader==null");
        }
        if (visitor == null) {
            throw new IllegalArgumentException("visitor==null");
        }
        this.read(reader, visitor, new XEventPath());
    }

    protected void init(Source reader, XVisitor visitor) throws XMLStreamException {
        if (reader == null) {
            throw new IllegalArgumentException("reader==null");
        }
        if (visitor == null) {
            throw new IllegalArgumentException("visitor==null");
        }
        XMLEventReader xmlReader = XMLInputFactory.newFactory().createXMLEventReader(reader);
        this.read(xmlReader, visitor, new XEventPath());
    }

    protected void init(XMLStreamReader reader, XVisitor visitor) throws XMLStreamException {
        if (reader == null) {
            throw new IllegalArgumentException("reader==null");
        }
        if (visitor == null) {
            throw new IllegalArgumentException("visitor==null");
        }
        XMLEventReader xmlReader = XMLInputFactory.newFactory().createXMLEventReader(reader);
        this.read(xmlReader, visitor, new XEventPath());
    }

    protected void read(XMLEventReader reader, XVisitor visitor, XEventPath path) throws XMLStreamException {
        while (reader.hasNext()) {
            XMLEvent e = reader.nextEvent();
            if (e.isStartDocument()) {
                path.add(e);
                visitor.enter(path);
                continue;
            }
            if (e.isEndDocument()) {
                visitor.exit(path);
                path.pop();
                continue;
            }
            if (e.isStartElement()) {
                path.add(e);
                visitor.enter(path);
                continue;
            }
            if (e.isEndElement()) {
                visitor.exit(path);
                path.pop();
                continue;
            }
            if (e instanceof Characters) {
                Characters chrs = (Characters)e;
                String chars = chrs.getData();
                visitor.characters(path, chars);
                continue;
            }
            if (e.isNamespace()) {
                path.push(e);
                visitor.enter(path);
                visitor.exit(path);
                path.pop();
                continue;
            }
            if (!e.isProcessingInstruction()) continue;
            path.push(e);
            visitor.enter(path);
            visitor.exit(path);
            path.pop();
        }
    }
}

