package xyz.cofe.text.tparse;

import xyz.cofe.fn.Fn2;

import java.util.List;
import java.util.function.Function;

/**
 * Правило повтора конструкции - т.е. соответ фигурным скобкам черте в грамматике BNF
 * {@link GR}
 * @param <P> Указатель
 * @param <T> Лексема/Токен
 */
public interface RptOP<P extends Pointer<?,?,P>, T extends Tok<P>> {
    /**
     * Возвращает правило - шаблон
     * @return правило - шаблон
     */
    GR<P,T> expression();

    /**
     * Возвращает количество минимальных повторов
     * @return кол-во минимальных повторов, по умолчанию 1
     */
    int min();

    /**
     * Указывает кол-во минимальных повторов
     * @param n кол-во минимальных повторов, по умолчанию 1
     * @return Клон с новыми настройками
     */
    RptOP<P,T> min(int n);

    /**
     * Возвращает кол-во максимальных повторов
     * @return кол-во максимальных повторов, 0 - без ограничения
     */
    int max();

    /**
     * Указывает кол-во максимальных повторов
     * @param n кол-во максимальных повторов, 0 - без ограничения
     * @return Клон с новыми настройками
     */
    RptOP<P,T> max(int n);

    /**
     * Возвращает тип захвата входной последовательности
     * @return true - жадный (максимально возможное кол-во совпадений) / false - не жадный - минимальное необходимое
     */
    boolean greedly();

    /**
     * Указывает тип захвата входной последовательности
     * @param b true - жадный (максимально возможное кол-во совпадений) / false - не жадный - минимальное необходимое
     * @return Клон с новыми настройками
     */
    RptOP<P,T> greedly(boolean b);

    /**
     * Отображение захваеченной последовательности токенов на результируещий токен
     * @param map функция отображения
     * @param <U> результирующий токен
     * @return грамматическое правило
     */
    <U extends Tok<P>> GR<P,U> map(Function<List<T>,U> map);
}
