/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.tparse;

import java.util.Iterator;
import java.util.Optional;
import java.util.function.Function;
import xyz.cofe.iter.Eterable;
import xyz.cofe.text.tparse.AltOP;
import xyz.cofe.text.tparse.GR;
import xyz.cofe.text.tparse.MapResultError;
import xyz.cofe.text.tparse.Pointer;
import xyz.cofe.text.tparse.Tok;

public class AltOPImpl<P extends Pointer<?, ?, P>, T extends Tok<P>>
implements AltOP<P, T> {
    private final Eterable<GR<P, T>> exps;

    public AltOPImpl(GR<P, T> ... exps) {
        if (exps == null) {
            throw new IllegalArgumentException("exps==null");
        }
        this.exps = Eterable.of((Object[])exps);
    }

    public AltOPImpl(Iterable<GR<P, T>> exps) {
        if (exps == null) {
            throw new IllegalArgumentException("exps==null");
        }
        this.exps = Eterable.of(exps);
    }

    @Override
    public Eterable<GR<P, T>> expressions() {
        return this.exps;
    }

    @Override
    public <U extends Tok<P>> GR<P, U> map(final Function<T, U> map) {
        if (map == null) {
            throw new IllegalArgumentException("map==null");
        }
        return new GR<P, U>(){
            private String name;

            @Override
            public GR<P, U> name(String name) {
                this.name = name;
                return this;
            }

            @Override
            public String name() {
                return this.name;
            }

            public String toString() {
                if (this.name != null) {
                    return this.name;
                }
                return super.toString();
            }

            @Override
            public Optional<U> apply(P ptr) {
                if (ptr == null) {
                    throw new IllegalArgumentException("ptr==null");
                }
                Iterator grIt = AltOPImpl.this.exps.iterator();
                if (grIt == null) {
                    return Optional.empty();
                }
                Optional found = Optional.empty();
                while (grIt.hasNext()) {
                    GR gr = (GR)grIt.next();
                    if (gr == null || (found = (Optional)gr.apply(ptr)) == null || !found.isPresent()) continue;
                    Object p = ((Tok)found.get()).end();
                    if (p == null) {
                        throw new MapResultError("token return null on end");
                    }
                    if (ptr.compareTo(p) < 0) break;
                    throw new MapResultError("bug of parser, end pointer as begin");
                }
                if (found != null && found.isPresent()) {
                    return Optional.of((Tok)map.apply((Tok)found.get()));
                }
                return Optional.empty();
            }
        };
    }
}

