/*
 * Decompiled with CFR 0.152.
 */
package xyz.danoz.recyclerviewfastscroller;

import android.support.annotation.Nullable;
import android.view.MotionEvent;
import android.view.View;
import xyz.danoz.recyclerviewfastscroller.AbsRecyclerViewFastScroller;
import xyz.danoz.recyclerviewfastscroller.sectionindicator.SectionIndicator;

class FastScrollerTouchListener
implements View.OnTouchListener {
    private final AbsRecyclerViewFastScroller mFastScroller;

    public FastScrollerTouchListener(AbsRecyclerViewFastScroller fastScroller) {
        this.mFastScroller = fastScroller;
    }

    public boolean onTouch(View v, MotionEvent event) {
        SectionIndicator sectionIndicator = this.mFastScroller.getSectionIndicator();
        this.showOrHideIndicator(sectionIndicator, event);
        float scrollProgress = this.mFastScroller.getScrollProgress(event);
        this.mFastScroller.scrollTo(scrollProgress, true);
        this.mFastScroller.moveHandleToPosition(scrollProgress);
        return true;
    }

    private void showOrHideIndicator(@Nullable SectionIndicator sectionIndicator, MotionEvent event) {
        if (sectionIndicator == null) {
            return;
        }
        switch (event.getActionMasked()) {
            case 0: {
                sectionIndicator.animateAlpha(1.0f);
                return;
            }
            case 1: {
                sectionIndicator.animateAlpha(0.0f);
            }
        }
    }
}

