/*
 * Decompiled with CFR 0.152.
 */
package xyz.danoz.recyclerviewfastscroller.vertical;

import android.content.Context;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import xyz.danoz.recyclerviewfastscroller.AbsRecyclerViewFastScroller;
import xyz.danoz.recyclerviewfastscroller.R;
import xyz.danoz.recyclerviewfastscroller.RecyclerViewScroller;
import xyz.danoz.recyclerviewfastscroller.calculation.VerticalScrollBoundsProvider;
import xyz.danoz.recyclerviewfastscroller.calculation.position.VerticalScreenPositionCalculator;
import xyz.danoz.recyclerviewfastscroller.calculation.progress.TouchableScrollProgressCalculator;
import xyz.danoz.recyclerviewfastscroller.calculation.progress.VerticalLinearLayoutManagerScrollProgressCalculator;
import xyz.danoz.recyclerviewfastscroller.calculation.progress.VerticalScrollProgressCalculator;

public class VerticalRecyclerViewFastScroller
extends AbsRecyclerViewFastScroller
implements RecyclerViewScroller {
    @Nullable
    private VerticalScrollProgressCalculator mScrollProgressCalculator;
    @Nullable
    private VerticalScreenPositionCalculator mScreenPositionCalculator;

    public VerticalRecyclerViewFastScroller(Context context) {
        this(context, null);
    }

    public VerticalRecyclerViewFastScroller(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public VerticalRecyclerViewFastScroller(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected int getLayoutResourceId() {
        return R.layout.vertical_recycler_fast_scroller_layout;
    }

    @Override
    @Nullable
    protected TouchableScrollProgressCalculator getScrollProgressCalculator() {
        return this.mScrollProgressCalculator;
    }

    @Override
    public void moveHandleToPosition(float scrollProgress) {
        if (this.mScreenPositionCalculator == null) {
            return;
        }
        this.mHandle.setY(this.mScreenPositionCalculator.getYPositionFromScrollProgress(scrollProgress));
    }

    @Override
    protected void onCreateScrollProgressCalculator() {
        VerticalScrollBoundsProvider boundsProvider = new VerticalScrollBoundsProvider(this.mBar.getY(), this.mBar.getY() + (float)this.mBar.getHeight() - (float)this.mHandle.getHeight());
        this.mScrollProgressCalculator = new VerticalLinearLayoutManagerScrollProgressCalculator(boundsProvider);
        this.mScreenPositionCalculator = new VerticalScreenPositionCalculator(boundsProvider);
    }
}

