/*
 * Decompiled with CFR 0.152.
 */
package xyz.downgoon.snowflake.util;

public class BinHexUtil {
    private static final String ZERO_PADDING_64 = "0000000000000000000000000000000000000000000000000000000000000000";
    private static final String ZERO_PADDING_16 = "0000000000000000";

    public static String bin(long d) {
        return BinHexUtil.leftZeroPadding64(Long.toBinaryString(d));
    }

    public static String hex(long d) {
        return BinHexUtil.leftZeroPadding16(Long.toHexString(d).toUpperCase());
    }

    public static long diode(int offset, int length) {
        if (offset < 0 || length < 0 || offset + length > 64) {
            throw new IllegalArgumentException("bits ranges: [0, 64)");
        }
        if (length == 0) {
            return 0L;
        }
        if (length == 64) {
            return -1L;
        }
        int lb = 64 - offset;
        int rb = 64 - (offset + length);
        return -1L << lb ^ -1L << rb;
    }

    private static String leftZeroPadding64(String text) {
        return ZERO_PADDING_64.substring(text.length()) + text;
    }

    private static String leftZeroPadding16(String text) {
        return ZERO_PADDING_16.substring(text.length()) + text;
    }
}

