/*
 * Decompiled with CFR 0.152.
 */
package xyz.dynxsty.dih4jda;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.events.session.ReadyEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import xyz.dynxsty.dih4jda.DIH4JDALogger;
import xyz.dynxsty.dih4jda.InteractionHandler;
import xyz.dynxsty.dih4jda.config.DIH4JDAConfig;
import xyz.dynxsty.dih4jda.events.DIH4JDAEventListener;
import xyz.dynxsty.dih4jda.exceptions.DIH4JDAException;
import xyz.dynxsty.dih4jda.exceptions.InvalidConfigurationException;
import xyz.dynxsty.dih4jda.interactions.commands.application.ContextCommand;
import xyz.dynxsty.dih4jda.interactions.commands.application.RegistrationType;
import xyz.dynxsty.dih4jda.interactions.commands.application.SlashCommand;
import xyz.dynxsty.dih4jda.interactions.components.ButtonHandler;
import xyz.dynxsty.dih4jda.interactions.components.EntitySelectMenuHandler;
import xyz.dynxsty.dih4jda.interactions.components.IdMapping;
import xyz.dynxsty.dih4jda.interactions.components.ModalHandler;
import xyz.dynxsty.dih4jda.interactions.components.StringSelectMenuHandler;

public class DIH4JDA
extends ListenerAdapter {
    private static RegistrationType defaultRegistrationType = RegistrationType.GLOBAL;
    private IdMapping<ButtonHandler>[] buttonMappings = null;
    private IdMapping<StringSelectMenuHandler>[] stringSelectMenuMappings = null;
    private IdMapping<EntitySelectMenuHandler>[] entitySelectMenuMappings = null;
    private IdMapping<ModalHandler>[] modalMappings = null;
    private final DIH4JDAConfig config;
    private final Set<DIH4JDAEventListener> listeners;
    private final InteractionHandler handler;

    public DIH4JDA(@Nonnull DIH4JDAConfig config) throws DIH4JDAException {
        this.validateConfig(config);
        this.config = config;
        DIH4JDALogger.blockedLogTypes = config.getBlockedLogTypes();
        this.handler = new InteractionHandler(this);
        this.config.getJda().addEventListener(new Object[]{this, this.handler});
        this.listeners = new HashSet<DIH4JDAEventListener>();
    }

    public void onReady(@Nonnull ReadyEvent event) {
        if (this.config.getCommandsPackages() == null) {
            return;
        }
        if (this.config.isRegisterOnReady() && this.handler != null) {
            this.handler.registerInteractions();
        }
    }

    public static void setDefaultRegistrationType(@Nonnull RegistrationType type) {
        defaultRegistrationType = type;
    }

    @Nonnull
    public static RegistrationType getDefaultRegistrationType() {
        return defaultRegistrationType;
    }

    public void registerInteractions() {
        if (this.handler != null) {
            this.handler.registerInteractions();
        }
    }

    @Nonnull
    public DIH4JDAConfig getConfig() {
        return this.config;
    }

    public void addEventListener(Object ... classes) {
        for (Object o : classes) {
            try {
                DIH4JDAEventListener adapter = (DIH4JDAEventListener)o;
                this.listeners.add(adapter);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Listener classes must implement DIH4JDAEventListener!");
            }
        }
    }

    @Nonnull
    public Set<DIH4JDAEventListener> getEventListeners() {
        return this.listeners;
    }

    @Nonnull
    public JDA getJDA() {
        return this.config.getJda();
    }

    public void addSlashCommands(SlashCommand ... commands) {
        this.handler.slashCommands.addAll(List.of(commands));
    }

    public void addContextCommands(ContextCommand<?> ... commands) {
        this.handler.contextCommands.addAll(List.of(commands));
    }

    @SafeVarargs
    public final void addButtonMappings(IdMapping<ButtonHandler> ... mappings) {
        this.validateMappings(mappings);
        this.buttonMappings = mappings;
    }

    @Nonnull
    public final IdMapping<ButtonHandler>[] getButtonMappings() {
        return this.buttonMappings;
    }

    @SafeVarargs
    public final void addStringSelectMenuMappings(IdMapping<StringSelectMenuHandler> ... mappings) {
        this.validateMappings(mappings);
        this.stringSelectMenuMappings = mappings;
    }

    @Nonnull
    public final IdMapping<StringSelectMenuHandler>[] getStringSelectMenuMappings() {
        return this.stringSelectMenuMappings;
    }

    @SafeVarargs
    public final void addEntitySelectMenuMappings(IdMapping<EntitySelectMenuHandler> ... mappings) {
        this.validateMappings(mappings);
        this.entitySelectMenuMappings = mappings;
    }

    @Nonnull
    public final IdMapping<EntitySelectMenuHandler>[] getEntitySelectMenuMappings() {
        return this.entitySelectMenuMappings;
    }

    @SafeVarargs
    public final void addModalMappings(IdMapping<ModalHandler> ... mappings) {
        this.validateMappings(mappings);
        this.modalMappings = mappings;
    }

    @Nonnull
    public final IdMapping<ModalHandler>[] getModalMappings() {
        return this.modalMappings;
    }

    @SafeVarargs
    private <T> void validateMappings(IdMapping<T> ... mappings) {
        for (IdMapping<T> mapping : mappings) {
            if (mapping.getIds().length != 0) continue;
            throw new IllegalArgumentException("Ids may not be empty or null!");
        }
    }

    private void validateConfig(@Nonnull DIH4JDAConfig config) throws DIH4JDAException {
        if (config.getJda() == null) {
            throw new InvalidConfigurationException("JDA instance may not be null!");
        }
        if (config.getBlockedLogTypes() == null) {
            throw new InvalidConfigurationException("Blocked Log Types may not be null!");
        }
        if (config.getCommandsPackages() == null) {
            throw new InvalidConfigurationException("Command Packages may not be null!");
        }
        if (config.getExecutor() == null) {
            throw new InvalidConfigurationException("Executor may not be null!");
        }
    }
}

