/*
 * Decompiled with CFR 0.152.
 */
package xyz.dynxsty.dih4jda;

import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.JDA;
import xyz.dynxsty.dih4jda.DIH4JDA;
import xyz.dynxsty.dih4jda.DIH4JDALogger;
import xyz.dynxsty.dih4jda.config.DIH4JDAConfig;
import xyz.dynxsty.dih4jda.exceptions.DIH4JDAException;
import xyz.dynxsty.dih4jda.exceptions.InvalidPackageException;
import xyz.dynxsty.dih4jda.util.ClasspathHelper;

public class DIH4JDABuilder {
    private final JDA jda;
    private final DIH4JDAConfig config = new DIH4JDAConfig();

    private DIH4JDABuilder(@Nonnull JDA jda) {
        this.jda = jda;
    }

    @Nonnull
    public static DIH4JDABuilder setJDA(@Nonnull JDA instance) {
        return new DIH4JDABuilder(instance);
    }

    @Nonnull
    public DIH4JDABuilder setCommandPackages(String ... pack) {
        this.config.setCommandsPackages(pack);
        return this;
    }

    @Nonnull
    public DIH4JDABuilder setExecutor(@Nonnull Executor executor) {
        this.config.setExecutor(executor);
        return this;
    }

    @Nonnull
    public DIH4JDABuilder disableLogging(DIH4JDALogger.Type ... types) {
        DIH4JDALogger.Type[] blocked = types == null || types.length < 1 ? DIH4JDALogger.Type.values() : types;
        this.config.setBlockedLogTypes(blocked);
        return this;
    }

    @Nonnull
    public DIH4JDABuilder disableStacktracePrinting() {
        this.config.setDefaultPrintStacktrace(false);
        return this;
    }

    @Nonnull
    public DIH4JDABuilder disableAutomaticCommandRegistration() {
        this.config.setRegisterOnReady(false);
        return this;
    }

    @Nonnull
    public DIH4JDABuilder setGlobalSmartQueue(boolean enable) {
        this.config.setGlobalSmartQueue(enable);
        return this;
    }

    @Nonnull
    public DIH4JDABuilder setGuildSmartQueue(boolean enable) {
        this.config.setGuildSmartQueue(enable);
        return this;
    }

    @Nonnull
    public DIH4JDABuilder disableUnknownCommandDeletion() {
        this.config.setDeleteUnknownCommands(false);
        return this;
    }

    @Nonnull
    public DIH4JDABuilder disableUnregisteredCommandException() {
        this.config.setThrowUnregisteredException(false);
        return this;
    }

    @Nonnull
    public DIH4JDA build() throws DIH4JDAException {
        if (Runtime.getRuntime().availableProcessors() == 1) {
            DIH4JDALogger.warn("You are running DIH4JDA on a single core CPU. A special system property was set to disable asynchronous command execution.", new Object[0]);
            System.setProperty("java.util.concurrent.ForkJoinPool.common.parallelism", "1");
        }
        for (String pkg : this.config.getCommandsPackages()) {
            if (pkg.isBlank() || pkg.isEmpty()) {
                throw new InvalidPackageException("Commands package cannot be empty or blank.");
            }
            if (!ClasspathHelper.forPackage(pkg).isEmpty()) continue;
            throw new InvalidPackageException("Package '" + pkg + "' does not exist.");
        }
        this.config.setJda(this.jda);
        return new DIH4JDA(this.config);
    }
}

