/*
 * Decompiled with CFR 0.152.
 */
package xyz.dynxsty.dih4jda;

import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.events.interaction.ModalInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.CommandAutoCompleteInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.MessageContextInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.UserContextInteractionEvent;
import net.dv8tion.jda.api.events.interaction.component.ButtonInteractionEvent;
import net.dv8tion.jda.api.events.interaction.component.EntitySelectInteractionEvent;
import net.dv8tion.jda.api.events.interaction.component.StringSelectInteractionEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.interactions.commands.Command;
import net.dv8tion.jda.api.interactions.commands.CommandAutoCompleteInteraction;
import net.dv8tion.jda.api.interactions.commands.CommandInteraction;
import net.dv8tion.jda.api.interactions.commands.build.CommandData;
import net.dv8tion.jda.api.interactions.commands.build.SlashCommandData;
import net.dv8tion.jda.api.interactions.commands.build.SubcommandData;
import net.dv8tion.jda.api.interactions.commands.build.SubcommandGroupData;
import net.dv8tion.jda.api.interactions.components.ComponentInteraction;
import net.dv8tion.jda.api.interactions.modals.ModalInteraction;
import xyz.dynxsty.dih4jda.DIH4JDA;
import xyz.dynxsty.dih4jda.DIH4JDALogger;
import xyz.dynxsty.dih4jda.SmartQueue;
import xyz.dynxsty.dih4jda.config.DIH4JDAConfig;
import xyz.dynxsty.dih4jda.events.AutoCompleteExceptionEvent;
import xyz.dynxsty.dih4jda.events.CommandCooldownEvent;
import xyz.dynxsty.dih4jda.events.CommandExceptionEvent;
import xyz.dynxsty.dih4jda.events.ComponentExceptionEvent;
import xyz.dynxsty.dih4jda.events.DIH4JDAEvent;
import xyz.dynxsty.dih4jda.events.InsufficientPermissionsEvent;
import xyz.dynxsty.dih4jda.events.InvalidGuildEvent;
import xyz.dynxsty.dih4jda.events.InvalidRoleEvent;
import xyz.dynxsty.dih4jda.events.InvalidUserEvent;
import xyz.dynxsty.dih4jda.events.ModalExceptionEvent;
import xyz.dynxsty.dih4jda.exceptions.CommandNotRegisteredException;
import xyz.dynxsty.dih4jda.exceptions.DIH4JDAException;
import xyz.dynxsty.dih4jda.interactions.AutoCompletable;
import xyz.dynxsty.dih4jda.interactions.commands.RestrictedCommand;
import xyz.dynxsty.dih4jda.interactions.commands.application.ContextCommand;
import xyz.dynxsty.dih4jda.interactions.commands.application.RegistrationType;
import xyz.dynxsty.dih4jda.interactions.commands.application.SlashCommand;
import xyz.dynxsty.dih4jda.interactions.components.ButtonHandler;
import xyz.dynxsty.dih4jda.interactions.components.EntitySelectMenuHandler;
import xyz.dynxsty.dih4jda.interactions.components.IdMapping;
import xyz.dynxsty.dih4jda.interactions.components.ModalHandler;
import xyz.dynxsty.dih4jda.interactions.components.StringSelectMenuHandler;
import xyz.dynxsty.dih4jda.util.Checks;
import xyz.dynxsty.dih4jda.util.ClassUtils;
import xyz.dynxsty.dih4jda.util.ClassWalker;
import xyz.dynxsty.dih4jda.util.CommandUtils;
import xyz.dynxsty.dih4jda.util.ComponentIdBuilder;
import xyz.dynxsty.dih4jda.util.Pair;

public class InteractionHandler
extends ListenerAdapter {
    private static final Map<String, Command> RETRIEVED_COMMANDS = new HashMap<String, Command>();
    protected final Set<SlashCommand> slashCommands;
    protected final Set<ContextCommand<?>> contextCommands;
    private final DIH4JDA dih4jda;
    private final DIH4JDAConfig config;
    private final Map<String, SlashCommand> slashCommandIndex;
    private final Map<String, SlashCommand.Subcommand> subcommandIndex;
    private final Map<String, ContextCommand.Message> messageContextIndex;
    private final Map<String, ContextCommand.User> userContextIndex;
    private final Map<String, AutoCompletable> autoCompleteIndex;

    protected InteractionHandler(@Nonnull DIH4JDA dih4jda) {
        this.dih4jda = dih4jda;
        this.config = dih4jda.getConfig();
        this.slashCommands = new HashSet<SlashCommand>();
        this.contextCommands = new HashSet();
        for (String pkg : this.config.getCommandsPackages()) {
            try {
                this.findSlashCommands(pkg);
                this.findContextCommands(pkg);
            }
            catch (ReflectiveOperationException | DIH4JDAException e) {
                DIH4JDALogger.error("An error occurred while initializing commands in package %s: %s", pkg, e.getMessage());
            }
        }
        this.slashCommandIndex = new HashMap<String, SlashCommand>();
        this.subcommandIndex = new HashMap<String, SlashCommand.Subcommand>();
        this.messageContextIndex = new HashMap<String, ContextCommand.Message>();
        this.userContextIndex = new HashMap<String, ContextCommand.User>();
        this.autoCompleteIndex = new HashMap<String, AutoCompletable>();
    }

    @Nonnull
    public static Map<String, Command> getRetrievedCommands() {
        return Collections.unmodifiableMap(RETRIEVED_COMMANDS);
    }

    public void registerInteractions() {
        Pair data = new Pair(this.getSlashCommands(), this.getContextCommandData());
        for (Guild guild : this.config.getJda().getGuilds()) {
            guild.retrieveCommands(true).queue(existing -> {
                Pair<Set<SlashCommand>, Set<ContextCommand<?>>> guildData = CommandUtils.filterByType(data, RegistrationType.GUILD);
                existing.forEach(this::cacheCommand);
                if (this.config.isGuildSmartQueue()) {
                    guildData = new SmartQueue(guildData.getFirst(), guildData.getSecond(), this.config.isDeleteUnknownCommands()).checkGuild(guild, (List<Command>)existing);
                }
                if (!guildData.getFirst().isEmpty() || !guildData.getSecond().isEmpty()) {
                    this.upsert(guild, guildData.getFirst(), guildData.getSecond());
                }
            }, error -> DIH4JDALogger.error("Could not retrieve commands for guild %s! Please make sure that the bot was invited with the application.commands scope!", guild.getName()));
        }
        this.config.getJda().retrieveCommands(true).queue(existing -> {
            Pair<Set<SlashCommand>, Set<ContextCommand<?>>> globalData = CommandUtils.filterByType(data, RegistrationType.GLOBAL);
            existing.forEach(this::cacheCommand);
            if (this.config.isGlobalSmartQueue()) {
                globalData = new SmartQueue(globalData.getFirst(), globalData.getSecond(), this.config.isDeleteUnknownCommands()).checkGlobal((List<Command>)existing);
            }
            if (!globalData.getFirst().isEmpty() || !globalData.getSecond().isEmpty()) {
                this.upsert(this.config.getJda(), globalData.getFirst(), globalData.getSecond());
                DIH4JDALogger.info(DIH4JDALogger.Type.COMMANDS_QUEUED, "Queued %s global command(s): %s", globalData.getFirst().size() + globalData.getSecond().size(), CommandUtils.getNames(globalData.getSecond(), globalData.getFirst()));
            }
        }, error -> DIH4JDALogger.error("Could not retrieve global commands!", new Object[0]));
        if (!this.autoCompleteIndex.isEmpty()) {
            DIH4JDALogger.info("Created %s AutoComplete binding(s): %s", this.autoCompleteIndex.size(), this.autoCompleteIndex.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + ((AutoCompletable)entry.getValue()).getClass().getSimpleName()).collect(Collectors.joining(", ")));
        }
    }

    private void upsert(@Nonnull JDA jda, @Nonnull Set<SlashCommand> slashCommands, @Nonnull Set<ContextCommand<?>> contextCommands) {
        slashCommands.forEach(data -> jda.upsertCommand((CommandData)data.getCommandData()).queue(this::cacheCommand));
        contextCommands.forEach(data -> jda.upsertCommand((CommandData)data.getCommandData()).queue(this::cacheCommand));
    }

    private void upsert(@Nonnull Guild guild, @Nonnull Set<SlashCommand> slashCommands, @Nonnull Set<ContextCommand<?>> contextCommands) {
        StringBuilder commandNames = new StringBuilder();
        slashCommands.forEach(data -> {
            Long[] guildIds = data.getQueueableGuilds();
            if (guildIds.length == 0 || Arrays.asList(guildIds).contains(guild.getIdLong())) {
                guild.upsertCommand((CommandData)data.getCommandData()).queue(this::cacheCommand);
                commandNames.append(", /").append(((SlashCommandData)data.getCommandData()).getName());
            } else {
                DIH4JDALogger.error(DIH4JDALogger.Type.SLASH_COMMAND_SKIPPED, "Skipping registration of a slash command because the data is null.", new Object[0]);
            }
        });
        contextCommands.forEach(data -> {
            Long[] guildIds = data.getQueueableGuilds();
            if (guildIds.length == 0 || Arrays.asList(guildIds).contains(guild.getIdLong())) {
                guild.upsertCommand((CommandData)data.getCommandData()).queue(this::cacheCommand);
                commandNames.append(", ").append(((CommandData)data.getCommandData()).getName());
            } else {
                DIH4JDALogger.error(DIH4JDALogger.Type.SLASH_COMMAND_SKIPPED, "Skipping registration of a slash command because the data is null.", new Object[0]);
            }
        });
        if (!commandNames.toString().isEmpty()) {
            DIH4JDALogger.info(DIH4JDALogger.Type.COMMANDS_QUEUED, "Queued %s command(s) in guild %s: %s", slashCommands.size() + contextCommands.size(), guild.getName(), commandNames.substring(2));
        }
    }

    private void cacheCommand(@Nonnull Command command) {
        RETRIEVED_COMMANDS.put(command.getName(), command);
    }

    private void findSlashCommands(@Nonnull String pkg) throws ReflectiveOperationException, DIH4JDAException {
        ClassWalker classes = new ClassWalker(pkg);
        Set<Class<SlashCommand>> subTypes = classes.getSubTypesOf(SlashCommand.class);
        for (Class<SlashCommand> subType : subTypes) {
            if (Checks.checkEmptyConstructor(subType)) {
                this.slashCommands.add((SlashCommand)ClassUtils.getInstance(subType));
                continue;
            }
            DIH4JDALogger.error("Could not initialize %s! The class MUST contain a empty public constructor.", subType.getName());
        }
    }

    private void findContextCommands(@Nonnull String pkg) throws ReflectiveOperationException, DIH4JDAException {
        ClassWalker classes = new ClassWalker(pkg);
        Set<Class<ContextCommand>> subTypes = classes.getSubTypesOf(ContextCommand.class);
        for (Class<ContextCommand> subType : subTypes) {
            if (Checks.checkEmptyConstructor(subType)) {
                this.contextCommands.add((ContextCommand)ClassUtils.getInstance(subType));
                continue;
            }
            DIH4JDALogger.error("Could not initialize %s! The class MUST contain a empty public constructor.", subType.getName());
        }
    }

    @Nonnull
    private Set<SlashCommand> getSlashCommands() {
        HashSet<SlashCommand> commands = new HashSet<SlashCommand>();
        for (SlashCommand command : this.slashCommands) {
            if (command == null) continue;
            SlashCommandData data = this.getBaseCommandData(command);
            command.setCommandData(data);
            if (command.getRegistrationType() != RegistrationType.GUILD && command.getQueueableGuilds().length != 0) {
                throw new UnsupportedOperationException(command.getClass().getName() + " attempted to require guilds for a non-global command!");
            }
            this.searchForAutoCompletable(command, command.getClass());
            commands.add(command);
        }
        return commands;
    }

    private void searchForAutoCompletable(@Nonnull SlashCommand command, @Nonnull Class<? extends SlashCommand> clazz) {
        String baseName = ((SlashCommandData)command.getCommandData()).getName();
        if (Checks.checkImplementation(clazz, AutoCompletable.class)) {
            this.autoCompleteIndex.put(baseName, (AutoCompletable)((Object)command));
        }
        for (SlashCommand.Subcommand child : command.getSubcommands()) {
            if (!Checks.checkImplementation(child.getClass(), AutoCompletable.class)) continue;
            this.autoCompleteIndex.put(CommandUtils.buildCommandPath(baseName, ((SubcommandData)child.getCommandData()).getName()), (AutoCompletable)((Object)child));
        }
        for (SlashCommand.SubcommandGroup childGroup : command.getSubcommandGroups()) {
            String groupName = childGroup.getData().getName();
            for (SlashCommand.Subcommand child : childGroup.getSubcommands()) {
                if (!Checks.checkImplementation(child.getClass(), AutoCompletable.class)) continue;
                this.autoCompleteIndex.put(CommandUtils.buildCommandPath(baseName, groupName, ((SubcommandData)child.getCommandData()).getName()), (AutoCompletable)((Object)child));
            }
        }
    }

    @Nonnull
    private SlashCommandData getBaseCommandData(@Nonnull SlashCommand command) {
        SlashCommandData commandData = (SlashCommandData)command.getCommandData();
        if (command.getSubcommandGroups().length != 0) {
            commandData.addSubcommandGroups(this.getSubcommandGroupData(command));
        }
        if (command.getSubcommands().length != 0) {
            commandData.addSubcommands(this.getSubcommandData(command, command.getSubcommands(), null));
        }
        if (command.getSubcommandGroups().length == 0 && command.getSubcommands().length == 0) {
            this.slashCommandIndex.put(CommandUtils.buildCommandPath(commandData.getName()), command);
            DIH4JDALogger.info(DIH4JDALogger.Type.SLASH_COMMAND_REGISTERED, "\t[*] Registered command: /%s (%s)", ((SlashCommandData)command.getCommandData()).getName(), command.getRegistrationType().name());
        }
        return commandData;
    }

    @Nonnull
    private Set<SubcommandGroupData> getSubcommandGroupData(@Nonnull SlashCommand command) {
        HashSet<SubcommandGroupData> groupDataList = new HashSet<SubcommandGroupData>();
        for (SlashCommand.SubcommandGroup group : command.getSubcommandGroups()) {
            if (group == null) continue;
            SubcommandGroupData groupData = group.getData();
            if (group.getSubcommands().length == 0) {
                DIH4JDALogger.warn("SubcommandGroup %s is missing Subcommands. It will be ignored.", groupData.getName());
                continue;
            }
            groupData.addSubcommands(this.getSubcommandData(command, group.getSubcommands(), groupData.getName()));
            groupDataList.add(groupData);
        }
        return groupDataList;
    }

    @Nonnull
    private Set<SubcommandData> getSubcommandData(@Nonnull SlashCommand command, @Nonnull SlashCommand.Subcommand[] subcommands, @Nullable String subGroupName) {
        HashSet<SubcommandData> subDataList = new HashSet<SubcommandData>();
        for (SlashCommand.Subcommand subcommand : subcommands) {
            if (subcommand == null) continue;
            String commandPath = subGroupName == null ? CommandUtils.buildCommandPath(((SlashCommandData)command.getCommandData()).getName(), ((SubcommandData)subcommand.getCommandData()).getName()) : CommandUtils.buildCommandPath(((SlashCommandData)command.getCommandData()).getName(), subGroupName, ((SubcommandData)subcommand.getCommandData()).getName());
            this.subcommandIndex.put(commandPath, subcommand);
            DIH4JDALogger.info(DIH4JDALogger.Type.SLASH_COMMAND_REGISTERED, "\t[*] Registered command: /%s (%s)", commandPath, command.getRegistrationType().name());
            subDataList.add((SubcommandData)subcommand.getCommandData());
        }
        return subDataList;
    }

    @Nonnull
    private Set<ContextCommand<?>> getContextCommandData() {
        HashSet commands = new HashSet();
        for (ContextCommand<?> context : this.contextCommands) {
            if (context == null) continue;
            CommandData data = this.getContextCommandData(context);
            if (data != null) {
                context.setCommandData(data);
            }
            if (context.getRegistrationType() != RegistrationType.GUILD && context.getQueueableGuilds().length != 0) {
                throw new UnsupportedOperationException(context.getClass().getName() + " attempted to require guilds for a non-global command!");
            }
            commands.add(context);
        }
        return commands;
    }

    @Nullable
    private CommandData getContextCommandData(@Nonnull ContextCommand<?> command) {
        CommandData data = (CommandData)command.getCommandData();
        if (data.getType() == Command.Type.MESSAGE) {
            this.messageContextIndex.put(data.getName(), (ContextCommand.Message)command);
        } else if (((CommandData)command.getCommandData()).getType() == Command.Type.USER) {
            this.userContextIndex.put(data.getName(), (ContextCommand.User)command);
        } else {
            DIH4JDALogger.error("Invalid Command Type \"%s\" for Context Command! This command will be ignored.", data.getType());
            return null;
        }
        DIH4JDALogger.info(DIH4JDALogger.Type.CONTEXT_COMMAND_REGISTERED, "\t[*] Registered context command: %s (%s)", data.getName(), command.getRegistrationType().name());
        return data;
    }

    private void handleSlashCommand(@Nonnull SlashCommandInteractionEvent event) throws CommandNotRegisteredException {
        SlashCommand slashcommand = this.slashCommandIndex.get(event.getFullCommandName());
        SlashCommand.Subcommand subcommand = this.subcommandIndex.get(event.getFullCommandName());
        if (slashcommand == null && subcommand == null) {
            if (this.config.isThrowUnregisteredException()) {
                throw new CommandNotRegisteredException(String.format("Slash Command \"%s\" is not registered.", event.getFullCommandName()));
            }
        } else if (slashcommand == null) {
            SlashCommand base = subcommand.getParent();
            if (base != null && this.passesRequirements((CommandInteraction)event, base, base.getRegistrationType()) && this.passesRequirements((CommandInteraction)event, subcommand, base.getRegistrationType())) {
                subcommand.execute(event);
            }
        } else if (this.passesRequirements((CommandInteraction)event, slashcommand, slashcommand.getRegistrationType())) {
            slashcommand.execute(event);
        }
    }

    private void handleUserContextCommand(@Nonnull UserContextInteractionEvent event) throws CommandNotRegisteredException {
        ContextCommand.User context = this.userContextIndex.get(event.getFullCommandName());
        if (context == null) {
            if (this.config.isThrowUnregisteredException()) {
                throw new CommandNotRegisteredException(String.format("Context Command \"%s\" is not registered.", event.getFullCommandName()));
            }
        } else if (this.passesRequirements((CommandInteraction)event, context, context.getRegistrationType())) {
            context.execute(event);
        }
    }

    private void handleMessageContextCommand(@Nonnull MessageContextInteractionEvent event) throws CommandNotRegisteredException {
        ContextCommand.Message context = this.messageContextIndex.get(event.getFullCommandName());
        if (context == null) {
            if (this.config.isThrowUnregisteredException()) {
                throw new CommandNotRegisteredException(String.format("Context Command \"%s\" is not registered.", event.getFullCommandName()));
            }
        } else if (this.passesRequirements((CommandInteraction)event, context, context.getRegistrationType())) {
            context.execute(event);
        }
    }

    private boolean passesRequirements(@Nonnull CommandInteraction interaction, @Nonnull RestrictedCommand command, @Nonnull RegistrationType type) {
        long userId = interaction.getUser().getIdLong();
        Long[] guildIds = command.getRequiredGuilds();
        Permission[] permissions = command.getRequiredPermissions();
        Long[] userIds = command.getRequiredUsers();
        Long[] roleIds = command.getRequiredRoles();
        if (type == RegistrationType.GUILD && guildIds.length != 0 && interaction.isFromGuild() && interaction.getGuild() != null && !Arrays.asList(guildIds).contains(interaction.getGuild().getIdLong())) {
            DIH4JDAEvent.fire(new InvalidGuildEvent(this.dih4jda, interaction, Set.of(guildIds)));
            return false;
        }
        if (permissions.length != 0 && interaction.isFromGuild() && interaction.getMember() != null && !interaction.getMember().hasPermission(permissions)) {
            DIH4JDAEvent.fire(new InsufficientPermissionsEvent(this.dih4jda, interaction, Set.of(permissions)));
            return false;
        }
        if (userIds.length != 0 && !Arrays.asList(userIds).contains(userId)) {
            DIH4JDAEvent.fire(new InvalidUserEvent(this.dih4jda, interaction, Set.of(userIds)));
            return false;
        }
        if (interaction.isFromGuild() && interaction.getGuild() != null && interaction.getMember() != null) {
            Member member = interaction.getMember();
            if (roleIds.length != 0 && !member.getRoles().isEmpty() && member.getRoles().stream().noneMatch(r -> Arrays.asList(roleIds).contains(r.getIdLong()))) {
                DIH4JDAEvent.fire(new InvalidRoleEvent(this.dih4jda, interaction, Set.of(roleIds)));
                return false;
            }
        }
        if (command.getCommandCooldown() != Duration.ZERO) {
            if (command.hasCooldown(userId)) {
                DIH4JDAEvent.fire(new CommandCooldownEvent(this.dih4jda, interaction, command.retrieveCooldown(userId)));
                return false;
            }
            command.applyCooldown(userId, Instant.now().plus(command.getCommandCooldown()));
        }
        return true;
    }

    public void onSlashCommandInteraction(@Nonnull SlashCommandInteractionEvent event) {
        CompletableFuture.runAsync(() -> {
            try {
                this.handleSlashCommand(event);
            }
            catch (Throwable e) {
                DIH4JDAEvent.fire(new CommandExceptionEvent(this.dih4jda, (CommandInteraction)event, e));
            }
        }, this.config.getExecutor());
    }

    public void onUserContextInteraction(@Nonnull UserContextInteractionEvent event) {
        CompletableFuture.runAsync(() -> {
            try {
                this.handleUserContextCommand(event);
            }
            catch (Throwable e) {
                DIH4JDAEvent.fire(new CommandExceptionEvent(this.dih4jda, (CommandInteraction)event, e));
            }
        }, this.config.getExecutor());
    }

    public void onMessageContextInteraction(@Nonnull MessageContextInteractionEvent event) {
        CompletableFuture.runAsync(() -> {
            try {
                this.handleMessageContextCommand(event);
            }
            catch (Throwable e) {
                DIH4JDAEvent.fire(new CommandExceptionEvent(this.dih4jda, (CommandInteraction)event, e));
            }
        }, this.config.getExecutor());
    }

    public void onCommandAutoCompleteInteraction(@Nonnull CommandAutoCompleteInteractionEvent event) {
        CompletableFuture.runAsync(() -> {
            try {
                AutoCompletable autoComplete = this.autoCompleteIndex.get(event.getFullCommandName());
                if (autoComplete != null) {
                    autoComplete.handleAutoComplete(event, event.getFocusedOption());
                }
            }
            catch (Throwable e) {
                DIH4JDAEvent.fire(new AutoCompleteExceptionEvent(this.dih4jda, (CommandAutoCompleteInteraction)event, e));
            }
        }, this.config.getExecutor());
    }

    public void onButtonInteraction(@Nonnull ButtonInteractionEvent event) {
        CompletableFuture.runAsync(() -> {
            try {
                if (this.dih4jda.getButtonMappings().length == 0) {
                    return;
                }
                Optional<ButtonHandler> buttonOptional = Arrays.stream(this.dih4jda.getButtonMappings()).filter(map -> Arrays.asList(map.getIds()).contains(ComponentIdBuilder.split(event.getComponentId())[0])).map(IdMapping::getHandler).findFirst();
                if (buttonOptional.isEmpty()) {
                    DIH4JDALogger.warn(DIH4JDALogger.Type.BUTTON_NOT_FOUND, "Button with id \"%s\" could not be found.", event.getComponentId());
                } else {
                    buttonOptional.get().handleButton(event, event.getButton());
                }
            }
            catch (Throwable e) {
                DIH4JDAEvent.fire(new ComponentExceptionEvent(this.dih4jda, (ComponentInteraction)event, e));
            }
        }, this.config.getExecutor());
    }

    public void onStringSelectInteraction(@Nonnull StringSelectInteractionEvent event) {
        CompletableFuture.runAsync(() -> {
            try {
                if (this.dih4jda.getStringSelectMenuMappings().length == 0) {
                    return;
                }
                Optional<StringSelectMenuHandler> selectMenuOptional = Arrays.stream(this.dih4jda.getStringSelectMenuMappings()).filter(map -> Arrays.asList(map.getIds()).contains(ComponentIdBuilder.split(event.getComponentId())[0])).map(IdMapping::getHandler).findFirst();
                if (selectMenuOptional.isEmpty()) {
                    DIH4JDALogger.warn(DIH4JDALogger.Type.SELECT_MENU_NOT_FOUND, "Select Menu with id \"%s\" could not be found.", event.getComponentId());
                } else {
                    selectMenuOptional.get().handleStringSelectMenu(event, event.getValues());
                }
            }
            catch (Throwable e) {
                DIH4JDAEvent.fire(new ComponentExceptionEvent(this.dih4jda, (ComponentInteraction)event, e));
            }
        }, this.config.getExecutor());
    }

    public void onEntitySelectInteraction(@Nonnull EntitySelectInteractionEvent event) {
        CompletableFuture.runAsync(() -> {
            try {
                if (this.dih4jda.getEntitySelectMenuMappings().length == 0) {
                    return;
                }
                Optional<EntitySelectMenuHandler> selectMenuOptional = Arrays.stream(this.dih4jda.getEntitySelectMenuMappings()).filter(map -> Arrays.asList(map.getIds()).contains(ComponentIdBuilder.split(event.getComponentId())[0])).map(IdMapping::getHandler).findFirst();
                if (selectMenuOptional.isEmpty()) {
                    DIH4JDALogger.warn(DIH4JDALogger.Type.SELECT_MENU_NOT_FOUND, "Select Menu with id \"%s\" could not be found.", event.getComponentId());
                } else {
                    selectMenuOptional.get().handleEntitySelectMenu(event, event.getValues());
                }
            }
            catch (Throwable e) {
                DIH4JDAEvent.fire(new ComponentExceptionEvent(this.dih4jda, (ComponentInteraction)event, e));
            }
        }, this.config.getExecutor());
    }

    public void onModalInteraction(@Nonnull ModalInteractionEvent event) {
        CompletableFuture.runAsync(() -> {
            try {
                if (this.dih4jda.getModalMappings().length == 0) {
                    return;
                }
                Optional<ModalHandler> modalOptional = Arrays.stream(this.dih4jda.getModalMappings()).filter(map -> Arrays.asList(map.getIds()).contains(ComponentIdBuilder.split(event.getModalId())[0])).map(IdMapping::getHandler).findFirst();
                if (modalOptional.isEmpty()) {
                    DIH4JDALogger.warn(DIH4JDALogger.Type.MODAL_NOT_FOUND, "Modal with id \"%s\" could not be found.", event.getModalId());
                } else {
                    modalOptional.get().handleModal(event, event.getValues());
                }
            }
            catch (Throwable e) {
                DIH4JDAEvent.fire(new ModalExceptionEvent(this.dih4jda, (ModalInteraction)event, e));
            }
        }, this.config.getExecutor());
    }
}

