/*
 * Decompiled with CFR 0.152.
 */
package xyz.dynxsty.dih4jda;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.interactions.commands.Command;
import xyz.dynxsty.dih4jda.DIH4JDALogger;
import xyz.dynxsty.dih4jda.interactions.commands.application.ContextCommand;
import xyz.dynxsty.dih4jda.interactions.commands.application.SlashCommand;
import xyz.dynxsty.dih4jda.util.CommandUtils;
import xyz.dynxsty.dih4jda.util.Pair;

public class SmartQueue {
    private final Set<SlashCommand> slashCommands;
    private final Set<ContextCommand<?>> contextCommands;
    private final boolean deleteUnknown;

    protected SmartQueue(@Nonnull Set<SlashCommand> slashCommands, @Nonnull Set<ContextCommand<?>> contextCommands, boolean deleteUnknown) {
        this.slashCommands = slashCommands;
        this.contextCommands = contextCommands;
        this.deleteUnknown = deleteUnknown;
    }

    @Nonnull
    protected Pair<Set<SlashCommand>, Set<ContextCommand<?>>> checkGlobal(@Nonnull List<Command> existing) {
        if (!existing.isEmpty()) {
            return this.removeDuplicates(existing, null);
        }
        return new Pair(this.slashCommands, this.contextCommands);
    }

    @Nonnull
    protected Pair<Set<SlashCommand>, Set<ContextCommand<?>>> checkGuild(@Nonnull Guild guild, @Nonnull List<Command> existing) {
        if (!existing.isEmpty()) {
            return this.removeDuplicates(existing, guild);
        }
        return new Pair(this.slashCommands, this.contextCommands);
    }

    @Nonnull
    private Pair<Set<SlashCommand>, Set<ContextCommand<?>>> removeDuplicates(@Nonnull List<Command> existing, @Nullable Guild guild) {
        ArrayList<Command> commands = new ArrayList<Command>(existing);
        boolean global = guild == null;
        String prefix = String.format("[%s] ", global ? "Global" : guild.getName());
        DIH4JDALogger.info(DIH4JDALogger.Type.SMART_QUEUE, prefix + "Found %s existing command(s)", existing.size());
        commands.removeIf(cmd -> {
            boolean isCheckingGuilds = cmd.getType().equals((Object)Command.Type.SLASH) ? this.slashCommands.stream().anyMatch(data -> CommandUtils.compareSlashCommands(cmd, data)) : this.contextCommands.stream().anyMatch(data -> CommandUtils.compareContextCommands(cmd, data));
            if (isCheckingGuilds) {
                if (!global) {
                    this.slashCommands.forEach(slash -> this.checkRequiredGuilds(guild, (Command)cmd, (SlashCommand)slash));
                    this.contextCommands.forEach(context -> this.checkRequiredGuilds(guild, (Command)cmd, (ContextCommand<?>)context));
                } else {
                    DIH4JDALogger.info(DIH4JDALogger.Type.SMART_QUEUE_IGNORED, prefix + "Found duplicate %s command, which will be ignored: %s", cmd.getType(), cmd.getName());
                }
                return true;
            }
            return false;
        });
        this.contextCommands.removeIf(data -> existing.stream().anyMatch(cmd -> CommandUtils.compareContextCommands(cmd, data)));
        this.slashCommands.removeIf(data -> existing.stream().anyMatch(cmd -> CommandUtils.compareSlashCommands(cmd, data)));
        if (!commands.isEmpty()) {
            commands.forEach(cmd -> this.checkUnknown(prefix, existing, (Command)cmd));
        }
        return new Pair(this.slashCommands, this.contextCommands);
    }

    private void checkUnknown(@Nonnull String prefix, @Nonnull List<Command> existing, @Nonnull Command command) {
        if (existing.contains(command)) {
            if (this.deleteUnknown) {
                DIH4JDALogger.info(DIH4JDALogger.Type.SMART_QUEUE_DELETED_UNKNOWN, prefix + "Deleting unknown %s command: %s", command.getType(), command.getName());
                command.delete().queue();
            } else {
                DIH4JDALogger.info(DIH4JDALogger.Type.SMART_QUEUE_IGNORED_UNKNOWN, prefix + "Ignored unknown %s command: %s", command.getType(), command.getName());
            }
        }
    }

    private void checkRequiredGuilds(Guild guild, Command cmd, @Nonnull SlashCommand data) {
        if (CommandUtils.compareSlashCommands(cmd, data) && data.getQueueableGuilds().length != 0 && !Arrays.asList(data.getQueueableGuilds()).contains(guild.getIdLong())) {
            DIH4JDALogger.info("Deleting /%s in non-queueable Guild: %s", cmd.getName(), guild.getName());
            cmd.delete().queue();
        }
    }

    private void checkRequiredGuilds(Guild guild, Command cmd, @Nonnull ContextCommand<?> data) {
        if (CommandUtils.compareContextCommands(cmd, data) && data.getQueueableGuilds().length != 0 && !Arrays.asList(data.getQueueableGuilds()).contains(guild.getIdLong())) {
            DIH4JDALogger.info("Deleting /%s in non-queueable Guild: %s", cmd.getName(), guild.getName());
            cmd.delete().queue();
        }
    }
}

