/*
 * Decompiled with CFR 0.152.
 */
package xyz.dynxsty.dih4jda.events;

import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.interactions.Interaction;
import xyz.dynxsty.dih4jda.DIH4JDA;
import xyz.dynxsty.dih4jda.DIH4JDALogger;
import xyz.dynxsty.dih4jda.events.DIH4JDAEventListener;
import xyz.dynxsty.dih4jda.events.DIH4JDAThrowableEvent;

public abstract class DIH4JDAEvent<I extends Interaction> {
    private final String eventName;
    private final DIH4JDA dih4jda;
    private final I interaction;

    protected DIH4JDAEvent(@Nonnull String eventName, @Nonnull DIH4JDA dih4jda, @Nonnull I interaction) {
        this.eventName = eventName;
        this.dih4jda = dih4jda;
        this.interaction = interaction;
    }

    public static <I extends Interaction> void fire(@Nonnull DIH4JDAEvent<I> event) {
        if (event.getDIH4JDA().getEventListeners().isEmpty()) {
            DIH4JDALogger.warn(DIH4JDALogger.Type.EVENT_MISSING_HANDLER, "%s was fired, but not handled (No listener registered)", event.getEventName());
            if (event instanceof DIH4JDAThrowableEvent && event.getDIH4JDA().getConfig().isDefaultPrintStacktrace()) {
                ((DIH4JDAThrowableEvent)event).getThrowable().printStackTrace();
            }
        }
        for (DIH4JDAEventListener listener : event.getDIH4JDA().getEventListeners()) {
            try {
                for (Method method : listener.getClass().getMethods()) {
                    if (!method.getName().equals(event.getEventName())) continue;
                    method.invoke(listener.getClass().getConstructor(new Class[0]).newInstance(new Object[0]), event);
                }
            }
            catch (ReflectiveOperationException e) {
                DIH4JDALogger.error(e.getMessage(), new Object[0]);
            }
        }
    }

    @Nonnull
    public String getEventName() {
        return this.eventName;
    }

    @Nonnull
    public DIH4JDA getDIH4JDA() {
        return this.dih4jda;
    }

    @Nonnull
    public I getInteraction() {
        return this.interaction;
    }
}

