/*
 * Decompiled with CFR 0.152.
 */
package xyz.dynxsty.dih4jda.interactions.commands;

import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.Permission;

public abstract class RestrictedCommand {
    private final Map<Long, Cooldown> COOLDOWN_CACHE = new HashMap<Long, Cooldown>();
    private Long[] requiredGuilds = new Long[0];
    private Permission[] requiredPermissions = new Permission[0];
    private Long[] requiredUsers = new Long[0];
    private Long[] requiredRoles = new Long[0];
    private Duration commandCooldown = Duration.ZERO;

    public final void setRequiredGuilds(Long ... guilds) {
        this.requiredGuilds = guilds;
    }

    @Nonnull
    public Long[] getRequiredGuilds() {
        return this.requiredGuilds;
    }

    @Nonnull
    public final Permission[] getRequiredPermissions() {
        return this.requiredPermissions;
    }

    public final void setRequiredPermissions(Permission ... permissions) {
        this.requiredPermissions = permissions;
    }

    @Nonnull
    public final Long[] getRequiredUsers() {
        return this.requiredUsers;
    }

    public final void setRequiredUsers(Long ... users) {
        this.requiredUsers = users;
    }

    @Nonnull
    public final Long[] getRequiredRoles() {
        return this.requiredRoles;
    }

    public final void setRequiredRoles(Long ... roles) {
        this.requiredRoles = roles;
    }

    public void setCommandCooldown(@Nonnull Duration commandCooldown) {
        this.commandCooldown = commandCooldown;
    }

    @Nonnull
    public Duration getCommandCooldown() {
        return this.commandCooldown;
    }

    public void applyCooldown(long userId, @Nonnull Instant nextUse) {
        this.COOLDOWN_CACHE.put(userId, new Cooldown(Instant.now(), nextUse));
    }

    @Nonnull
    public Cooldown retrieveCooldown(long userId) {
        Cooldown cooldown = this.COOLDOWN_CACHE.get(userId);
        if (cooldown == null) {
            return new Cooldown(Instant.EPOCH, Instant.EPOCH);
        }
        return cooldown;
    }

    public boolean hasCooldown(long userId) {
        return this.retrieveCooldown(userId).getNextUse().isAfter(Instant.now());
    }

    public static class Cooldown {
        private final Instant lastUse;
        private final Instant nextUse;

        protected Cooldown(@Nonnull Instant lastUse, @Nonnull Instant nextUse) {
            this.lastUse = lastUse;
            this.nextUse = nextUse;
        }

        @Nonnull
        public Instant getNextUse() {
            return this.nextUse;
        }

        @Nonnull
        public Instant getLastUse() {
            return this.lastUse;
        }
    }
}

