/*
 * Decompiled with CFR 0.152.
 */
package xyz.dynxsty.dih4jda.util;

import java.lang.reflect.Constructor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import xyz.dynxsty.dih4jda.DIH4JDALogger;
import xyz.dynxsty.dih4jda.util.ClassUtils;

public class Checks {
    private Checks() {
    }

    public static boolean checkImplementation(@Nonnull Class<?> base, @Nonnull Class<?> implementation) {
        return ClassUtils.doesImplement(base, implementation);
    }

    public static boolean checkEmptyConstructor(@Nonnull Class<?> base) {
        for (Constructor<?> c : base.getConstructors()) {
            if (c.getParameterCount() != 0) continue;
            return true;
        }
        DIH4JDALogger.warn(String.format("Class %s contains unknown constructor parameters!", base.getSimpleName()), new Object[0]);
        return false;
    }

    public static void notNull(@Nullable Object argument, @Nonnull String name) {
        if (argument == null) {
            throw new IllegalArgumentException(name + " may not be null");
        }
    }
}

