/*
 * Decompiled with CFR 0.152.
 */
package xyz.dynxsty.dih4jda.util;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import xyz.dynxsty.dih4jda.exceptions.DIH4JDAException;
import xyz.dynxsty.dih4jda.exceptions.DIH4JDAReflectionException;
import xyz.dynxsty.dih4jda.exceptions.InvalidPackageException;
import xyz.dynxsty.dih4jda.util.IoUtils;

public class ClassWalker {
    private final String packageName;

    public ClassWalker(@Nonnull String packageName) {
        this.packageName = packageName;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public Set<Class<?>> getAllClasses() throws DIH4JDAException {
        try {
            Path root;
            String packagePath = this.packageName.replace('.', '/');
            ClassLoader classLoader = IoUtils.getClassLoaderForClass(ClassWalker.class);
            URL resourceUrl = classLoader.getResource(packagePath);
            if (resourceUrl == null) {
                throw new InvalidPackageException(String.format("%s package not found in ClassLoader", packagePath));
            }
            URI pkg = resourceUrl.toURI();
            FileSystem fileSystem = null;
            if (pkg.toString().startsWith("jar:")) {
                try {
                    root = FileSystems.getFileSystem(pkg).getPath(packagePath, new String[0]);
                }
                catch (FileSystemNotFoundException exception) {
                    fileSystem = FileSystems.newFileSystem(pkg, Collections.emptyMap());
                    root = fileSystem.getPath(packagePath, new String[0]);
                }
            } else {
                root = Paths.get(pkg);
            }
            try {
                Set<Class<?>> set;
                block19: {
                    Stream<Path> allPaths = Files.walk(root, new FileVisitOption[0]);
                    try {
                        set = allPaths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(file -> file.toString().endsWith(".class")).map(this::mapFileToName).map(clazz -> {
                            try {
                                return classLoader.loadClass((String)clazz);
                            }
                            catch (ClassNotFoundException exception) {
                                throw new UncheckedClassLoadException(exception);
                            }
                        }).collect(Collectors.toSet());
                        if (allPaths == null) break block19;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (allPaths != null) {
                                try {
                                    allPaths.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (UncheckedClassLoadException exception) {
                            throw new DIH4JDAReflectionException(exception.getCause());
                        }
                    }
                    allPaths.close();
                }
                return set;
            }
            finally {
                if (fileSystem != null) {
                    fileSystem.close();
                }
            }
        }
        catch (IOException | URISyntaxException exception) {
            throw new DIH4JDAReflectionException(exception);
        }
    }

    @Nonnull
    private String mapFileToName(@Nonnull Path file) {
        String path = file.toString().replace(file.getFileSystem().getSeparator(), ".");
        return path.substring(path.indexOf(this.packageName), path.length() - ".class".length());
    }

    @Nonnull
    public <T> Set<Class<? extends T>> getSubTypesOf(@Nonnull Class<T> type) throws DIH4JDAException {
        return this.getAllClasses().stream().filter(type::isAssignableFrom).map(clazz -> clazz).collect(Collectors.toSet());
    }

    private static class UncheckedClassLoadException
    extends RuntimeException {
        public UncheckedClassLoadException(@Nonnull Throwable cause) {
            super(cause);
        }
    }
}

