/*
 * Decompiled with CFR 0.152.
 */
package xyz.dynxsty.dih4jda.util;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import javax.annotation.Nonnull;
import xyz.dynxsty.dih4jda.util.IoUtils;

public class ClasspathHelper {
    private ClasspathHelper() {
    }

    @Nonnull
    public static Collection<URL> forPackage(@Nonnull String packageName) {
        ArrayList<URL> results = new ArrayList<URL>();
        ClassLoader loader = IoUtils.getClassLoaderForClass(ClasspathHelper.class);
        try {
            Enumeration<URL> urls = loader.getResources(ClasspathHelper.getResourceName(packageName));
            while (urls.hasMoreElements()) {
                results.add(urls.nextElement());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return results;
    }

    @Nonnull
    private static String getResourceName(@Nonnull String name) {
        String resource = name.replace(".", "/").replace("\\", "/");
        if (resource.startsWith("/")) {
            resource = resource.substring(1);
        }
        return resource;
    }
}

