/*
 * Decompiled with CFR 0.152.
 */
package xyz.dynxsty.dih4jda.util;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.interactions.commands.Command;
import net.dv8tion.jda.api.interactions.commands.build.CommandData;
import net.dv8tion.jda.api.interactions.commands.build.SlashCommandData;
import net.dv8tion.jda.api.utils.data.DataObject;
import xyz.dynxsty.dih4jda.interactions.commands.application.ContextCommand;
import xyz.dynxsty.dih4jda.interactions.commands.application.RegistrationType;
import xyz.dynxsty.dih4jda.interactions.commands.application.SlashCommand;
import xyz.dynxsty.dih4jda.util.ArrayUtil;
import xyz.dynxsty.dih4jda.util.Pair;

public class CommandUtils {
    private CommandUtils() {
    }

    public static synchronized boolean equals(@Nonnull DataObject data, @Nonnull DataObject other) {
        return Arrays.equals(ArrayUtil.sortArrayFromDataObject(data), ArrayUtil.sortArrayFromDataObject(other));
    }

    public static boolean compareSlashCommands(@Nonnull Command cmd, @Nonnull SlashCommand data) {
        return CommandUtils.equals(CommandData.fromCommand((Command)cmd).toData(), ((SlashCommandData)data.getCommandData()).toData());
    }

    public static boolean compareContextCommands(@Nonnull Command cmd, @Nonnull ContextCommand<?> data) {
        return CommandUtils.equals(CommandData.fromCommand((Command)cmd).toData(), ((CommandData)data.getCommandData()).toData());
    }

    @Nonnull
    public static String buildCommandPath(String ... args) {
        return String.join((CharSequence)" ", args);
    }

    @Nonnull
    public static String getNames(@Nonnull Set<ContextCommand<?>> command, @Nonnull Set<SlashCommand> slash) {
        StringBuilder names = new StringBuilder();
        command.forEach(c -> names.append(", ").append(((CommandData)c.getCommandData()).getName()));
        slash.forEach(c -> names.append(", /").append(((SlashCommandData)c.getCommandData()).getName()));
        return names.substring(2);
    }

    @Nonnull
    public static Pair<Set<SlashCommand>, Set<ContextCommand<?>>> filterByType(@Nonnull Pair<Set<SlashCommand>, Set<ContextCommand<?>>> pair, @Nonnull RegistrationType type) {
        return new Pair(pair.getFirst().stream().filter(c -> c.getRegistrationType().equals((Object)type)).collect(Collectors.toSet()), pair.getSecond().stream().filter(c -> c.getRegistrationType().equals((Object)type)).collect(Collectors.toSet()));
    }

    @Nonnull
    public static String getAsMention(@Nonnull SlashCommand command) {
        Command entity = command.asCommand();
        return entity.getAsMention();
    }

    @Nullable
    public static String getAsMention(@Nonnull SlashCommand.Subcommand command) {
        Command.Subcommand entity = command.asSubcommand();
        if (entity == null) {
            return null;
        }
        return entity.getAsMention();
    }
}

