package xyz.felh.openai.chat;

import com.alibaba.fastjson2.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import xyz.felh.openai.IOpenAiApiObject;

@Data
public class ChatCompletionChoice implements IOpenAiApiObject {

    /**
     * The reason the model stopped generating tokens. This will be stop if the model hit a natural stop point or a provided stop sequence, length if the maximum number of tokens specified in the request was reached, content_filter if content was omitted due to a flag from our content filters, tool_calls if the model called a tool, or function_call (deprecated) if the model called a function.
     */
    @JSONField(name = "finish_reason")
    @JsonProperty("finish_reason")
    private String finishReason;

    /**
     * The index of the choice in the list of choices.
     */
    @JSONField(name = "index")
    @JsonProperty("index")
    private Integer index;

    /**
     * A chat completion message generated by the model.
     * <p>
     * See {@link ChatMessage}
     */
    @JSONField(name = "message")
    @JsonProperty("message")
    private ChatMessage message;

    /**
     * A chat completion delta generated by streamed model responses.
     * <p>
     * See {@link ChatMessage}
     */
    @JSONField(name = "delta")
    @JsonProperty("delta")
    private ChatMessage delta;

}