package xyz.felh.openai.chat;

import com.fasterxml.jackson.annotation.JsonValue;

public enum ChatMessageRole {

    /**
     * content - Required The contents of the user message.
     * role - Required The role of the messages author, in this case user.
     */
    SYSTEM("system"),
    /**
     * content - Required The contents of the user message.
     * role - Required The role of the messages author, in this case user.
     */
    USER("user"),
    /**
     * content - Required The contents of the assistant message.
     * role - Required The role of the messages author, in this case assistant.
     * tool_calls -  Optional The tool calls generated by the model, such as function calls.
     */
    ASSISTANT("assistant"),
    /**
     * role - Required The role of the messages author, in this case tool.
     * content - Required The contents of the tool message.
     * tool_call_id - Required Tool call that this message is responding to.
     */
    TOOL("tool");

    private final String value;

    ChatMessageRole(final String value) {
        this.value = value;
    }

    @JsonValue
    public String value() {
        return value;
    }

}
