/*
 * Decompiled with CFR 0.152.
 */
package xyz.felh.openai.chat;

import com.alibaba.fastjson2.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.NonNull;
import xyz.felh.openai.IOpenAiBean;
import xyz.felh.openai.chat.ChatMessageRole;
import xyz.felh.openai.chat.tool.ToolCall;
import xyz.felh.openai.utils.ListUtils;
import xyz.felh.openai.utils.Preconditions;

public class ChatMessage
implements IOpenAiBean {
    @JSONField(name="role")
    @JsonProperty(value="role")
    @NonNull
    private ChatMessageRole role;
    @JSONField(name="content")
    @JsonProperty(value="content")
    private Object content;
    @JSONField(name="name")
    @JsonProperty(value="name")
    private String name;
    @JSONField(name="tool_calls")
    @JsonProperty(value="tool_calls")
    private List<ToolCall> toolCalls;
    @JSONField(name="tool_call_id")
    @JsonProperty(value="tool_call_id")
    private String toolCallId;

    public ChatMessage(@NonNull ChatMessageRole role, Object content) {
        this(role, null, content);
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
    }

    public ChatMessage(@NonNull ChatMessageRole role, String name, Object content) {
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        this.role = role;
        this.name = name;
        this.content = content;
    }

    public void addTextToContent(String text) {
        List<ContentItem> list = this.getListExtractFromContent();
        list.add(ContentItem.buildText(text));
        this.content = list;
    }

    public void addImageBase64ToContent(String base64) {
        this.addImageBase64ToContent(base64, ImageUrlDetail.LOW);
    }

    public void addImageBase64ToContent(String base64, ImageUrlDetail detail) {
        List<ContentItem> list = this.getListExtractFromContent();
        list.add(ContentItem.buildImageWithBase64(base64, detail));
        this.content = list;
    }

    public void addImageUrlToContent(String imageUrl) {
        this.addImageUrlToContent(imageUrl, ImageUrlDetail.LOW);
    }

    public void addImageUrlToContent(String imageUrl, ImageUrlDetail detail) {
        List<ContentItem> list = this.getListExtractFromContent();
        list.add(ContentItem.buildImageWithUrl(imageUrl, detail));
        this.content = list;
    }

    private List<ContentItem> getListExtractFromContent() {
        if (Preconditions.isNotBlank(this.content) && this.content instanceof List) {
            return ListUtils.castList(this.content, ContentItem.class);
        }
        return new ArrayList<ContentItem>();
    }

    public static ChatMessageBuilder builder() {
        return new ChatMessageBuilder();
    }

    @NonNull
    public ChatMessageRole getRole() {
        return this.role;
    }

    public Object getContent() {
        return this.content;
    }

    public String getName() {
        return this.name;
    }

    public List<ToolCall> getToolCalls() {
        return this.toolCalls;
    }

    public String getToolCallId() {
        return this.toolCallId;
    }

    @JsonProperty(value="role")
    public void setRole(@NonNull ChatMessageRole role) {
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        this.role = role;
    }

    @JsonProperty(value="content")
    public void setContent(Object content) {
        this.content = content;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="tool_calls")
    public void setToolCalls(List<ToolCall> toolCalls) {
        this.toolCalls = toolCalls;
    }

    @JsonProperty(value="tool_call_id")
    public void setToolCallId(String toolCallId) {
        this.toolCallId = toolCallId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatMessage)) {
            return false;
        }
        ChatMessage other = (ChatMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ChatMessageRole this$role = this.getRole();
        ChatMessageRole other$role = other.getRole();
        if (this$role == null ? other$role != null : !((Object)((Object)this$role)).equals((Object)other$role)) {
            return false;
        }
        Object this$content = this.getContent();
        Object other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<ToolCall> this$toolCalls = this.getToolCalls();
        List<ToolCall> other$toolCalls = other.getToolCalls();
        if (this$toolCalls == null ? other$toolCalls != null : !((Object)this$toolCalls).equals(other$toolCalls)) {
            return false;
        }
        String this$toolCallId = this.getToolCallId();
        String other$toolCallId = other.getToolCallId();
        return !(this$toolCallId == null ? other$toolCallId != null : !this$toolCallId.equals(other$toolCallId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ChatMessageRole $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : ((Object)((Object)$role)).hashCode());
        Object $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<ToolCall> $toolCalls = this.getToolCalls();
        result = result * 59 + ($toolCalls == null ? 43 : ((Object)$toolCalls).hashCode());
        String $toolCallId = this.getToolCallId();
        result = result * 59 + ($toolCallId == null ? 43 : $toolCallId.hashCode());
        return result;
    }

    public String toString() {
        return "ChatMessage(role=" + String.valueOf((Object)this.getRole()) + ", content=" + String.valueOf(this.getContent()) + ", name=" + this.getName() + ", toolCalls=" + String.valueOf(this.getToolCalls()) + ", toolCallId=" + this.getToolCallId() + ")";
    }

    public ChatMessage() {
    }

    public ChatMessage(@NonNull ChatMessageRole role, Object content, String name, List<ToolCall> toolCalls, String toolCallId) {
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        this.role = role;
        this.content = content;
        this.name = name;
        this.toolCalls = toolCalls;
        this.toolCallId = toolCallId;
    }

    public static class ContentItem
    implements IOpenAiBean {
        @JSONField(name="type")
        @JsonProperty(value="type")
        private ContentType type;
        @JSONField(name="text")
        @JsonProperty(value="text")
        private String text;
        @JSONField(name="image_url")
        @JsonProperty(value="image_url")
        private ImageUrl imageUrl;

        public static ContentItem buildText(String text) {
            return ContentItem.builder().type(ContentType.TEXT).text(text).build();
        }

        public static ContentItem buildImageWithBase64(String base64, ImageUrlDetail detail) {
            return ContentItem.builder().type(ContentType.IMAGE_URL).imageUrl(ImageUrl.builder().url(String.format("f\"%s\"", base64)).detail(detail).build()).build();
        }

        public static ContentItem buildImageWithUrl(String imageUrl, ImageUrlDetail detail) {
            return ContentItem.builder().type(ContentType.IMAGE_URL).imageUrl(ImageUrl.builder().url(imageUrl).detail(detail).build()).build();
        }

        public static ContentItemBuilder builder() {
            return new ContentItemBuilder();
        }

        public ContentType getType() {
            return this.type;
        }

        public String getText() {
            return this.text;
        }

        public ImageUrl getImageUrl() {
            return this.imageUrl;
        }

        @JsonProperty(value="type")
        public void setType(ContentType type) {
            this.type = type;
        }

        @JsonProperty(value="text")
        public void setText(String text) {
            this.text = text;
        }

        @JsonProperty(value="image_url")
        public void setImageUrl(ImageUrl imageUrl) {
            this.imageUrl = imageUrl;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ContentItem)) {
                return false;
            }
            ContentItem other = (ContentItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ContentType this$type = this.getType();
            ContentType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
                return false;
            }
            ImageUrl this$imageUrl = this.getImageUrl();
            ImageUrl other$imageUrl = other.getImageUrl();
            return !(this$imageUrl == null ? other$imageUrl != null : !((Object)this$imageUrl).equals(other$imageUrl));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ContentItem;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ContentType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            ImageUrl $imageUrl = this.getImageUrl();
            result = result * 59 + ($imageUrl == null ? 43 : ((Object)$imageUrl).hashCode());
            return result;
        }

        public String toString() {
            return "ChatMessage.ContentItem(type=" + String.valueOf((Object)this.getType()) + ", text=" + this.getText() + ", imageUrl=" + String.valueOf(this.getImageUrl()) + ")";
        }

        public ContentItem() {
        }

        public ContentItem(ContentType type, String text, ImageUrl imageUrl) {
            this.type = type;
            this.text = text;
            this.imageUrl = imageUrl;
        }

        public static class ContentItemBuilder {
            private ContentType type;
            private String text;
            private ImageUrl imageUrl;

            ContentItemBuilder() {
            }

            @JsonProperty(value="type")
            public ContentItemBuilder type(ContentType type) {
                this.type = type;
                return this;
            }

            @JsonProperty(value="text")
            public ContentItemBuilder text(String text) {
                this.text = text;
                return this;
            }

            @JsonProperty(value="image_url")
            public ContentItemBuilder imageUrl(ImageUrl imageUrl) {
                this.imageUrl = imageUrl;
                return this;
            }

            public ContentItem build() {
                return new ContentItem(this.type, this.text, this.imageUrl);
            }

            public String toString() {
                return "ChatMessage.ContentItem.ContentItemBuilder(type=" + String.valueOf((Object)this.type) + ", text=" + this.text + ", imageUrl=" + String.valueOf(this.imageUrl) + ")";
            }
        }
    }

    public static enum ImageUrlDetail {
        LOW("low"),
        HIGH("high");

        private final String value;

        private ImageUrlDetail(String value) {
            this.value = value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        public static ImageUrlDetail findByValue(String value) {
            return Arrays.stream(ImageUrlDetail.values()).filter(it -> it.value.equals(value)).findFirst().orElse(null);
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class ChatMessageBuilder {
        private ChatMessageRole role;
        private Object content;
        private String name;
        private List<ToolCall> toolCalls;
        private String toolCallId;

        ChatMessageBuilder() {
        }

        @JsonProperty(value="role")
        public ChatMessageBuilder role(@NonNull ChatMessageRole role) {
            if (role == null) {
                throw new NullPointerException("role is marked non-null but is null");
            }
            this.role = role;
            return this;
        }

        @JsonProperty(value="content")
        public ChatMessageBuilder content(Object content) {
            this.content = content;
            return this;
        }

        @JsonProperty(value="name")
        public ChatMessageBuilder name(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="tool_calls")
        public ChatMessageBuilder toolCalls(List<ToolCall> toolCalls) {
            this.toolCalls = toolCalls;
            return this;
        }

        @JsonProperty(value="tool_call_id")
        public ChatMessageBuilder toolCallId(String toolCallId) {
            this.toolCallId = toolCallId;
            return this;
        }

        public ChatMessage build() {
            return new ChatMessage(this.role, this.content, this.name, this.toolCalls, this.toolCallId);
        }

        public String toString() {
            return "ChatMessage.ChatMessageBuilder(role=" + String.valueOf((Object)this.role) + ", content=" + String.valueOf(this.content) + ", name=" + this.name + ", toolCalls=" + String.valueOf(this.toolCalls) + ", toolCallId=" + this.toolCallId + ")";
        }
    }

    public static enum ContentType {
        TEXT("text"),
        IMAGE_URL("image_url");

        private final String value;

        private ContentType(String value) {
            this.value = value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        public static ContentType findByValue(String value) {
            return Arrays.stream(ContentType.values()).filter(it -> it.value.equals(value)).findFirst().orElse(null);
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class ImageUrl
    implements IOpenAiBean {
        @JSONField(name="url")
        @JsonProperty(value="url")
        @NonNull
        private String url;
        @JSONField(name="detail")
        @JsonProperty(value="detail")
        private ImageUrlDetail detail;

        public static ImageUrlBuilder builder() {
            return new ImageUrlBuilder();
        }

        @NonNull
        public String getUrl() {
            return this.url;
        }

        public ImageUrlDetail getDetail() {
            return this.detail;
        }

        @JsonProperty(value="url")
        public void setUrl(@NonNull String url) {
            if (url == null) {
                throw new NullPointerException("url is marked non-null but is null");
            }
            this.url = url;
        }

        @JsonProperty(value="detail")
        public void setDetail(ImageUrlDetail detail) {
            this.detail = detail;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ImageUrl)) {
                return false;
            }
            ImageUrl other = (ImageUrl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            ImageUrlDetail this$detail = this.getDetail();
            ImageUrlDetail other$detail = other.getDetail();
            return !(this$detail == null ? other$detail != null : !((Object)((Object)this$detail)).equals((Object)other$detail));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ImageUrl;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            ImageUrlDetail $detail = this.getDetail();
            result = result * 59 + ($detail == null ? 43 : ((Object)((Object)$detail)).hashCode());
            return result;
        }

        public String toString() {
            return "ChatMessage.ImageUrl(url=" + this.getUrl() + ", detail=" + String.valueOf((Object)this.getDetail()) + ")";
        }

        public ImageUrl() {
        }

        public ImageUrl(@NonNull String url, ImageUrlDetail detail) {
            if (url == null) {
                throw new NullPointerException("url is marked non-null but is null");
            }
            this.url = url;
            this.detail = detail;
        }

        public static class ImageUrlBuilder {
            private String url;
            private ImageUrlDetail detail;

            ImageUrlBuilder() {
            }

            @JsonProperty(value="url")
            public ImageUrlBuilder url(@NonNull String url) {
                if (url == null) {
                    throw new NullPointerException("url is marked non-null but is null");
                }
                this.url = url;
                return this;
            }

            @JsonProperty(value="detail")
            public ImageUrlBuilder detail(ImageUrlDetail detail) {
                this.detail = detail;
                return this;
            }

            public ImageUrl build() {
                return new ImageUrl(this.url, this.detail);
            }

            public String toString() {
                return "ChatMessage.ImageUrl.ImageUrlBuilder(url=" + this.url + ", detail=" + String.valueOf((Object)this.detail) + ")";
            }
        }
    }
}

