package com.hmh.hamyeonham.hus.usagestats

import android.content.Context

object HMHUsageStatsManager {
    private var hmhUsageStatsDataSource: HMHUsageStats? = null

    fun init(context: Context) {
        hmhUsageStatsDataSource = HMHUsageStatsDataSource(context.applicationContext)
    }

    suspend fun getUsageStats(
        startTime: Long,
        endTime: Long
    ): List<AppUsageInfo> {
        if (hmhUsageStatsDataSource == null) {
            throw HMHUsageStatsException("HMHUsageStatsManager is not initialized")
        }
        return hmhUsageStatsDataSource?.getUsageStats(startTime, endTime) ?: emptyList()
    }

    fun getForegroundAppPackageName(): String? {
        if (hmhUsageStatsDataSource == null) {
            throw HMHUsageStatsException("HMHUsageStatsManager is not initialized")
        }
        return hmhUsageStatsDataSource?.getForegroundAppPackageName()
    }
}