/*
 * Decompiled with CFR 0.152.
 */
package xyz.ielis.hyperutil.reference.fasta;

import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.ielis.hyperutil.reference.fasta.GenomeSequenceAccessor;
import xyz.ielis.hyperutil.reference.fasta.SingleChromosomeGenomeSequenceAccessor;
import xyz.ielis.hyperutil.reference.fasta.SingleFastaGenomeSequenceAccessor;

public class GenomeSequenceAccessorBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenomeSequenceAccessorBuilder.class);
    private Path fastaPath;
    private Path fastaFaiPath;
    private Path fastaDictPath;
    private GenomeSequenceAccessor.Type type = GenomeSequenceAccessor.Type.SINGLE_FASTA;
    private boolean requireMt = true;

    private GenomeSequenceAccessorBuilder() {
    }

    public static GenomeSequenceAccessorBuilder builder() {
        return new GenomeSequenceAccessorBuilder();
    }

    public GenomeSequenceAccessorBuilder setFastaPath(Path fastaPath) {
        this.fastaPath = fastaPath;
        return this;
    }

    public GenomeSequenceAccessorBuilder setFastaFaiPath(Path fastaFaiPath) {
        this.fastaFaiPath = fastaFaiPath;
        return this;
    }

    public GenomeSequenceAccessorBuilder setFastaDictPath(Path fastaDictPath) {
        this.fastaDictPath = fastaDictPath;
        return this;
    }

    public GenomeSequenceAccessorBuilder setType(GenomeSequenceAccessor.Type type) {
        this.type = type;
        return this;
    }

    public GenomeSequenceAccessorBuilder setRequireMt(boolean requireMt) {
        this.requireMt = requireMt;
        return this;
    }

    public GenomeSequenceAccessor build() {
        if (!this.fastaPath.toFile().isFile()) {
            throw new IllegalArgumentException(String.format("%s does not exist", this.fastaPath));
        }
        if (this.fastaFaiPath == null) {
            Path expectedFaiPath = this.fastaPath.resolveSibling(this.fastaPath.toFile().getName() + ".fai");
            if (expectedFaiPath.toFile().isFile()) {
                LOGGER.debug("Found fasta index at `{}`", (Object)expectedFaiPath);
                this.fastaFaiPath = expectedFaiPath;
            } else {
                throw new IllegalArgumentException(String.format("Path to fasta index unset and did not find the index at `%s`", expectedFaiPath));
            }
        }
        if (this.fastaDictPath == null) {
            Path expectedDictPath = this.fastaPath.resolveSibling(this.fastaPath.toFile().getName() + ".dict");
            if (expectedDictPath.toFile().isFile()) {
                LOGGER.debug("Found fasta dictionary at `{}`", (Object)expectedDictPath);
                this.fastaDictPath = expectedDictPath;
            } else {
                throw new IllegalArgumentException(String.format("Path to fasta dictionary unset and did not find the dict at `%s`", expectedDictPath));
            }
        }
        switch (this.type) {
            case SINGLE_CHROMOSOME: {
                return new SingleChromosomeGenomeSequenceAccessor(this.fastaPath, this.fastaFaiPath, this.fastaDictPath, this.requireMt);
            }
            case SINGLE_FASTA: {
                return new SingleFastaGenomeSequenceAccessor(this.fastaPath, this.fastaFaiPath, this.fastaDictPath, this.requireMt);
            }
        }
        throw new IllegalArgumentException(String.format("Unknown type `%s`", new Object[]{this.type}));
    }
}

