/*
 * Decompiled with CFR 0.152.
 */
package xyz.ielis.hyperutil.reference.fasta;

import java.util.HashMap;
import java.util.Map;

class ReverseComplement {
    private static final Map<Character, Character> IUPAC = ReverseComplement.makeIupacMap();

    ReverseComplement() {
    }

    static String reverseComplement(String seq) {
        char[] oldSeq = seq.toCharArray();
        char[] newSeq = new char[oldSeq.length];
        for (int i = 0; i < oldSeq.length; ++i) {
            newSeq[oldSeq.length - i - 1] = IUPAC.getOrDefault(Character.valueOf(oldSeq[i]), Character.valueOf('N')).charValue();
        }
        return new String(newSeq);
    }

    private static Map<Character, Character> makeIupacMap() {
        HashMap<Character, Character> temporary = new HashMap<Character, Character>();
        temporary.putAll(Map.of(Character.valueOf('A'), Character.valueOf('T'), Character.valueOf('a'), Character.valueOf('t'), Character.valueOf('C'), Character.valueOf('G'), Character.valueOf('c'), Character.valueOf('g'), Character.valueOf('G'), Character.valueOf('C'), Character.valueOf('g'), Character.valueOf('c'), Character.valueOf('T'), Character.valueOf('A'), Character.valueOf('t'), Character.valueOf('a'), Character.valueOf('U'), Character.valueOf('A'), Character.valueOf('u'), Character.valueOf('a')));
        temporary.putAll(Map.of(Character.valueOf('W'), Character.valueOf('W'), Character.valueOf('w'), Character.valueOf('w'), Character.valueOf('S'), Character.valueOf('S'), Character.valueOf('s'), Character.valueOf('s'), Character.valueOf('M'), Character.valueOf('K'), Character.valueOf('m'), Character.valueOf('k'), Character.valueOf('K'), Character.valueOf('M'), Character.valueOf('k'), Character.valueOf('m')));
        temporary.putAll(Map.of(Character.valueOf('R'), Character.valueOf('Y'), Character.valueOf('r'), Character.valueOf('y'), Character.valueOf('Y'), Character.valueOf('R'), Character.valueOf('y'), Character.valueOf('r')));
        temporary.putAll(Map.of(Character.valueOf('B'), Character.valueOf('V'), Character.valueOf('b'), Character.valueOf('v'), Character.valueOf('D'), Character.valueOf('H'), Character.valueOf('d'), Character.valueOf('h'), Character.valueOf('H'), Character.valueOf('D'), Character.valueOf('h'), Character.valueOf('d'), Character.valueOf('V'), Character.valueOf('B'), Character.valueOf('v'), Character.valueOf('b'), Character.valueOf('N'), Character.valueOf('N'), Character.valueOf('n'), Character.valueOf('n')));
        return temporary;
    }
}

