/*
 * Decompiled with CFR 0.152.
 */
package xyz.ielis.hyperutil.reference.fasta;

import de.charite.compbio.jannovar.reference.GenomeInterval;
import java.util.Objects;
import java.util.Optional;
import xyz.ielis.hyperutil.reference.fasta.ReverseComplement;
import xyz.ielis.hyperutil.reference.fasta.SequenceInterval;

class SequenceIntervalDefault
implements SequenceInterval {
    private final GenomeInterval interval;
    private final String sequence;

    protected SequenceIntervalDefault(GenomeInterval interval, String sequence) {
        this.interval = Objects.requireNonNull(interval, "Interval cannot be null");
        this.sequence = Objects.requireNonNull(sequence, "Sequence cannot be null");
        if (interval.length() != sequence.length()) {
            throw new IllegalArgumentException(String.format("Lengths do not match: interval %s != sequence %s", interval.length(), sequence.length()));
        }
    }

    static SequenceIntervalDefault of(GenomeInterval interval, String sequence) {
        return new SequenceIntervalDefault(interval, sequence);
    }

    static String reverseComplement(String sequence) {
        return ReverseComplement.reverseComplement(sequence);
    }

    @Override
    public GenomeInterval getInterval() {
        return this.interval;
    }

    @Override
    public String getSequence() {
        return this.sequence;
    }

    @Override
    public Optional<String> getSubsequence(GenomeInterval interval) {
        if (this.interval.contains(interval)) {
            GenomeInterval onStrand = interval.withStrand(this.interval.getStrand());
            String seq = this.sequence.substring(onStrand.getBeginPos() - this.interval.getBeginPos(), onStrand.getEndPos() - this.interval.getBeginPos());
            return interval.getStrand().equals((Object)this.interval.getStrand()) ? Optional.of(seq) : Optional.of(SequenceIntervalDefault.reverseComplement(seq));
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SequenceIntervalDefault that = (SequenceIntervalDefault)o;
        return Objects.equals(this.interval, that.interval) && Objects.equals(this.sequence, that.sequence);
    }

    public int hashCode() {
        return Objects.hash(this.interval, this.sequence);
    }

    public String toString() {
        return "SEQ{ " + this.interval + ", '" + this.sequence + "'}";
    }
}

