/*
 * Decompiled with CFR 0.152.
 */
package xyz.ielis.hyperutil.reference.fasta;

import de.charite.compbio.jannovar.data.ReferenceDictionary;
import de.charite.compbio.jannovar.data.ReferenceDictionaryBuilder;
import de.charite.compbio.jannovar.reference.GenomeInterval;
import de.charite.compbio.jannovar.reference.Strand;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.reference.FastaSequenceIndex;
import htsjdk.samtools.reference.IndexedFastaSequenceFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.variant.utils.SAMSequenceDictionaryExtractor;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.ielis.hyperutil.reference.fasta.GenomeSequenceAccessor;
import xyz.ielis.hyperutil.reference.fasta.InvalidFastaFileException;
import xyz.ielis.hyperutil.reference.fasta.SequenceInterval;
import xyz.ielis.hyperutil.reference.fasta.SequenceIntervalDefault;

public class SingleFastaGenomeSequenceAccessor
implements GenomeSequenceAccessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SingleFastaGenomeSequenceAccessor.class);
    protected final IndexedFastaSequenceFile fasta;
    private final boolean usesPrefix;
    private final boolean requireMt;
    private final SAMSequenceDictionary sequenceDictionary;
    private final ReferenceDictionary referenceDictionary;

    SingleFastaGenomeSequenceAccessor(Path fastaPath, Path fastaFai, Path fastaDict) {
        this(fastaPath, fastaFai, fastaDict, true);
    }

    SingleFastaGenomeSequenceAccessor(Path fastaPath, Path fastaFai, Path fastaDict, boolean requireMt) {
        this.fasta = new IndexedFastaSequenceFile(fastaPath, new FastaSequenceIndex(fastaFai));
        this.requireMt = requireMt;
        this.sequenceDictionary = SingleFastaGenomeSequenceAccessor.buildSequenceDictionary(fastaDict);
        this.usesPrefix = SingleFastaGenomeSequenceAccessor.figureOutPrefix(this.sequenceDictionary);
        this.referenceDictionary = this.buildReferenceDictionary(this.sequenceDictionary);
    }

    private static boolean figureOutPrefix(SAMSequenceDictionary sequenceDictionary) {
        Predicate<SAMSequenceRecord> prefixed = e -> e.getSequenceName().startsWith("chr");
        boolean allPrefixed = sequenceDictionary.getSequences().stream().allMatch(prefixed);
        boolean nonePrefixed = sequenceDictionary.getSequences().stream().noneMatch(prefixed);
        if (allPrefixed) {
            return true;
        }
        if (nonePrefixed) {
            return false;
        }
        String msg = String.format("Found prefixed and unprefixed contigs among fasta dictionary entries - %s", sequenceDictionary.getSequences().stream().map(SAMSequenceRecord::getSequenceName).collect(Collectors.joining(",", "{", "}")));
        LOGGER.error(msg);
        throw new InvalidFastaFileException(msg);
    }

    private static SAMSequenceDictionary buildSequenceDictionary(Path dictPath) {
        return SAMSequenceDictionaryExtractor.extractDictionary((Path)dictPath);
    }

    private ReferenceDictionary buildReferenceDictionary(SAMSequenceDictionary sequenceDictionary) {
        Integer mtId;
        ReferenceDictionaryBuilder rdb = new ReferenceDictionaryBuilder();
        for (int i = 0; i < sequenceDictionary.getSequences().size(); ++i) {
            String noChr;
            Object withChr;
            SAMSequenceRecord seq = (SAMSequenceRecord)sequenceDictionary.getSequences().get(i);
            String sequenceName = seq.getSequenceName();
            if (sequenceName.startsWith("chr")) {
                withChr = sequenceName;
                noChr = sequenceName.substring(3);
            } else {
                withChr = "chr" + sequenceName;
                noChr = sequenceName;
            }
            rdb.putContigID((String)withChr, i);
            rdb.putContigID(noChr, i);
            rdb.putContigName(i, (String)(this.usesPrefix ? withChr : noChr));
            rdb.putContigLength(i, seq.getSequenceLength());
        }
        String mt = this.usesPrefix ? "chrMT" : "MT";
        String m = this.usesPrefix ? "chrM" : "M";
        Integer n = mtId = rdb.getContigID(mt) != null ? rdb.getContigID(mt) : rdb.getContigID(m);
        if (mtId == null) {
            if (this.requireMt) {
                throw new InvalidFastaFileException("Missing mitochondrial contig among contigs " + sequenceDictionary.getSequences().stream().map(SAMSequenceRecord::getSequenceName).collect(Collectors.joining(",", "{", "}")));
            }
        } else {
            String mtName = rdb.getContigName(mtId);
            if (mtName.contains("MT")) {
                rdb.putContigID("chrM", mtId.intValue());
                rdb.putContigID("M", mtId.intValue());
            } else if (mtName.contains("M")) {
                rdb.putContigID("chrMT", mtId.intValue());
                rdb.putContigID("MT", mtId.intValue());
            } else {
                throw new InvalidFastaFileException("Unexpected name of mitochondrial contig " + mtName);
            }
        }
        return rdb.build();
    }

    @Override
    public Optional<SequenceInterval> fetchSequence(GenomeInterval query) {
        String seq;
        String queryContigName = (String)query.getRefDict().getContigIDToName().get((Object)query.getChr());
        if (!this.referenceDictionary.getContigNameToID().containsKey((Object)queryContigName)) {
            LOGGER.warn("Unknown chromosome `{}`", (Object)queryContigName);
            return Optional.empty();
        }
        int primaryContigId = (Integer)this.referenceDictionary.getContigNameToID().get((Object)queryContigName);
        String primaryContigName = (String)this.referenceDictionary.getContigIDToName().get((Object)primaryContigId);
        GenomeInterval onStrand = query.withStrand(Strand.FWD);
        try {
            seq = this.fetchSequence(primaryContigName, onStrand.getBeginPos() + 1, onStrand.getEndPos());
        }
        catch (SAMException e) {
            LOGGER.warn("Error getting sequence for query `{}`: {}", (Object)query, (Object)e.getMessage());
            return Optional.empty();
        }
        switch (query.getStrand()) {
            case FWD: {
                return Optional.of(SequenceIntervalDefault.of(query, seq));
            }
            case REV: {
                return Optional.of(SequenceIntervalDefault.of(query, SequenceIntervalDefault.reverseComplement(seq)));
            }
        }
        throw new IllegalArgumentException(String.format("Unknown strand `%s`", query.getStrand()));
    }

    @Override
    public ReferenceDictionary getReferenceDictionary() {
        return this.referenceDictionary;
    }

    @Override
    public String fetchSequence(String chr, int start, int end) throws SAMException {
        Object chrom = chr.startsWith("chr") ? chr : "chr" + chr;
        ReferenceSequence referenceSequence = this.fasta.getSubsequenceAt((String)chrom, (long)start, (long)end);
        return new String(referenceSequence.getBases());
    }

    @Override
    public void close() throws IOException {
        this.fasta.close();
    }
}

