/*
 * Decompiled with CFR 0.152.
 */
package xyz.mattyb.checkmate;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.mattyb.checkmate.BooleanCheck;
import xyz.mattyb.checkmate.Check;
import xyz.mattyb.checkmate.Index;
import xyz.mattyb.checkmate.InstanceCheck;
import xyz.mattyb.checkmate.Range;
import xyz.mattyb.checkmate.checker.BooleanCheckers;
import xyz.mattyb.checkmate.checker.IndexCheckers;
import xyz.mattyb.checkmate.checker.NotEmptyCheckers;
import xyz.mattyb.checkmate.checker.NullCheckers;
import xyz.mattyb.checkmate.checker.NumberCheckers;
import xyz.mattyb.checkmate.checker.TypeCheckers;
import xyz.mattyb.checkmate.checker.context.CheckerContext;
import xyz.mattyb.checkmate.checker.context.DefaultCheckerContext;
import xyz.mattyb.checkmate.checker.context.NoOpCheckerContext;
import xyz.mattyb.checkmate.checkmate.BooleanCheckMate;
import xyz.mattyb.checkmate.checkmate.DoubleRangeCheckMate;
import xyz.mattyb.checkmate.checkmate.IndexCheckMate;
import xyz.mattyb.checkmate.checkmate.InstanceCheckMate;
import xyz.mattyb.checkmate.checkmate.IntRangeCheckMate;
import xyz.mattyb.checkmate.checkmate.LongRangeCheckMate;
import xyz.mattyb.checkmate.checkmate.NotEmptyCheckMate;

public class CheckMate
implements NotEmptyCheckMate,
IntRangeCheckMate,
LongRangeCheckMate,
DoubleRangeCheckMate,
IndexCheckMate,
BooleanCheckMate,
InstanceCheckMate {
    private static final Logger log = LoggerFactory.getLogger(CheckMate.class);
    private static final CheckerContext NO_OP = new NoOpCheckerContext();
    private final List<Check<?>> checks = new ArrayList();
    private final Class<? extends RuntimeException> defaultException;
    private final boolean throwNpe;

    private CheckMate(Class<? extends RuntimeException> defaultException, Option option) {
        this.defaultException = defaultException;
        this.throwNpe = Option.THROW_NPE.equals((Object)option);
    }

    public static CheckMate check() {
        return new CheckMate(IllegalArgumentException.class, Option.NONE);
    }

    public static CheckMate check(Option option) {
        return new CheckMate(IllegalArgumentException.class, option);
    }

    public static CheckMate checkWithDefault(Class<? extends RuntimeException> defaultException) {
        return new CheckMate(defaultException, Option.NONE);
    }

    public void validate() {
        for (Check<?> check : this.checks) {
            DefaultCheckerContext ctx = new DefaultCheckerContext();
            if (!check.getChecker().test(check.getToCheck(), ctx)) continue;
            String message = check.getMessage() == null ? check.getChecker().getExceptionMessage(check.getToCheck(), ctx) : check.getMessage();
            Class throwableClass = this.throwNpe && ctx.isNpe() ? NullPointerException.class : check.getThrowableClass();
            throw Objects.requireNonNull(this.create(throwableClass, message));
        }
    }

    public boolean anyInvalid() {
        return this.checks.stream().anyMatch(check -> check.getChecker().test(check.getToCheck(), NO_OP));
    }

    public boolean allInvalid() {
        return this.checks.stream().allMatch(check -> check.getChecker().test(check.getToCheck(), NO_OP));
    }

    public CheckMate withException(Class<? extends RuntimeException> throwableClass) {
        this.last().setThrowableClass(throwableClass);
        return this;
    }

    public CheckMate withMessage(String message, Object ... values) {
        String formatted = String.format(message, values);
        this.last().setMessage(formatted);
        return this;
    }

    public <T> CheckMate notNull(T object) {
        this.checks.add(new Check<T>(object, NullCheckers.notNull));
        return this;
    }

    @Override
    public <T extends Collection<?>> CheckMate notEmpty(T collection) {
        this.checks.add(new Check<T>(collection, NotEmptyCheckers.collection));
        return this;
    }

    @Override
    public <T extends CharSequence> CheckMate notEmpty(T chars) {
        this.checks.add(new Check<T>(chars, NotEmptyCheckers.charSequence));
        return this;
    }

    @Override
    public <T extends CharSequence> CheckMate notBlank(T chars) {
        this.checks.add(new Check<T>(chars, NotEmptyCheckers.charSequenceNotBlank));
        return this;
    }

    @Override
    public <T> CheckMate notEmpty(T[] array) {
        this.checks.add(new Check<T[]>(array, NotEmptyCheckers.array));
        return this;
    }

    @Override
    public <T extends Map<?, ?>> CheckMate notEmpty(T map) {
        this.checks.add(new Check<T>(map, NotEmptyCheckers.map));
        return this;
    }

    public <T> CheckMate noNullElements(T[] array) {
        this.checks.add(new Check<T[]>(array, NullCheckers.noNullElementsArray));
        return this;
    }

    public <T extends Iterable<?>> CheckMate noNullElements(T collection) {
        this.checks.add(new Check<T>(collection, NullCheckers.noNullElementsIterable));
        return this;
    }

    @Override
    public BooleanCheckMate is(boolean expression) {
        BooleanCheck booleanCheck = new BooleanCheck();
        booleanCheck.setSupplier(() -> expression);
        this.checks.add(new Check<BooleanCheck>(booleanCheck, BooleanCheckers.isBoolean));
        return this;
    }

    @Override
    public BooleanCheckMate is(Supplier<Boolean> supplier) {
        BooleanCheck booleanCheck = new BooleanCheck();
        booleanCheck.setSupplier(supplier);
        this.checks.add(new Check<BooleanCheck>(booleanCheck, BooleanCheckers.isBoolean));
        return this;
    }

    @Override
    public CheckMate truthy() {
        ((BooleanCheck)this.last().getToCheck()).setExpected(true);
        return this;
    }

    @Override
    public CheckMate falsy() {
        ((BooleanCheck)this.last().getToCheck()).setExpected(false);
        return this;
    }

    public IndexCheckMate isIndex(int index) {
        Index checkIndex = new Index();
        checkIndex.setIndex(index);
        this.checks.add(new Check<Index>(checkIndex, IndexCheckers.indexChecker));
        return this;
    }

    @Override
    public <T> CheckMate validIn(T[] array) {
        ((Index)this.last().getToCheck()).calcSize(array);
        return this;
    }

    @Override
    public <T extends Collection<?>> CheckMate validIn(T collection) {
        ((Index)this.last().getToCheck()).calcSize(collection);
        return this;
    }

    @Override
    public <T extends CharSequence> CheckMate validIn(T chars) {
        ((Index)this.last().getToCheck()).calcSize(chars);
        return this;
    }

    @Override
    public <T> InstanceCheckMate object(T obj) {
        InstanceCheck check = new InstanceCheck(obj);
        this.checks.add(new Check<InstanceCheck>(check, TypeCheckers.instanceOf));
        return this;
    }

    @Override
    public CheckMate isInstanceOf(Class<?> clazz) {
        ((InstanceCheck)this.last().getToCheck()).setClazz(clazz);
        return this;
    }

    @Override
    public IntRangeCheckMate intValue(Comparable<Integer> value) {
        Range<Integer> range = new Range<Integer>();
        range.setValue(value);
        this.checks.add(new Check(range, NumberCheckers.intOutOfRange));
        return this;
    }

    @Override
    public IntRangeCheckMate between(Integer start) {
        ((Range)this.last().getToCheck()).setStart(start);
        return this;
    }

    @Override
    public CheckMate and(Integer endExclusive) {
        ((Range)this.last().getToCheck()).setEnd(endExclusive);
        return this;
    }

    @Override
    public LongRangeCheckMate longValue(Comparable<Long> value) {
        Range<Long> range = new Range<Long>();
        range.setValue(value);
        this.checks.add(new Check(range, NumberCheckers.longOutOfRange));
        return this;
    }

    @Override
    public LongRangeCheckMate between(Long start) {
        ((Range)this.last().getToCheck()).setStart(start);
        return this;
    }

    @Override
    public CheckMate and(Long endExclusive) {
        ((Range)this.last().getToCheck()).setEnd(endExclusive);
        return this;
    }

    @Override
    public DoubleRangeCheckMate doubleValue(Comparable<Double> value) {
        Range<Double> range = new Range<Double>();
        range.setValue(value);
        this.checks.add(new Check(range, NumberCheckers.doubleOutOfRange));
        return this;
    }

    @Override
    public DoubleRangeCheckMate between(Double start) {
        ((Range)this.last().getToCheck()).setStart(start);
        return this;
    }

    @Override
    public CheckMate and(Double endExclusive) {
        ((Range)this.last().getToCheck()).setEnd(endExclusive);
        return this;
    }

    public CheckMate inclusive() {
        Object object = this.last().getToCheck();
        if (!(object instanceof Range)) {
            log.error("Object {} is not a Range", object);
            return this;
        }
        ((Range)object).setInclusive(true);
        return this;
    }

    private RuntimeException create(Class<? extends RuntimeException> throwableClass, String message) {
        try {
            if (throwableClass == null) {
                return this.defaultException.getConstructor(String.class).newInstance(message);
            }
            return throwableClass.getConstructor(String.class).newInstance(message);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Error instantiating exception", (Throwable)e);
            return null;
        }
    }

    private Check<?> last() {
        return this.checks.get(this.checks.size() - 1);
    }

    static enum Option {
        THROW_NPE,
        NONE;

    }
}

