/*
 * Decompiled with CFR 0.152.
 */
package xyz.mattyb.checkmate.checker;

import xyz.mattyb.checkmate.Index;
import xyz.mattyb.checkmate.checker.Checker;
import xyz.mattyb.checkmate.checker.context.CheckerContext;

public class IndexCheckers {
    public static Checker<Index> indexChecker = new Checker<Index>(){

        @Override
        public boolean test(Index index, CheckerContext ctx) {
            if (index == null || index.isNull()) {
                ctx.setNpe(true);
                return true;
            }
            return index.getIndex() < 0 || index.getIndex() >= index.getSize();
        }

        @Override
        public String getExceptionMessage(Index index, CheckerContext ctx) {
            if (ctx.isNpe()) {
                return "The index is null, that shouldn't happen";
            }
            return String.format("The validated %s index is invalid: %d", index.getType(), index.getIndex());
        }
    };

    private IndexCheckers() {
    }
}

