/*
 * Decompiled with CFR 0.152.
 */
package xyz.mattyb.checkmate.checker;

import java.util.Iterator;
import java.util.Objects;
import xyz.mattyb.checkmate.checker.Checker;
import xyz.mattyb.checkmate.checker.context.CheckerContext;

public class NullCheckers {
    public static Checker<Object> notNull = new Checker<Object>(){

        @Override
        public boolean test(Object object, CheckerContext ctx) {
            if (Objects.isNull(object)) {
                ctx.setNpe(true);
                return true;
            }
            return false;
        }

        @Override
        public String getExceptionMessage(Object object, CheckerContext ctx) {
            return "The validated object is null";
        }
    };
    public static Checker<Object[]> noNullElementsArray = new Checker<Object[]>(){

        @Override
        public boolean test(Object[] array, CheckerContext ctx) {
            if (array == null) {
                ctx.setNpe(true);
                return true;
            }
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != null) continue;
                return true;
            }
            return array.length == 0;
        }

        @Override
        public String getExceptionMessage(Object[] array, CheckerContext ctx) {
            if (array == null) {
                return "Array is null";
            }
            if (array.length == 0) {
                return "Array is empty";
            }
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != null) continue;
                return String.format("The validated array contains null element at index: %d", i);
            }
            return "The validated array contains no null elements, throwing an exception is a mistake";
        }
    };
    public static Checker<Iterable<?>> noNullElementsIterable = new Checker<Iterable<?>>(){

        @Override
        public boolean test(Iterable<?> iterable, CheckerContext ctx) {
            if (iterable == null) {
                return true;
            }
            Iterator<?> it = iterable.iterator();
            while (it.hasNext()) {
                if (it.next() != null) continue;
                return true;
            }
            return false;
        }

        @Override
        public String getExceptionMessage(Iterable<?> iterable, CheckerContext ctx) {
            if (iterable == null) {
                return "The validated collection is null";
            }
            int i = 0;
            Iterator<?> it = iterable.iterator();
            while (it.hasNext()) {
                if (it.next() == null) {
                    return String.format("The validated collection contains a null element at index: %d", i);
                }
                ++i;
            }
            return "The validated collection has no null elements, throwing an exception is a mistake";
        }
    };

    private NullCheckers() {
    }
}

