/*
 * Decompiled with CFR 0.152.
 */
package xyz.mattyb.checkmate.checker;

import xyz.mattyb.checkmate.Range;
import xyz.mattyb.checkmate.checker.Checker;
import xyz.mattyb.checkmate.checker.context.CheckerContext;

public class NumberCheckers {
    public static Checker<Range<Integer>> intOutOfRange = new Checker<Range<Integer>>(){

        @Override
        public boolean test(Range<Integer> range, CheckerContext ctx) {
            if (range == null) {
                ctx.setNpe(true);
                return true;
            }
            Comparable<Integer> val = range.getValue();
            if (val == null) {
                ctx.setNpe(true);
                return true;
            }
            Integer end = range.isInclusive() ? 0 : -1;
            return val.compareTo(range.getStart()) < 0 || val.compareTo(range.getEnd()) > end;
        }

        @Override
        public String getExceptionMessage(Range<Integer> range, CheckerContext ctx) {
            return NumberCheckers.buildMessage(range);
        }
    };
    public static Checker<Range<Long>> longOutOfRange = new Checker<Range<Long>>(){

        @Override
        public boolean test(Range<Long> range, CheckerContext ctx) {
            if (range == null) {
                ctx.setNpe(true);
                return true;
            }
            Comparable<Long> val = range.getValue();
            if (val == null) {
                ctx.setNpe(true);
                return true;
            }
            if (range.getStart() == null || range.getEnd() == null) {
                ctx.setNpe(true);
                return true;
            }
            Integer end = range.isInclusive() ? 0 : -1;
            return val.compareTo(range.getStart()) < 0 || val.compareTo(range.getEnd()) > end;
        }

        @Override
        public String getExceptionMessage(Range<Long> range, CheckerContext ctx) {
            return NumberCheckers.buildMessage(range);
        }
    };
    public static Checker<Range<Double>> doubleOutOfRange = new Checker<Range<Double>>(){

        @Override
        public boolean test(Range<Double> range, CheckerContext ctx) {
            if (range == null) {
                ctx.setNpe(true);
                return true;
            }
            Comparable<Double> val = range.getValue();
            if (val == null) {
                ctx.setNpe(true);
                return true;
            }
            if (range.getStart() == null || range.getEnd() == null) {
                ctx.setNpe(true);
                return true;
            }
            Integer end = range.isInclusive() ? 0 : -1;
            return val.compareTo(range.getStart()) < 0 || val.compareTo(range.getEnd()) > end;
        }

        @Override
        public String getExceptionMessage(Range<Double> range, CheckerContext ctx) {
            return NumberCheckers.buildMessage(range);
        }
    };

    private NumberCheckers() {
    }

    private static String buildMessage(Range range) {
        if (range == null) {
            return "Not in range";
        }
        String inclusive = "exclusive";
        if (range.isInclusive()) {
            inclusive = "inclusive";
        }
        return String.format("%s is not between %s and %s, %s", range.getValue(), range.getStart(), range.getEnd(), inclusive);
    }
}

