/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.csv;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import xyz.noark.core.annotation.tpl.TplAttr;
import xyz.noark.core.annotation.tpl.TplAttrSuffix;
import xyz.noark.core.annotation.tpl.TplFile;
import xyz.noark.core.converter.ConvertManager;
import xyz.noark.core.converter.Converter;
import xyz.noark.core.exception.ConvertException;
import xyz.noark.core.exception.TplAttrRequiredException;
import xyz.noark.core.exception.TplConfigurationException;
import xyz.noark.core.exception.UnrealizedException;
import xyz.noark.core.lang.ResourceLoader;
import xyz.noark.core.util.CharsetUtils;
import xyz.noark.core.util.ClassUtils;
import xyz.noark.core.util.FieldUtils;
import xyz.noark.core.util.MethodUtils;
import xyz.noark.core.util.StringUtils;
import xyz.noark.csv.CsvReader;
import xyz.noark.log.LogHelper;

public class Csv
extends ResourceLoader {
    private final ConvertManager convertManager = ConvertManager.getInstance();
    private final char separator;

    public Csv() {
        this(',');
    }

    public Csv(char separator) {
        this.separator = separator;
    }

    public <T> List<T> loadAll(String templatePath, Class<T> klass) {
        return this.loadAll(templatePath, "", klass);
    }

    public <T> List<T> loadAll(String templatePath, String zone, Class<T> klass) {
        return this.loadAll(templatePath, zone, 0, klass);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> List<T> loadAll(String templatePath, String zone, int step, Class<T> klass) {
        TplFile file = klass.getAnnotation(TplFile.class);
        if (file == null) {
            throw new TplConfigurationException("\u8fd9\u4e0d\u662fCSV\u683c\u5f0f\u7684\u914d\u7f6e\u6587\u4ef6\u7c7b:" + klass.getName());
        }
        if (MethodUtils.existSetMethod(klass)) {
            LogHelper.logger.warn("\u6a21\u677f\u7c7b\u6b63\u5e38\u4e3a\u53ea\u8bfb\u6a21\u5f0f\uff0c\u4e0d\u5e94\u8be5\u5b58\u5728Set\u65b9\u6cd5\u5662\uff0cclass={}", new Object[]{klass.getName()});
        }
        try (CsvReader reader = new CsvReader(this.separator, this.newBufferedReader(templatePath, zone, step, file.value(), CharsetUtils.CHARSET_UTF_8));){
            Map<String, Integer> titles = reader.getHeaders();
            ArrayList result = new ArrayList();
            reader.getDatas().forEach(v -> result.add(this.analysisLine(klass, file.value(), titles, (String[])v)));
            ArrayList arrayList = result;
            return arrayList;
        }
        catch (IOException e) {
            throw new TplConfigurationException("CSV\u683c\u5f0f\u7684\u914d\u7f6e\u6587\u4ef6\u7c7b:" + klass.getName(), (Exception)e);
        }
    }

    private <T> T analysisLine(Class<T> klass, String tplFileName, Map<String, Integer> titles, String[] values) {
        Object result = ClassUtils.newInstance(klass);
        for (Field field : FieldUtils.getAllField(klass)) {
            TplAttr attr;
            TplAttr[] array = (TplAttr[])field.getAnnotationsByType(TplAttr.class);
            if (array.length == 0) continue;
            TplAttrSuffix suffix = field.getAnnotation(TplAttrSuffix.class);
            if (array.length == 1 && suffix == null) {
                attr = array[0];
                int index = this.lookupIndex(klass, field, titles, values, attr, attr.name());
                if (index == -1) continue;
                String value = values[index];
                Converter<?> converter = this.getConverter(field);
                try {
                    FieldUtils.writeField((Object)result, (Field)field, (Object)converter.convert(field, value));
                    continue;
                }
                catch (Exception e) {
                    throw new ConvertException(tplFileName + " >> " + field.getName() + " >> " + value + "-->" + converter.buildErrorMsg(), e);
                }
            }
            if (array.length == 1) {
                if (suffix.step() <= 0) {
                    throw new ConvertException(klass.getName() + " >> " + field.getName() + " >> TplAttrSuffix#step=" + suffix.step() + "-->\u4e0d\u53ef\u4ee5\u5c0f\u4e8e\u7b49\u4e8e0.");
                }
                attr = array[0];
                LinkedHashMap<String, String> data = new LinkedHashMap<String, String>((suffix.end() - suffix.start()) / suffix.step() + 1);
                for (int i = suffix.start(); i <= suffix.end(); i += suffix.step()) {
                    String attrName = attr.name() + i;
                    int index = this.lookupIndex(klass, field, titles, values, attr, attrName);
                    if (index == -1) continue;
                    data.put(attrName, values[index]);
                }
                Converter<?> converter = this.getConverter(field);
                try {
                    FieldUtils.writeField((Object)result, (Field)field, (Object)converter.convert(field, data));
                    continue;
                }
                catch (Exception e) {
                    throw new ConvertException(tplFileName + " >> " + field.getName() + " >> " + data + "-->" + converter.buildErrorMsg(), e);
                }
            }
            LinkedHashMap<String, String> data = new LinkedHashMap<String, String>(array.length + 1);
            for (TplAttr attr2 : array) {
                int index = this.lookupIndex(klass, field, titles, values, attr2, attr2.name());
                if (index == -1) continue;
                data.put(attr2.name(), values[index]);
            }
            Converter<?> converter = this.getConverter(field);
            try {
                FieldUtils.writeField((Object)result, (Field)field, (Object)converter.convert(field, data));
            }
            catch (Exception e) {
                throw new ConvertException(tplFileName + " >> " + field.getName() + " >> " + data + "-->" + converter.buildErrorMsg(), e);
            }
        }
        return (T)result;
    }

    private int lookupIndex(Class<?> klass, Field field, Map<String, Integer> titles, String[] values, TplAttr attr, String attrName) {
        Integer index = titles.get(attrName);
        if (index == null) {
            if (attr.required()) {
                throw new TplAttrRequiredException(klass, field, attr);
            }
            return -1;
        }
        if (index > values.length - 1) {
            return -1;
        }
        String value = values[index];
        if (StringUtils.isEmpty((String)value)) {
            return -1;
        }
        return index;
    }

    private Converter<?> getConverter(Field field) {
        Converter result = this.convertManager.getConverter(field.getType());
        if (result == null) {
            throw new UnrealizedException("CSV\u914d\u7f6e\u89e3\u6790\u65f6\uff0c\u53d1\u73b0\u672a\u5b9e\u73b0\u7684\u7c7b\u578b. field=(" + field.getType().getName() + ")" + field.getName());
        }
        return result;
    }
}

