/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy.impl;

import com.google.common.net.HostAndPort;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.channel.udt.nio.NioUdtProvider;
import io.netty.handler.codec.haproxy.HAProxyMessage;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestEncoder;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.socksx.v4.DefaultSocks4CommandRequest;
import io.netty.handler.codec.socksx.v4.Socks4ClientDecoder;
import io.netty.handler.codec.socksx.v4.Socks4ClientEncoder;
import io.netty.handler.codec.socksx.v4.Socks4CommandResponse;
import io.netty.handler.codec.socksx.v4.Socks4CommandStatus;
import io.netty.handler.codec.socksx.v4.Socks4CommandType;
import io.netty.handler.codec.socksx.v5.DefaultSocks5CommandRequest;
import io.netty.handler.codec.socksx.v5.DefaultSocks5InitialRequest;
import io.netty.handler.codec.socksx.v5.DefaultSocks5PasswordAuthRequest;
import io.netty.handler.codec.socksx.v5.Socks5AddressType;
import io.netty.handler.codec.socksx.v5.Socks5AuthMethod;
import io.netty.handler.codec.socksx.v5.Socks5ClientEncoder;
import io.netty.handler.codec.socksx.v5.Socks5CommandResponse;
import io.netty.handler.codec.socksx.v5.Socks5CommandResponseDecoder;
import io.netty.handler.codec.socksx.v5.Socks5CommandStatus;
import io.netty.handler.codec.socksx.v5.Socks5CommandType;
import io.netty.handler.codec.socksx.v5.Socks5InitialResponse;
import io.netty.handler.codec.socksx.v5.Socks5InitialResponseDecoder;
import io.netty.handler.codec.socksx.v5.Socks5PasswordAuthResponse;
import io.netty.handler.codec.socksx.v5.Socks5PasswordAuthResponseDecoder;
import io.netty.handler.codec.socksx.v5.Socks5PasswordAuthStatus;
import io.netty.handler.proxy.ProxyConnectException;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.handler.traffic.GlobalTrafficShapingHandler;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.DefaultAddressResolverGroup;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.RejectedExecutionException;
import javax.net.ssl.SSLProtocolException;
import org.littleshoot.proxy.ActivityTracker;
import org.littleshoot.proxy.ChainedProxy;
import org.littleshoot.proxy.ChainedProxyAdapter;
import org.littleshoot.proxy.ChainedProxyManager;
import org.littleshoot.proxy.ChainedProxyType;
import org.littleshoot.proxy.FullFlowContext;
import org.littleshoot.proxy.HttpFilters;
import org.littleshoot.proxy.MitmManager;
import org.littleshoot.proxy.TransportProtocol;
import org.littleshoot.proxy.UnknownTransportProtocolException;
import org.littleshoot.proxy.extras.HAProxyMessageEncoder;
import org.littleshoot.proxy.impl.ClientToProxyConnection;
import org.littleshoot.proxy.impl.ConnectionFlow;
import org.littleshoot.proxy.impl.ConnectionFlowStep;
import org.littleshoot.proxy.impl.ConnectionState;
import org.littleshoot.proxy.impl.DefaultHttpProxyServer;
import org.littleshoot.proxy.impl.ProxyConnection;
import org.littleshoot.proxy.impl.ProxyUtils;

@ChannelHandler.Sharable
public class ProxyToServerConnection
extends ProxyConnection<HttpResponse> {
    private static final String SOCKS_ENCODER_NAME = "socksEncoder";
    private static final String SOCKS_DECODER_NAME = "socksDecoder";
    private final ClientToProxyConnection clientConnection;
    private final ProxyToServerConnection serverConnection = this;
    private volatile TransportProtocol transportProtocol;
    private volatile ChainedProxyType chainedProxyType;
    private volatile InetSocketAddress remoteAddress;
    private volatile InetSocketAddress localAddress;
    private volatile AddressResolverGroup<?> remoteAddressResolver;
    private volatile String username;
    private volatile String password;
    private final String serverHostAndPort;
    private volatile ChainedProxy chainedProxy;
    private final Queue<ChainedProxy> availableChainedProxies;
    private volatile HttpFilters currentFilters;
    private volatile ConnectionFlow connectionFlow;
    private volatile boolean disableSni = false;
    private final Object connectLock = new Object();
    private volatile HttpRequest initialRequest;
    private volatile HttpRequest currentHttpRequest;
    private volatile HttpResponse currentHttpResponse;
    private volatile GlobalTrafficShapingHandler trafficHandler;
    private static final int MINIMUM_RECV_BUFFER_SIZE_BYTES = 64;
    private ConnectionFlowStep ConnectChannel = new ConnectionFlowStep(this, ConnectionState.CONNECTING){

        @Override
        boolean shouldExecuteOnEventLoop() {
            return false;
        }

        protected Future<?> execute() {
            Bootstrap cb = ((Bootstrap)new Bootstrap().group(ProxyToServerConnection.this.proxyServer.getProxyToServerWorkerFor(ProxyToServerConnection.this.transportProtocol))).resolver(ProxyToServerConnection.this.remoteAddressResolver);
            switch (ProxyToServerConnection.this.transportProtocol) {
                case TCP: {
                    ProxyToServerConnection.this.LOG.debug("Connecting to server with TCP", new Object[0]);
                    cb.channelFactory(NioSocketChannel::new);
                    break;
                }
                case UDT: {
                    ProxyToServerConnection.this.LOG.debug("Connecting to server with UDT", new Object[0]);
                    ((Bootstrap)cb.channelFactory(NioUdtProvider.BYTE_CONNECTOR)).option(ChannelOption.SO_REUSEADDR, (Object)true);
                    break;
                }
                default: {
                    throw new UnknownTransportProtocolException(ProxyToServerConnection.this.transportProtocol);
                }
            }
            cb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ProxyToServerConnection.this.initChannelPipeline(ch.pipeline(), ProxyToServerConnection.this.initialRequest);
                }
            });
            cb.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)ProxyToServerConnection.this.proxyServer.getConnectTimeout());
            if (ProxyToServerConnection.this.localAddress != null) {
                return cb.connect((SocketAddress)ProxyToServerConnection.this.remoteAddress, (SocketAddress)ProxyToServerConnection.this.localAddress);
            }
            return cb.connect((SocketAddress)ProxyToServerConnection.this.remoteAddress);
        }
    };
    private ConnectionFlowStep HTTPCONNECTWithChainedProxy = new ConnectionFlowStep(this, ConnectionState.AWAITING_CONNECT_OK){

        protected Future<?> execute() {
            boolean isMitmEnabled;
            ProxyToServerConnection.this.LOG.debug("Handling CONNECT request through Chained Proxy", new Object[0]);
            ProxyToServerConnection.this.chainedProxy.filterRequest((HttpObject)ProxyToServerConnection.this.initialRequest);
            MitmManager mitmManager = ProxyToServerConnection.this.proxyServer.getMitmManager();
            boolean bl = isMitmEnabled = mitmManager != null;
            if (isMitmEnabled) {
                ChannelFuture future = ProxyToServerConnection.this.writeToChannel(ProxyToServerConnection.this.initialRequest);
                future.addListener((GenericFutureListener)((ChannelFutureListener)arg0 -> {
                    if (arg0.isSuccess()) {
                        ProxyToServerConnection.this.writeToChannel(LastHttpContent.EMPTY_LAST_CONTENT);
                    }
                }));
                return future;
            }
            return ProxyToServerConnection.this.writeToChannel(ProxyToServerConnection.this.initialRequest);
        }

        @Override
        void onSuccess(ConnectionFlow flow) {
        }

        @Override
        void read(ConnectionFlow flow, Object msg) {
            HttpResponse httpResponse;
            int statusCode;
            boolean connectOk = false;
            if (msg instanceof HttpResponse && (statusCode = (httpResponse = (HttpResponse)msg).status().code()) >= 200 && statusCode <= 299) {
                connectOk = true;
            }
            if (connectOk) {
                flow.advance();
            } else {
                flow.fail();
            }
        }
    };
    private ConnectionFlowStep SOCKS4CONNECTWithChainedProxy = new ConnectionFlowStep(this, ConnectionState.AWAITING_CONNECT_OK){

        protected Future<?> execute() {
            InetSocketAddress destinationAddress;
            try {
                destinationAddress = ProxyToServerConnection.addressFor(ProxyToServerConnection.this.serverHostAndPort, ProxyToServerConnection.this.proxyServer);
            }
            catch (UnknownHostException e) {
                return ProxyToServerConnection.this.channel.newFailedFuture((Throwable)e);
            }
            DefaultSocks4CommandRequest connectRequest = new DefaultSocks4CommandRequest(Socks4CommandType.CONNECT, destinationAddress.getHostString(), destinationAddress.getPort());
            ProxyToServerConnection.this.addFirstOrReplaceHandler(ProxyToServerConnection.SOCKS_ENCODER_NAME, (ChannelHandler)Socks4ClientEncoder.INSTANCE);
            ProxyToServerConnection.this.addFirstOrReplaceHandler(ProxyToServerConnection.SOCKS_DECODER_NAME, (ChannelHandler)new Socks4ClientDecoder());
            return ProxyToServerConnection.this.writeToChannel(connectRequest);
        }

        @Override
        void read(ConnectionFlow flow, Object msg) {
            ProxyToServerConnection.this.removeHandlerIfPresent(ProxyToServerConnection.SOCKS_ENCODER_NAME);
            ProxyToServerConnection.this.removeHandlerIfPresent(ProxyToServerConnection.SOCKS_DECODER_NAME);
            if (msg instanceof Socks4CommandResponse && ((Socks4CommandResponse)msg).status() == Socks4CommandStatus.SUCCESS) {
                flow.advance();
                return;
            }
            flow.fail();
        }

        @Override
        void onSuccess(ConnectionFlow flow) {
        }
    };
    private ConnectionFlowStep SOCKS5InitialRequest = new ConnectionFlowStep(this, ConnectionState.AWAITING_CONNECT_OK){

        protected Future<?> execute() {
            ArrayList<Socks5AuthMethod> authMethods = new ArrayList<Socks5AuthMethod>(2);
            authMethods.add(Socks5AuthMethod.NO_AUTH);
            if (ProxyToServerConnection.this.username != null || ProxyToServerConnection.this.password != null) {
                authMethods.add(Socks5AuthMethod.PASSWORD);
            }
            DefaultSocks5InitialRequest initialRequest = new DefaultSocks5InitialRequest(authMethods);
            ProxyToServerConnection.this.addFirstOrReplaceHandler(ProxyToServerConnection.SOCKS_ENCODER_NAME, (ChannelHandler)Socks5ClientEncoder.DEFAULT);
            ProxyToServerConnection.this.addFirstOrReplaceHandler(ProxyToServerConnection.SOCKS_DECODER_NAME, (ChannelHandler)new Socks5InitialResponseDecoder());
            return ProxyToServerConnection.this.writeToChannel(initialRequest);
        }

        @Override
        void read(ConnectionFlow flow, Object msg) {
            if (msg instanceof Socks5InitialResponse) {
                boolean authSuccess;
                Socks5AuthMethod selectedAuthMethod = ((Socks5InitialResponse)msg).authMethod();
                if (selectedAuthMethod == Socks5AuthMethod.NO_AUTH) {
                    flow.first(ProxyToServerConnection.this.SOCKS5CONNECTRequestWithChainedProxy);
                    authSuccess = true;
                } else if (selectedAuthMethod == Socks5AuthMethod.PASSWORD) {
                    flow.first(ProxyToServerConnection.this.SOCKS5SendPasswordCredentials);
                    authSuccess = true;
                } else {
                    authSuccess = false;
                }
                if (authSuccess) {
                    flow.advance();
                    return;
                }
            }
            flow.fail();
        }

        @Override
        void onSuccess(ConnectionFlow flow) {
        }
    };
    private ConnectionFlowStep SOCKS5SendPasswordCredentials = new ConnectionFlowStep(this, ConnectionState.AWAITING_CONNECT_OK){

        protected Future<?> execute() {
            DefaultSocks5PasswordAuthRequest authRequest = new DefaultSocks5PasswordAuthRequest(ProxyToServerConnection.this.username != null ? ProxyToServerConnection.this.username : "", ProxyToServerConnection.this.password != null ? ProxyToServerConnection.this.password : "");
            ProxyToServerConnection.this.addFirstOrReplaceHandler(ProxyToServerConnection.SOCKS_DECODER_NAME, (ChannelHandler)new Socks5PasswordAuthResponseDecoder());
            return ProxyToServerConnection.this.writeToChannel(authRequest);
        }

        @Override
        void read(ConnectionFlow flow, Object msg) {
            if (msg instanceof Socks5PasswordAuthResponse && ((Socks5PasswordAuthResponse)msg).status() == Socks5PasswordAuthStatus.SUCCESS) {
                flow.first(ProxyToServerConnection.this.SOCKS5CONNECTRequestWithChainedProxy);
                flow.advance();
                return;
            }
            flow.fail();
        }

        @Override
        void onSuccess(ConnectionFlow flow) {
        }
    };
    private ConnectionFlowStep SOCKS5CONNECTRequestWithChainedProxy = new ConnectionFlowStep(this, ConnectionState.AWAITING_CONNECT_OK){

        protected Future<?> execute() {
            InetSocketAddress destinationAddress = ProxyToServerConnection.unresolvedAddressFor(ProxyToServerConnection.this.serverHostAndPort);
            DefaultSocks5CommandRequest connectRequest = new DefaultSocks5CommandRequest(Socks5CommandType.CONNECT, Socks5AddressType.DOMAIN, destinationAddress.getHostString(), destinationAddress.getPort());
            ProxyToServerConnection.this.addFirstOrReplaceHandler(ProxyToServerConnection.SOCKS_DECODER_NAME, (ChannelHandler)new Socks5CommandResponseDecoder());
            return ProxyToServerConnection.this.writeToChannel(connectRequest);
        }

        @Override
        void read(ConnectionFlow flow, Object msg) {
            ProxyToServerConnection.this.removeHandlerIfPresent(ProxyToServerConnection.SOCKS_ENCODER_NAME);
            ProxyToServerConnection.this.removeHandlerIfPresent(ProxyToServerConnection.SOCKS_DECODER_NAME);
            if (msg instanceof Socks5CommandResponse && ((Socks5CommandResponse)msg).status() == Socks5CommandStatus.SUCCESS) {
                flow.advance();
                return;
            }
            flow.fail();
        }

        @Override
        void onSuccess(ConnectionFlow flow) {
        }
    };
    private ConnectionFlowStep MitmEncryptClientChannel = new ConnectionFlowStep(this, ConnectionState.HANDSHAKING){

        @Override
        boolean shouldExecuteOnEventLoop() {
            return false;
        }

        @Override
        boolean shouldSuppressInitialRequest() {
            return true;
        }

        protected Future<?> execute() {
            return ProxyToServerConnection.this.clientConnection.encrypt(ProxyToServerConnection.this.proxyServer.getMitmManager().clientSslEngineFor(ProxyToServerConnection.this.initialRequest, ProxyToServerConnection.this.sslEngine.getSession()), false).addListener(future -> {
                if (future.isSuccess()) {
                    ProxyToServerConnection.this.clientConnection.setMitming(true);
                }
            });
        }
    };
    private final ProxyConnection.BytesReadMonitor bytesReadMonitor = new ProxyConnection.BytesReadMonitor(){

        @Override
        protected void bytesRead(int numberOfBytes) {
            FullFlowContext flowContext = new FullFlowContext(ProxyToServerConnection.this.clientConnection, ProxyToServerConnection.this);
            for (ActivityTracker tracker : ProxyToServerConnection.this.proxyServer.getActivityTrackers()) {
                tracker.bytesReceivedFromServer(flowContext, numberOfBytes);
            }
        }
    };
    private ProxyConnection.ResponseReadMonitor responseReadMonitor = new ProxyConnection.ResponseReadMonitor(){

        @Override
        protected void responseRead(HttpResponse httpResponse) {
            FullFlowContext flowContext = new FullFlowContext(ProxyToServerConnection.this.clientConnection, ProxyToServerConnection.this);
            for (ActivityTracker tracker : ProxyToServerConnection.this.proxyServer.getActivityTrackers()) {
                tracker.responseReceivedFromServer(flowContext, httpResponse);
            }
        }
    };
    private ProxyConnection.BytesWrittenMonitor bytesWrittenMonitor = new ProxyConnection.BytesWrittenMonitor(){

        @Override
        protected void bytesWritten(int numberOfBytes) {
            FullFlowContext flowContext = new FullFlowContext(ProxyToServerConnection.this.clientConnection, ProxyToServerConnection.this);
            for (ActivityTracker tracker : ProxyToServerConnection.this.proxyServer.getActivityTrackers()) {
                tracker.bytesSentToServer(flowContext, numberOfBytes);
            }
        }
    };
    private ProxyConnection.RequestWrittenMonitor requestWrittenMonitor = new ProxyConnection.RequestWrittenMonitor(){

        @Override
        protected void requestWriting(HttpRequest httpRequest) {
            FullFlowContext flowContext = new FullFlowContext(ProxyToServerConnection.this.clientConnection, ProxyToServerConnection.this);
            try {
                for (ActivityTracker tracker : ProxyToServerConnection.this.proxyServer.getActivityTrackers()) {
                    tracker.requestSentToServer(flowContext, httpRequest);
                }
            }
            catch (Throwable t) {
                ProxyToServerConnection.this.LOG.warn("Error while invoking ActivityTracker on request", t);
            }
            ProxyToServerConnection.this.currentFilters.proxyToServerRequestSending();
        }

        @Override
        protected void requestWritten(HttpRequest httpRequest) {
        }

        @Override
        protected void contentWritten(HttpContent httpContent) {
            if (httpContent instanceof LastHttpContent) {
                ProxyToServerConnection.this.currentFilters.proxyToServerRequestSent();
            }
        }
    };

    static ProxyToServerConnection create(DefaultHttpProxyServer proxyServer, ClientToProxyConnection clientConnection, String serverHostAndPort, HttpFilters initialFilters, HttpRequest initialHttpRequest, GlobalTrafficShapingHandler globalTrafficShapingHandler) throws UnknownHostException {
        ConcurrentLinkedQueue<ChainedProxy> chainedProxies = new ConcurrentLinkedQueue<ChainedProxy>();
        ChainedProxyManager chainedProxyManager = proxyServer.getChainProxyManager();
        if (chainedProxyManager != null) {
            chainedProxyManager.lookupChainedProxies(initialHttpRequest, chainedProxies, clientConnection.getClientDetails());
            if (chainedProxies.size() == 0) {
                return null;
            }
        }
        return new ProxyToServerConnection(proxyServer, clientConnection, serverHostAndPort, (ChainedProxy)chainedProxies.poll(), chainedProxies, initialFilters, globalTrafficShapingHandler);
    }

    private ProxyToServerConnection(DefaultHttpProxyServer proxyServer, ClientToProxyConnection clientConnection, String serverHostAndPort, ChainedProxy chainedProxy, Queue<ChainedProxy> availableChainedProxies, HttpFilters initialFilters, GlobalTrafficShapingHandler globalTrafficShapingHandler) throws UnknownHostException {
        super(ConnectionState.DISCONNECTED, proxyServer, true);
        this.clientConnection = clientConnection;
        this.serverHostAndPort = serverHostAndPort;
        this.chainedProxy = chainedProxy;
        this.availableChainedProxies = availableChainedProxies;
        this.trafficHandler = globalTrafficShapingHandler;
        this.currentFilters = initialFilters;
        this.currentFilters.proxyToServerConnectionQueued();
        this.setupConnectionParameters();
    }

    @Override
    protected void read(Object msg) {
        if (this.isConnecting()) {
            this.LOG.debug("In the middle of connecting, forwarding message to connection flow: {}", msg);
            this.connectionFlow.read(msg);
        } else {
            super.read(msg);
        }
    }

    @Override
    protected void readHAProxyMessage(HAProxyMessage msg) {
    }

    @Override
    protected ConnectionState readHTTPInitial(HttpResponse httpResponse) {
        this.LOG.debug("Received raw response: {}", httpResponse);
        if (httpResponse.decoderResult().isFailure()) {
            this.LOG.debug("Could not parse response from server. Decoder result: {}", httpResponse.decoderResult().toString());
            FullHttpResponse substituteResponse = ProxyUtils.createFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_GATEWAY, "Unable to parse response from server");
            HttpUtil.setKeepAlive((HttpMessage)substituteResponse, (boolean)false);
            httpResponse = substituteResponse;
        }
        this.currentFilters.serverToProxyResponseReceiving();
        this.rememberCurrentResponse(httpResponse);
        this.respondWith((HttpObject)httpResponse);
        if (ProxyUtils.isChunked((HttpObject)httpResponse)) {
            return ConnectionState.AWAITING_CHUNK;
        }
        this.currentFilters.serverToProxyResponseReceived();
        return ConnectionState.AWAITING_INITIAL;
    }

    @Override
    protected void readHTTPChunk(HttpContent chunk) {
        this.respondWith((HttpObject)chunk);
    }

    @Override
    protected void readRaw(ByteBuf buf) {
        this.clientConnection.write(buf);
    }

    void write(Object msg, HttpFilters filters) {
        this.currentFilters = filters;
        this.write(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void write(Object msg) {
        this.LOG.debug("Requested write of {}", msg);
        if (msg instanceof ReferenceCounted) {
            this.LOG.debug("Retaining reference counted message", new Object[0]);
            ((ReferenceCounted)msg).retain();
        }
        if (this.is(ConnectionState.DISCONNECTED) && msg instanceof HttpRequest) {
            this.LOG.debug("Currently disconnected, connect and then write the message", new Object[0]);
            this.connectAndWrite((HttpRequest)msg);
        } else {
            if (this.isConnecting()) {
                Object object = this.connectLock;
                synchronized (object) {
                    if (this.isConnecting()) {
                        this.LOG.debug("Attempted to write while still in the process of connecting, waiting for connection.", new Object[0]);
                        this.clientConnection.stopReading();
                        try {
                            this.connectLock.wait(30000L);
                        }
                        catch (InterruptedException ie) {
                            this.LOG.warn("Interrupted while waiting for connect monitor", new Object[0]);
                        }
                    }
                }
            }
            if (this.isConnecting() || this.getCurrentState().isDisconnectingOrDisconnected()) {
                this.LOG.debug("Connection failed or timed out while waiting to write message to server. Message will be discarded: {}", msg);
                return;
            }
            this.LOG.debug("Using existing connection to: {}", this.remoteAddress);
            this.doWrite(msg);
        }
    }

    @Override
    protected void writeHttp(HttpObject httpObject) {
        if (this.chainedProxy != null) {
            this.chainedProxy.filterRequest(httpObject);
        }
        if (httpObject instanceof HttpRequest) {
            this.currentHttpRequest = (HttpRequest)httpObject;
        }
        super.writeHttp(httpObject);
    }

    @Override
    protected void become(ConnectionState newState) {
        if (this.getCurrentState() == ConnectionState.DISCONNECTED && newState == ConnectionState.CONNECTING) {
            this.currentFilters.proxyToServerConnectionStarted();
        } else if (this.getCurrentState() == ConnectionState.CONNECTING) {
            if (newState == ConnectionState.HANDSHAKING) {
                this.currentFilters.proxyToServerConnectionSSLHandshakeStarted();
            } else if (newState == ConnectionState.AWAITING_INITIAL) {
                this.currentFilters.proxyToServerConnectionSucceeded(this.ctx);
            } else if (newState == ConnectionState.DISCONNECTED) {
                this.currentFilters.proxyToServerConnectionFailed();
            }
        } else if (this.getCurrentState() == ConnectionState.HANDSHAKING) {
            if (newState == ConnectionState.AWAITING_INITIAL) {
                this.currentFilters.proxyToServerConnectionSucceeded(this.ctx);
            } else if (newState == ConnectionState.DISCONNECTED) {
                this.currentFilters.proxyToServerConnectionFailed();
            }
        } else if (this.getCurrentState() == ConnectionState.AWAITING_CHUNK && newState != ConnectionState.AWAITING_CHUNK) {
            this.currentFilters.serverToProxyResponseReceived();
        }
        super.become(newState);
    }

    @Override
    protected void becameSaturated() {
        super.becameSaturated();
        this.clientConnection.serverBecameSaturated(this);
    }

    @Override
    protected void becameWritable() {
        super.becameWritable();
        this.clientConnection.serverBecameWriteable(this);
    }

    @Override
    protected void timedOut() {
        super.timedOut();
        this.clientConnection.timedOut(this);
    }

    @Override
    protected void disconnected() {
        super.disconnected();
        if (this.chainedProxy != null) {
            try {
                this.chainedProxy.disconnected();
            }
            catch (Exception e) {
                this.LOG.error("Unable to record connectionFailed", e);
            }
        }
        this.clientConnection.serverDisconnected(this);
    }

    @Override
    protected void exceptionCaught(Throwable cause) {
        try {
            if (cause instanceof ProxyConnectException) {
                this.LOG.info("A ProxyConnectException occurred on ProxyToServerConnection: " + cause.getMessage(), new Object[0]);
                this.connectionFlow.fail(cause);
            } else if (cause instanceof IOException) {
                this.LOG.info("An IOException occurred on ProxyToServerConnection: " + cause.getMessage(), new Object[0]);
                this.LOG.debug("An IOException occurred on ProxyToServerConnection", cause);
            } else if (cause instanceof RejectedExecutionException) {
                this.LOG.info("An executor rejected a read or write operation on the ProxyToServerConnection (this is normal if the proxy is shutting down). Message: " + cause.getMessage(), new Object[0]);
                this.LOG.debug("A RejectedExecutionException occurred on ProxyToServerConnection", cause);
            } else {
                this.LOG.error("Caught an exception on ProxyToServerConnection", cause);
            }
        }
        finally {
            if (!this.is(ConnectionState.DISCONNECTED)) {
                this.LOG.info("Disconnecting open connection to server", new Object[0]);
                this.disconnect();
            }
        }
    }

    public TransportProtocol getTransportProtocol() {
        return this.transportProtocol;
    }

    public ChainedProxyType getChainedProxyType() {
        return this.chainedProxyType;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public String getServerHostAndPort() {
        return this.serverHostAndPort;
    }

    public boolean hasUpstreamChainedProxy() {
        return this.getChainedProxyAddress() != null;
    }

    public InetSocketAddress getChainedProxyAddress() {
        return this.chainedProxy == null ? null : this.chainedProxy.getChainedProxyAddress();
    }

    public ChainedProxy getChainedProxy() {
        return this.chainedProxy;
    }

    public HttpRequest getInitialRequest() {
        return this.initialRequest;
    }

    @Override
    protected HttpFilters getHttpFiltersFromProxyServer(HttpRequest httpRequest) {
        return this.currentFilters;
    }

    private void rememberCurrentResponse(HttpResponse response) {
        this.LOG.debug("Remembering the current response.", new Object[0]);
        this.currentHttpResponse = ProxyUtils.copyMutableResponseFields(response);
    }

    private void respondWith(HttpObject httpObject) {
        this.clientConnection.respond(this, this.currentFilters, this.currentHttpRequest, this.currentHttpResponse, httpObject);
    }

    private void connectAndWrite(HttpRequest initialRequest) {
        this.LOG.debug("Starting new connection to: {}", this.remoteAddress);
        this.initialRequest = initialRequest;
        this.initializeConnectionFlow();
        this.connectionFlow.start();
    }

    private void initializeConnectionFlow() {
        this.connectionFlow = new ConnectionFlow(this.clientConnection, this, this.connectLock).then(this.ConnectChannel);
        if (this.hasUpstreamChainedProxy()) {
            if (this.chainedProxy.requiresEncryption()) {
                this.connectionFlow.then(this.serverConnection.EncryptChannel(this.chainedProxy.newSslEngine()));
            }
            switch (this.chainedProxyType) {
                case SOCKS4: {
                    this.connectionFlow.then(this.SOCKS4CONNECTWithChainedProxy);
                    break;
                }
                case SOCKS5: {
                    this.connectionFlow.then(this.SOCKS5InitialRequest);
                    break;
                }
            }
        }
        if (ProxyUtils.isCONNECT((HttpObject)this.initialRequest)) {
            MitmManager mitmManager;
            boolean isMitmEnabled;
            if (this.hasUpstreamChainedProxy() && this.chainedProxyType == ChainedProxyType.HTTP) {
                this.connectionFlow.then(this.serverConnection.HTTPCONNECTWithChainedProxy);
            }
            boolean bl = isMitmEnabled = (mitmManager = this.proxyServer.getMitmManager()) != null;
            if (isMitmEnabled) {
                HostAndPort parsedHostAndPort = HostAndPort.fromString((String)this.serverHostAndPort);
                if (this.disableSni) {
                    this.connectionFlow.then(this.serverConnection.EncryptChannel(this.proxyServer.getMitmManager().serverSslEngine()));
                } else {
                    this.connectionFlow.then(this.serverConnection.EncryptChannel(this.proxyServer.getMitmManager().serverSslEngine(parsedHostAndPort.getHost(), parsedHostAndPort.getPort())));
                }
                this.connectionFlow.then(this.clientConnection.RespondCONNECTSuccessful).then(this.serverConnection.MitmEncryptClientChannel);
            } else {
                this.connectionFlow.then(this.serverConnection.StartTunneling).then(this.clientConnection.RespondCONNECTSuccessful).then(this.clientConnection.StartTunneling);
            }
        }
    }

    private void addFirstOrReplaceHandler(String name, ChannelHandler handler) {
        if (this.channel.pipeline().context(name) != null) {
            this.channel.pipeline().replace(name, name, handler);
        } else {
            this.channel.pipeline().addFirst(name, handler);
        }
    }

    private void removeHandlerIfPresent(String name) {
        if (this.channel.pipeline().context(name) != null) {
            this.channel.pipeline().remove(name);
        }
    }

    protected boolean connectionFailed(Throwable cause) throws UnknownHostException {
        if (!this.disableSni && cause instanceof SSLProtocolException && cause.getMessage() != null && cause.getMessage().contains("unrecognized_name")) {
            this.LOG.debug("Failed to connect to server due to an unrecognized_name SSL warning. Retrying connection without SNI.", new Object[0]);
            this.disableSni = true;
            this.resetConnectionForRetry();
            this.connectAndWrite(this.initialRequest);
            return true;
        }
        this.disableSni = false;
        if (this.chainedProxy != null) {
            this.LOG.info("Connection to upstream server via chained proxy failed", cause);
            this.chainedProxy.connectionFailed(cause);
        } else {
            this.LOG.info("Connection to upstream server failed", cause);
        }
        this.chainedProxy = this.availableChainedProxies.poll();
        if (this.chainedProxy != null) {
            this.LOG.info("Retrying connecting using the next available chained proxy", new Object[0]);
            this.resetConnectionForRetry();
            this.connectAndWrite(this.initialRequest);
            return true;
        }
        return false;
    }

    private void resetConnectionForRetry() throws UnknownHostException {
        this.ctx.pipeline().remove((ChannelHandler)this);
        this.ctx.close();
        this.ctx = null;
        this.setupConnectionParameters();
    }

    private void setupConnectionParameters() throws UnknownHostException {
        if (this.chainedProxy != null && this.chainedProxy != ChainedProxyAdapter.FALLBACK_TO_DIRECT_CONNECTION) {
            this.transportProtocol = this.chainedProxy.getTransportProtocol();
            this.chainedProxyType = this.chainedProxy.getChainedProxyType();
            this.localAddress = this.chainedProxy.getLocalAddress();
            this.remoteAddress = this.chainedProxy.getChainedProxyAddress();
            this.remoteAddressResolver = DefaultAddressResolverGroup.INSTANCE;
            this.username = this.chainedProxy.getUsername();
            this.password = this.chainedProxy.getPassword();
        } else {
            this.transportProtocol = TransportProtocol.TCP;
            this.chainedProxyType = ChainedProxyType.HTTP;
            this.username = null;
            this.password = null;
            this.remoteAddress = this.currentFilters.proxyToServerResolutionStarted(this.serverHostAndPort);
            String hostAndPort = null;
            try {
                if (this.remoteAddress == null) {
                    hostAndPort = this.serverHostAndPort;
                    this.remoteAddress = ProxyToServerConnection.addressFor(this.serverHostAndPort, this.proxyServer);
                } else if (this.remoteAddress.isUnresolved()) {
                    hostAndPort = HostAndPort.fromParts((String)this.remoteAddress.getHostName(), (int)this.remoteAddress.getPort()).toString();
                    this.remoteAddress = this.proxyServer.getServerResolver().resolve(this.remoteAddress.getHostName(), this.remoteAddress.getPort());
                }
            }
            catch (UnknownHostException e) {
                this.currentFilters.proxyToServerResolutionFailed(hostAndPort);
                throw e;
            }
            this.currentFilters.proxyToServerResolutionSucceeded(this.serverHostAndPort, this.remoteAddress);
            this.localAddress = this.proxyServer.getLocalAddress();
        }
    }

    private void initChannelPipeline(ChannelPipeline pipeline, HttpRequest httpRequest) {
        if (this.trafficHandler != null) {
            pipeline.addLast("global-traffic-shaping", (ChannelHandler)this.trafficHandler);
        }
        pipeline.addLast("bytesReadMonitor", (ChannelHandler)this.bytesReadMonitor);
        pipeline.addLast("bytesWrittenMonitor", (ChannelHandler)this.bytesWrittenMonitor);
        if (this.proxyServer.isSendProxyProtocol()) {
            pipeline.addLast("proxy-protocol-encoder", (ChannelHandler)new HAProxyMessageEncoder());
        }
        pipeline.addLast("encoder", (ChannelHandler)new HttpRequestEncoder());
        pipeline.addLast("decoder", (ChannelHandler)new HeadAwareHttpResponseDecoder(this.proxyServer.getMaxInitialLineLength(), this.proxyServer.getMaxHeaderSize(), this.proxyServer.getMaxChunkSize()));
        int numberOfBytesToBuffer = this.proxyServer.getFiltersSource().getMaximumResponseBufferSizeInBytes();
        if (numberOfBytesToBuffer > 0) {
            this.aggregateContentForFiltering(pipeline, numberOfBytesToBuffer);
        }
        pipeline.addLast("responseReadMonitor", (ChannelHandler)this.responseReadMonitor);
        pipeline.addLast("requestWrittenMonitor", (ChannelHandler)this.requestWrittenMonitor);
        pipeline.addLast("idle", (ChannelHandler)new IdleStateHandler(0, 0, this.proxyServer.getIdleConnectionTimeout()));
        pipeline.addLast("handler", (ChannelHandler)this);
    }

    void connectionSucceeded(boolean shouldForwardInitialRequest) {
        this.become(ConnectionState.AWAITING_INITIAL);
        if (this.chainedProxy != null) {
            try {
                this.chainedProxy.connectionSucceeded();
            }
            catch (Exception e) {
                this.LOG.error("Unable to record connectionSucceeded", e);
            }
        }
        this.clientConnection.serverConnectionSucceeded(this, shouldForwardInitialRequest);
        if (shouldForwardInitialRequest) {
            this.LOG.debug("Writing initial request: {}", this.initialRequest);
            this.write(this.initialRequest);
        } else {
            this.LOG.debug("Dropping initial request: {}", this.initialRequest);
        }
        if (this.initialRequest instanceof ReferenceCounted) {
            ((ReferenceCounted)this.initialRequest).release();
        }
    }

    public static InetSocketAddress addressFor(String hostAndPort, DefaultHttpProxyServer proxyServer) throws UnknownHostException {
        HostAndPort parsedHostAndPort;
        try {
            parsedHostAndPort = HostAndPort.fromString((String)hostAndPort);
        }
        catch (IllegalArgumentException e) {
            throw new UnknownHostException(hostAndPort);
        }
        String host = parsedHostAndPort.getHost();
        int port = parsedHostAndPort.getPortOrDefault(80);
        return proxyServer.getServerResolver().resolve(host, port);
    }

    private static InetSocketAddress unresolvedAddressFor(String hostAndPort) {
        HostAndPort parsedHostAndPort = HostAndPort.fromString((String)hostAndPort);
        String host = parsedHostAndPort.getHost();
        int port = parsedHostAndPort.getPortOrDefault(80);
        return InetSocketAddress.createUnresolved(host, port);
    }

    private class HeadAwareHttpResponseDecoder
    extends HttpResponseDecoder {
        public HeadAwareHttpResponseDecoder(int maxInitialLineLength, int maxHeaderSize, int maxChunkSize) {
            super(maxInitialLineLength, maxHeaderSize, maxChunkSize);
        }

        protected boolean isContentAlwaysEmpty(HttpMessage httpMessage) {
            if (ProxyToServerConnection.this.currentHttpRequest == null) {
                return true;
            }
            return ProxyUtils.isHEAD(ProxyToServerConnection.this.currentHttpRequest) || super.isContentAlwaysEmpty(httpMessage);
        }
    }
}

