/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.haproxy.HAProxyMessage;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import javax.net.ssl.SSLEngine;
import org.littleshoot.proxy.HttpFilters;
import org.littleshoot.proxy.impl.ConnectionFlowStep;
import org.littleshoot.proxy.impl.ConnectionState;
import org.littleshoot.proxy.impl.DefaultHttpProxyServer;
import org.littleshoot.proxy.impl.ProxyConnectionLogger;
import org.littleshoot.proxy.impl.ProxyUtils;

abstract class ProxyConnection<I extends HttpObject>
extends SimpleChannelInboundHandler<Object> {
    protected final ProxyConnectionLogger LOG = new ProxyConnectionLogger(this);
    protected final DefaultHttpProxyServer proxyServer;
    protected final boolean runsAsSslClient;
    protected volatile ChannelHandlerContext ctx;
    protected volatile Channel channel;
    private volatile ConnectionState currentState;
    private volatile boolean tunneling = false;
    protected volatile long lastReadTime = 0L;
    protected volatile SSLEngine sslEngine;
    protected ConnectionFlowStep StartTunneling = new ConnectionFlowStep(this, ConnectionState.NEGOTIATING_CONNECT){

        @Override
        boolean shouldSuppressInitialRequest() {
            return true;
        }

        @Override
        protected Future execute() {
            try {
                ChannelPipeline pipeline = ProxyConnection.this.ctx.pipeline();
                ProxyConnection.this.removeHandlerIfPresent(pipeline, "encoder");
                ProxyConnection.this.removeHandlerIfPresent(pipeline, "responseWrittenMonitor");
                ProxyConnection.this.removeHandlerIfPresent(pipeline, "decoder");
                ProxyConnection.this.removeHandlerIfPresent(pipeline, "requestReadMonitor");
                ProxyConnection.this.tunneling = true;
                return ProxyConnection.this.channel.newSucceededFuture();
            }
            catch (Throwable t) {
                return ProxyConnection.this.channel.newFailedFuture(t);
            }
        }
    };

    protected ProxyConnection(ConnectionState initialState, DefaultHttpProxyServer proxyServer, boolean runsAsSslClient) {
        this.become(initialState);
        this.proxyServer = proxyServer;
        this.runsAsSslClient = runsAsSslClient;
    }

    protected void read(Object msg) {
        this.LOG.debug("Reading: {}", msg);
        this.lastReadTime = System.currentTimeMillis();
        if (this.tunneling) {
            this.readRaw((ByteBuf)msg);
        } else if (msg instanceof HAProxyMessage) {
            this.readHAProxyMessage((HAProxyMessage)msg);
        } else {
            this.readHTTP((HttpObject)msg);
        }
    }

    protected abstract void readHAProxyMessage(HAProxyMessage var1);

    private void readHTTP(HttpObject httpObject) {
        ConnectionState nextState = this.getCurrentState();
        switch (this.getCurrentState()) {
            case AWAITING_INITIAL: {
                if (httpObject instanceof HttpMessage) {
                    nextState = this.readHTTPInitial(httpObject);
                    break;
                }
                this.LOG.debug("Dropping message because HTTP object was not an HttpMessage. HTTP object may be orphaned content from a short-circuited response. Message: {}", httpObject);
                break;
            }
            case AWAITING_CHUNK: {
                HttpContent chunk = (HttpContent)httpObject;
                this.readHTTPChunk(chunk);
                nextState = ProxyUtils.isLastChunk((HttpObject)chunk) ? ConnectionState.AWAITING_INITIAL : ConnectionState.AWAITING_CHUNK;
                break;
            }
            case AWAITING_PROXY_AUTHENTICATION: {
                if (!(httpObject instanceof HttpRequest)) break;
                nextState = this.readHTTPInitial(httpObject);
                break;
            }
            case CONNECTING: {
                this.LOG.warn("Attempted to read from connection that's in the process of connecting.  This shouldn't happen.", new Object[0]);
                break;
            }
            case NEGOTIATING_CONNECT: {
                this.LOG.debug("Attempted to read from connection that's in the process of negotiating an HTTP CONNECT.  This is probably the LastHttpContent of a chunked CONNECT.", new Object[0]);
                break;
            }
            case AWAITING_CONNECT_OK: {
                this.LOG.warn("AWAITING_CONNECT_OK should have been handled by ProxyToServerConnection.read()", new Object[0]);
                break;
            }
            case HANDSHAKING: {
                this.LOG.warn("Attempted to read from connection that's in the process of handshaking.  This shouldn't happen.", this.channel);
                break;
            }
            case DISCONNECT_REQUESTED: 
            case DISCONNECTED: {
                this.LOG.info("Ignoring message since the connection is closed or about to close", new Object[0]);
            }
        }
        this.become(nextState);
    }

    protected abstract ConnectionState readHTTPInitial(I var1);

    protected abstract void readHTTPChunk(HttpContent var1);

    protected abstract void readRaw(ByteBuf var1);

    void write(Object msg) {
        if (msg instanceof ReferenceCounted) {
            this.LOG.debug("Retaining reference counted message", new Object[0]);
            ((ReferenceCounted)msg).retain();
        }
        this.doWrite(msg);
    }

    void doWrite(Object msg) {
        block3: {
            this.LOG.debug("Writing: {}", msg);
            try {
                if (msg instanceof HttpObject) {
                    this.writeHttp((HttpObject)msg);
                    break block3;
                }
                this.writeRaw((ByteBuf)msg);
            }
            catch (Throwable throwable) {
                this.LOG.debug("Wrote: {}", msg);
                throw throwable;
            }
        }
        this.LOG.debug("Wrote: {}", msg);
    }

    protected void writeHttp(HttpObject httpObject) {
        if (ProxyUtils.isLastChunk(httpObject)) {
            this.channel.write((Object)httpObject);
            this.LOG.debug("Writing an empty buffer to signal the end of our chunked transfer", new Object[0]);
            this.writeToChannel(Unpooled.EMPTY_BUFFER);
        } else {
            this.writeToChannel(httpObject);
        }
    }

    protected void writeRaw(ByteBuf buf) {
        this.writeToChannel(buf);
    }

    protected ChannelFuture writeToChannel(Object msg) {
        return this.channel.writeAndFlush(msg);
    }

    protected void connected() {
        this.LOG.debug("Connected", new Object[0]);
    }

    protected void disconnected() {
        this.become(ConnectionState.DISCONNECTED);
        this.LOG.debug("Disconnected", new Object[0]);
    }

    protected void timedOut() {
        this.disconnect();
    }

    protected Future<Channel> encrypt(SSLEngine sslEngine, boolean authenticateClients) {
        return this.encrypt(this.ctx.pipeline(), sslEngine, authenticateClients);
    }

    protected Future<Channel> encrypt(ChannelPipeline pipeline, SSLEngine sslEngine, boolean authenticateClients) {
        this.LOG.debug("Enabling encryption with SSLEngine: {}", sslEngine);
        this.sslEngine = sslEngine;
        sslEngine.setUseClientMode(this.runsAsSslClient);
        sslEngine.setNeedClientAuth(authenticateClients);
        if (null != this.channel) {
            this.channel.config().setAutoRead(true);
        }
        SslHandler handler = new SslHandler(sslEngine);
        if (pipeline.get("ssl") == null) {
            pipeline.addFirst("ssl", (ChannelHandler)handler);
        } else {
            pipeline.addAfter("ssl", "sslWithServer", (ChannelHandler)handler);
        }
        return handler.handshakeFuture();
    }

    protected ConnectionFlowStep EncryptChannel(final SSLEngine sslEngine) {
        return new ConnectionFlowStep(this, ConnectionState.HANDSHAKING){

            @Override
            boolean shouldExecuteOnEventLoop() {
                return false;
            }

            protected Future<?> execute() {
                return ProxyConnection.this.encrypt(sslEngine, !ProxyConnection.this.runsAsSslClient);
            }
        };
    }

    protected void aggregateContentForFiltering(ChannelPipeline pipeline, int numberOfBytesToBuffer) {
        pipeline.addLast("inflater", (ChannelHandler)new HttpContentDecompressor());
        pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(numberOfBytesToBuffer));
    }

    protected void becameSaturated() {
        this.LOG.debug("Became saturated", new Object[0]);
    }

    protected void becameWritable() {
        this.LOG.debug("Became writeable", new Object[0]);
    }

    protected void exceptionCaught(Throwable cause) {
    }

    protected boolean removeHandlerIfPresent(ChannelPipeline pipeline, String handlerName) {
        if (pipeline.get(handlerName) != null) {
            pipeline.remove(handlerName);
            return true;
        }
        return false;
    }

    Future<Void> disconnect() {
        if (this.channel == null) {
            return null;
        }
        ChannelPromise promise = this.channel.newPromise();
        this.writeToChannel(Unpooled.EMPTY_BUFFER).addListener(arg_0 -> this.lambda$disconnect$0((Promise)promise, arg_0));
        return promise;
    }

    private void closeChannel(Promise<Void> promise) {
        this.channel.close().addListener(future -> {
            if (future.isSuccess()) {
                promise.setSuccess(null);
            } else {
                promise.setFailure(future.cause());
            }
        });
    }

    protected boolean isSaturated() {
        return !this.channel.isWritable();
    }

    protected boolean is(ConnectionState state) {
        return this.currentState == state;
    }

    protected boolean isConnecting() {
        return this.currentState.isPartOfConnectionFlow();
    }

    protected void become(ConnectionState state) {
        this.currentState = state;
    }

    protected ConnectionState getCurrentState() {
        return this.currentState;
    }

    public boolean isTunneling() {
        return this.tunneling;
    }

    public SSLEngine getSslEngine() {
        return this.sslEngine;
    }

    protected void stopReading() {
        this.LOG.debug("Stopped reading", new Object[0]);
        this.channel.config().setAutoRead(false);
    }

    protected void resumeReading() {
        this.LOG.debug("Resumed reading", new Object[0]);
        this.channel.config().setAutoRead(true);
    }

    protected HttpFilters getHttpFiltersFromProxyServer(HttpRequest httpRequest) {
        return this.proxyServer.getFiltersSource().filterRequest(httpRequest, this.ctx);
    }

    ProxyConnectionLogger getLOG() {
        return this.LOG;
    }

    protected final void channelRead0(ChannelHandlerContext ctx, Object msg) {
        this.read(msg);
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        try {
            this.ctx = ctx;
            this.channel = ctx.channel();
            this.proxyServer.registerChannel(ctx.channel());
        }
        finally {
            super.channelRegistered(ctx);
        }
    }

    public final void channelActive(ChannelHandlerContext ctx) throws Exception {
        try {
            this.connected();
        }
        finally {
            super.channelActive(ctx);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        try {
            this.disconnected();
        }
        finally {
            super.channelInactive(ctx);
        }
    }

    public final void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        this.LOG.debug("Writability changed. Is writable: {}", this.channel.isWritable());
        try {
            if (this.channel.isWritable()) {
                this.becameWritable();
            } else {
                this.becameSaturated();
            }
        }
        finally {
            super.channelWritabilityChanged(ctx);
        }
    }

    public final void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.exceptionCaught(cause);
    }

    public final void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        try {
            if (evt instanceof IdleStateEvent) {
                this.LOG.debug("Got idle", new Object[0]);
                this.timedOut();
            }
        }
        finally {
            super.userEventTriggered(ctx, evt);
        }
    }

    private /* synthetic */ void lambda$disconnect$0(Promise promise, Future future) throws Exception {
        this.closeChannel((Promise<Void>)promise);
    }

    @ChannelHandler.Sharable
    protected abstract class ResponseWrittenMonitor
    extends ChannelOutboundHandlerAdapter {
        protected ResponseWrittenMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            try {
                if (msg instanceof HttpResponse) {
                    this.responseWritten((HttpResponse)msg);
                }
            }
            catch (Throwable t) {
                ProxyConnection.this.LOG.warn("Error while invoking responseWritten callback", t);
            }
            finally {
                super.write(ctx, msg, promise);
            }
        }

        protected abstract void responseWritten(HttpResponse var1);
    }

    @ChannelHandler.Sharable
    protected static abstract class RequestWrittenMonitor
    extends ChannelOutboundHandlerAdapter {
        protected RequestWrittenMonitor() {
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            HttpRequest originalRequest = null;
            if (msg instanceof HttpRequest) {
                originalRequest = (HttpRequest)msg;
            }
            if (null != originalRequest) {
                this.requestWriting(originalRequest);
            }
            super.write(ctx, msg, promise);
            if (null != originalRequest) {
                this.requestWritten(originalRequest);
            }
            if (msg instanceof HttpContent) {
                this.contentWritten((HttpContent)msg);
            }
        }

        protected abstract void requestWriting(HttpRequest var1);

        protected abstract void requestWritten(HttpRequest var1);

        protected abstract void contentWritten(HttpContent var1);
    }

    @ChannelHandler.Sharable
    protected abstract class BytesWrittenMonitor
    extends ChannelOutboundHandlerAdapter {
        protected BytesWrittenMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            try {
                if (msg instanceof ByteBuf) {
                    this.bytesWritten(((ByteBuf)msg).readableBytes());
                }
            }
            catch (Throwable t) {
                ProxyConnection.this.LOG.warn("Unable to record bytesRead", t);
            }
            finally {
                super.write(ctx, msg, promise);
            }
        }

        protected abstract void bytesWritten(int var1);
    }

    @ChannelHandler.Sharable
    protected abstract class ResponseReadMonitor
    extends ChannelInboundHandlerAdapter {
        protected ResponseReadMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            try {
                if (msg instanceof HttpResponse) {
                    this.responseRead((HttpResponse)msg);
                }
            }
            catch (Throwable t) {
                ProxyConnection.this.LOG.warn("Unable to record bytesRead", t);
            }
            finally {
                super.channelRead(ctx, msg);
            }
        }

        protected abstract void responseRead(HttpResponse var1);
    }

    @ChannelHandler.Sharable
    protected abstract class RequestReadMonitor
    extends ChannelInboundHandlerAdapter {
        protected RequestReadMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            try {
                if (msg instanceof HttpRequest) {
                    this.requestRead((HttpRequest)msg);
                }
            }
            catch (Throwable t) {
                ProxyConnection.this.LOG.warn("Unable to record bytesRead", t);
            }
            finally {
                super.channelRead(ctx, msg);
            }
        }

        protected abstract void requestRead(HttpRequest var1);
    }

    @ChannelHandler.Sharable
    protected abstract class BytesReadMonitor
    extends ChannelInboundHandlerAdapter {
        protected BytesReadMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            try {
                if (msg instanceof ByteBuf) {
                    this.bytesRead(((ByteBuf)msg).readableBytes());
                }
            }
            catch (Throwable t) {
                ProxyConnection.this.LOG.warn("Unable to record bytesRead", t);
            }
            finally {
                super.channelRead(ctx, msg);
            }
        }

        protected abstract void bytesRead(int var1);
    }
}

