/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy.impl;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CategorizedThreadFactory
implements ThreadFactory {
    private static final Logger log = LoggerFactory.getLogger(CategorizedThreadFactory.class);
    private final String name;
    private final String category;
    private final int uniqueServerGroupId;
    private final AtomicInteger threadCount = new AtomicInteger(0);
    private static final Thread.UncaughtExceptionHandler UNCAUGHT_EXCEPTION_HANDLER = (t, e) -> log.error("Uncaught throwable in thread: {}", (Object)t.getName(), (Object)e);

    public CategorizedThreadFactory(String name, String category, int uniqueServerGroupId) {
        this.category = category;
        this.name = name;
        this.uniqueServerGroupId = uniqueServerGroupId;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(r, this.name + "-" + this.uniqueServerGroupId + "-" + this.category + "-" + this.threadCount.getAndIncrement());
        t.setDaemon(true);
        t.setUncaughtExceptionHandler(UNCAUGHT_EXCEPTION_HANDLER);
        return t;
    }
}

