/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy.impl;

import java.util.Arrays;
import org.littleshoot.proxy.impl.ProxyConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.spi.LocationAwareLogger;

class ProxyConnectionLogger {
    private final ProxyConnection connection;
    private final LogDispatch dispatch;
    private final Logger logger;
    private final String fqcn = this.getClass().getCanonicalName();

    public ProxyConnectionLogger(ProxyConnection connection) {
        this.connection = connection;
        Logger lg = LoggerFactory.getLogger(((Object)((Object)connection)).getClass());
        this.dispatch = lg instanceof LocationAwareLogger ? new LocationAwareLoggerDispatch((LocationAwareLogger)lg) : new LoggerDispatch();
        this.logger = lg;
    }

    protected void error(String message, Object ... params) {
        if (this.logger.isErrorEnabled()) {
            this.dispatch.doLog(40, message, params, null);
        }
    }

    protected void error(String message, Throwable t) {
        if (this.logger.isErrorEnabled()) {
            this.dispatch.doLog(40, message, null, t);
        }
    }

    protected void warn(String message, Object ... params) {
        if (this.logger.isWarnEnabled()) {
            this.dispatch.doLog(30, message, params, null);
        }
    }

    protected void warn(String message, Throwable t) {
        if (this.logger.isWarnEnabled()) {
            this.dispatch.doLog(30, message, null, t);
        }
    }

    protected void info(String message, Object ... params) {
        if (this.logger.isInfoEnabled()) {
            this.dispatch.doLog(20, message, params, null);
        }
    }

    protected void info(String message, Throwable t) {
        if (this.logger.isInfoEnabled()) {
            this.dispatch.doLog(20, message, null, t);
        }
    }

    protected void debug(String message, Object ... params) {
        if (this.logger.isDebugEnabled()) {
            this.dispatch.doLog(10, message, params, null);
        }
    }

    protected void debug(String message, Throwable t) {
        if (this.logger.isDebugEnabled()) {
            this.dispatch.doLog(10, message, null, t);
        }
    }

    protected void log(int level, String message, Object ... params) {
        if (level != 10 || this.logger.isDebugEnabled()) {
            this.dispatch.doLog(level, message, params, null);
        }
    }

    protected void log(int level, String message, Throwable t) {
        if (level != 10 || this.logger.isDebugEnabled()) {
            this.dispatch.doLog(level, message, null, t);
        }
    }

    private String fullMessage(String message) {
        String stateMessage = this.connection.getCurrentState().toString();
        if (this.connection.isTunneling()) {
            stateMessage = stateMessage + " {tunneling}";
        }
        String messagePrefix = "(" + stateMessage + ")";
        if (this.connection.channel != null) {
            messagePrefix = messagePrefix + " " + this.connection.channel;
        }
        return messagePrefix + ": " + message;
    }

    private class LocationAwareLoggerDispatch
    implements LogDispatch {
        private final LocationAwareLogger log;

        public LocationAwareLoggerDispatch(LocationAwareLogger log) {
            this.log = log;
        }

        @Override
        public void doLog(int level, String message, Object[] params, Throwable t) {
            String formattedMessage = ProxyConnectionLogger.this.fullMessage(message);
            if (params != null && params.length > 0) {
                formattedMessage = MessageFormatter.arrayFormat((String)formattedMessage, (Object[])params).getMessage();
            }
            this.log.log(null, ProxyConnectionLogger.this.fqcn, level, formattedMessage, null, t);
        }
    }

    private static interface LogDispatch {
        public void doLog(int var1, String var2, Object[] var3, Throwable var4);
    }

    private class LoggerDispatch
    implements LogDispatch {
        private LoggerDispatch() {
        }

        @Override
        public void doLog(int level, String message, Object[] params, Throwable t) {
            Object[] paramsWithThrowable;
            String formattedMessage = ProxyConnectionLogger.this.fullMessage(message);
            if (t != null) {
                if (params == null) {
                    paramsWithThrowable = new Object[]{t};
                } else {
                    paramsWithThrowable = Arrays.copyOf(params, params.length + 1);
                    paramsWithThrowable[params.length] = t;
                }
            } else {
                paramsWithThrowable = params;
            }
            switch (level) {
                case 0: {
                    ProxyConnectionLogger.this.logger.trace(formattedMessage, paramsWithThrowable);
                    break;
                }
                case 10: {
                    ProxyConnectionLogger.this.logger.debug(formattedMessage, paramsWithThrowable);
                    break;
                }
                case 20: {
                    ProxyConnectionLogger.this.logger.info(formattedMessage, paramsWithThrowable);
                    break;
                }
                case 30: {
                    ProxyConnectionLogger.this.logger.warn(formattedMessage, paramsWithThrowable);
                    break;
                }
                default: {
                    ProxyConnectionLogger.this.logger.error(formattedMessage, paramsWithThrowable);
                }
            }
        }
    }
}

