/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy.extras;

import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Security;
import java.util.Arrays;
import java.util.Objects;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.littleshoot.proxy.SslEngineSource;
import org.littleshoot.proxy.extras.TrustingTrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelfSignedSslEngineSource
implements SslEngineSource {
    private static final Logger LOG = LoggerFactory.getLogger(SelfSignedSslEngineSource.class);
    private static final String PROTOCOL = "TLS";
    private final String alias;
    private final String password;
    private final String keyStoreFile;
    private final boolean trustAllServers;
    private final boolean sendCerts;
    private SSLContext sslContext;

    public SelfSignedSslEngineSource(String keyStorePath, boolean trustAllServers, boolean sendCerts, String alias, String password) {
        this.trustAllServers = trustAllServers;
        this.sendCerts = sendCerts;
        this.keyStoreFile = keyStorePath;
        this.alias = alias;
        this.password = password;
        this.initializeSSLContext();
    }

    public SelfSignedSslEngineSource(String keyStorePath, boolean trustAllServers, boolean sendCerts) {
        this(keyStorePath, trustAllServers, sendCerts, "littleproxy", "Be Your Own Lantern");
    }

    public SelfSignedSslEngineSource(String keyStorePath) {
        this(keyStorePath, false, true);
    }

    public SelfSignedSslEngineSource(boolean trustAllServers) {
        this(trustAllServers, true);
    }

    public SelfSignedSslEngineSource(boolean trustAllServers, boolean sendCerts) {
        this("littleproxy_keystore.jks", trustAllServers, sendCerts);
    }

    public SelfSignedSslEngineSource() {
        this(false);
    }

    @Override
    public SSLEngine newSslEngine() {
        return this.sslContext.createSSLEngine();
    }

    @Override
    public SSLEngine newSslEngine(String peerHost, int peerPort) {
        return this.sslContext.createSSLEngine(peerHost, peerPort);
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    private void initializeKeyStore(File keyStoreLocalFile) {
        File keyStoreLocalAbsoluteFile = keyStoreLocalFile.getAbsoluteFile();
        this.nativeCall("keytool", "-genkey", "-alias", this.alias, "-keysize", "4096", "-validity", "36500", "-keyalg", "RSA", "-dname", "CN=littleproxy", "-keypass", this.password, "-storepass", this.password, "-keystore", keyStoreLocalAbsoluteFile.getPath());
        this.nativeCall("keytool", "-exportcert", "-alias", this.alias, "-keystore", keyStoreLocalAbsoluteFile.getPath(), "-storepass", this.password, "-file", Paths.get(keyStoreLocalAbsoluteFile.getParent(), "littleproxy_cert").toString());
    }

    private void initializeSSLContext() {
        String algorithm = Objects.requireNonNullElse(Security.getProperty("ssl.KeyManagerFactory.algorithm"), "SunX509");
        try {
            KeyStore ks = this.loadKeyStore();
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
            kmf.init(ks, this.password.toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
            tmf.init(ks);
            TrustManager[] trustManagers = this.createTrustManagers(tmf);
            KeyManager[] keyManagers = this.sendCerts ? kmf.getKeyManagers() : new KeyManager[]{};
            this.sslContext = SSLContext.getInstance(PROTOCOL);
            this.sslContext.init(keyManagers, trustManagers, null);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException("Failed to initialize the server-side SSLContext", e);
        }
    }

    private TrustManager[] createTrustManagers(TrustManagerFactory tmf) {
        TrustManager[] trustManagerArray;
        if (this.trustAllServers) {
            TrustManager[] trustManagerArray2 = new TrustManager[1];
            trustManagerArray = trustManagerArray2;
            trustManagerArray2[0] = new TrustingTrustManager();
        } else {
            trustManagerArray = tmf.getTrustManagers();
        }
        return trustManagerArray;
    }

    private KeyStore loadKeyStore() throws IOException, GeneralSecurityException {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        URL resourceUrl = this.getClass().getResource(this.keyStoreFile);
        if (resourceUrl != null) {
            this.loadKeyStore(keyStore, resourceUrl);
        } else {
            File keyStoreLocalFile = new File(this.keyStoreFile);
            if (!keyStoreLocalFile.isFile()) {
                this.initializeKeyStore(keyStoreLocalFile);
            }
            this.loadKeyStore(keyStore, keyStoreLocalFile.toURI().toURL());
        }
        return keyStore;
    }

    private void loadKeyStore(KeyStore keyStore, URL url) throws IOException, GeneralSecurityException {
        try (InputStream is = url.openStream();){
            keyStore.load(is, this.password.toCharArray());
        }
    }

    private void nativeCall(String ... commands) {
        LOG.info("Running '{}'", Arrays.asList(commands));
        ProcessBuilder pb = new ProcessBuilder(commands);
        try {
            byte[] data;
            Process process = pb.start();
            try (InputStream is = process.getInputStream();){
                data = ByteStreams.toByteArray((InputStream)is);
            }
            String dataAsString = new String(data);
            LOG.info("Completed native call: '{}'\nResponse: '{}'", Arrays.asList(commands), (Object)dataAsString);
        }
        catch (IOException e) {
            LOG.error("Error running commands: {}", Arrays.asList(commands), (Object)e);
        }
    }
}

