/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy.impl;

import io.netty.handler.codec.haproxy.HAProxyCommand;
import io.netty.handler.codec.haproxy.HAProxyMessage;
import io.netty.handler.codec.haproxy.HAProxyProtocolVersion;
import io.netty.handler.codec.haproxy.HAProxyProxiedProtocol;
import java.net.InetSocketAddress;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.littleshoot.proxy.extras.ProxyProtocolMessage;
import org.littleshoot.proxy.impl.ClientToProxyConnection;
import org.littleshoot.proxy.impl.ConnectionFlowStep;
import org.littleshoot.proxy.impl.ConnectionState;
import org.littleshoot.proxy.impl.ProxyConnection;
import org.littleshoot.proxy.impl.ProxyConnectionLogger;
import org.littleshoot.proxy.impl.ProxyToServerConnection;

class ConnectionFlow {
    private final Deque<ConnectionFlowStep> steps = new ConcurrentLinkedDeque<ConnectionFlowStep>();
    private final ClientToProxyConnection clientConnection;
    private final ProxyToServerConnection serverConnection;
    private volatile ConnectionFlowStep currentStep;
    private volatile boolean suppressInitialRequest;
    private final Object connectLock;

    ConnectionFlow(ClientToProxyConnection clientConnection, ProxyToServerConnection serverConnection, Object connectLock) {
        this.clientConnection = clientConnection;
        this.serverConnection = serverConnection;
        this.connectLock = connectLock;
    }

    ConnectionFlow first(ConnectionFlowStep step) {
        this.steps.addFirst(step);
        return this;
    }

    ConnectionFlow then(ConnectionFlowStep step) {
        this.steps.addLast(step);
        return this;
    }

    void read(Object msg) {
        if (this.currentStep != null) {
            this.currentStep.read(this, msg);
        }
    }

    void start() {
        this.clientConnection.serverConnectionFlowStarted(this.serverConnection);
        this.advance();
    }

    void advance() {
        this.currentStep = this.steps.poll();
        if (this.currentStep == null) {
            this.succeed();
        } else {
            this.processCurrentStep();
        }
    }

    private void processCurrentStep() {
        ProxyConnection connection = this.currentStep.getConnection();
        ProxyConnectionLogger LOG = connection.getLOG();
        LOG.debug("Processing connection flow step: {}", this.currentStep);
        connection.become(this.currentStep.getState());
        boolean bl = this.suppressInitialRequest = this.suppressInitialRequest || this.currentStep.shouldSuppressInitialRequest();
        if (this.currentStep.shouldExecuteOnEventLoop()) {
            connection.ctx.executor().submit(() -> this.doProcessCurrentStep(LOG));
        } else {
            this.doProcessCurrentStep(LOG);
        }
    }

    private void doProcessCurrentStep(ProxyConnectionLogger LOG) {
        this.currentStep.execute().addListener(future -> {
            Object object = this.connectLock;
            synchronized (object) {
                if (future.isSuccess()) {
                    LOG.debug("ConnectionFlowStep succeeded", new Object[0]);
                    this.currentStep.onSuccess(this);
                } else {
                    LOG.debug("ConnectionFlowStep failed", future.cause());
                    this.fail(future.cause());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void succeed() {
        Object object = this.connectLock;
        synchronized (object) {
            this.serverConnection.getLOG().debug("Connection flow completed successfully: {}", this.currentStep);
            this.serverConnection.connectionSucceeded(!this.suppressInitialRequest);
            this.relayProxyInformation();
            this.notifyThreadsWaitingForConnection();
        }
    }

    private void relayProxyInformation() {
        ProxyProtocolMessage proxyProtocolMessage;
        if (this.clientConnection.isSendProxyProtocol() && (proxyProtocolMessage = this.getHAProxyMessage(this.clientConnection.getClientAddress(), this.serverConnection.getRemoteAddress())) != null) {
            this.serverConnection.writeToChannel(proxyProtocolMessage);
        }
    }

    private ProxyProtocolMessage getHAProxyMessage(InetSocketAddress clientAddress, InetSocketAddress remoteAddress) {
        HAProxyMessage haProxyMessage = this.clientConnection.getHaProxyMessage();
        if (haProxyMessage != null) {
            return new ProxyProtocolMessage(haProxyMessage);
        }
        return new ProxyProtocolMessage(HAProxyProtocolVersion.V1, HAProxyCommand.PROXY, HAProxyProxiedProtocol.TCP4, clientAddress.getAddress().getHostAddress(), remoteAddress.getAddress().getHostAddress(), clientAddress.getPort(), remoteAddress.getPort());
    }

    void fail(Throwable cause) {
        ConnectionState lastStateBeforeFailure = this.serverConnection.getCurrentState();
        this.serverConnection.disconnect().addListener(future -> {
            Object object = this.connectLock;
            synchronized (object) {
                if (!this.clientConnection.serverConnectionFailed(this.serverConnection, lastStateBeforeFailure, cause)) {
                    this.serverConnection.become(ConnectionState.DISCONNECTED);
                    this.notifyThreadsWaitingForConnection();
                }
            }
        });
    }

    void fail() {
        this.fail(null);
    }

    private void notifyThreadsWaitingForConnection() {
        this.connectLock.notifyAll();
    }
}

