/*
 * Decompiled with CFR 0.152.
 */
package xyz.ronella.trivial.command.logic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import xyz.ronella.trivial.command.logic.ILogical;
import xyz.ronella.trivial.functional.Sink;

public abstract class AbstractLogical
implements ILogical {
    protected List<BooleanSupplier> conditions;
    protected Sink defaultTruthLogic;
    protected Sink defaultFalseLogic;

    public AbstractLogical(List<BooleanSupplier> conditions, Sink defaultTruthLogic, Sink defaultFalseLogic) {
        this.conditions = Optional.ofNullable(conditions).orElse(new ArrayList());
        this.defaultTruthLogic = defaultTruthLogic;
        this.defaultFalseLogic = defaultFalseLogic;
    }

    public AbstractLogical(List<BooleanSupplier> conditions, Sink defaultTruthLogic) {
        this(conditions, defaultTruthLogic, null);
    }

    public AbstractLogical(List<BooleanSupplier> conditions) {
        this(conditions, null);
    }

    public AbstractLogical(Sink defaultTruthLogic, Sink defaultFalseLogic, BooleanSupplier ... conditions) {
        this(Arrays.asList(Optional.ofNullable(conditions).orElseThrow()), defaultTruthLogic, defaultFalseLogic);
    }

    public AbstractLogical(Sink defaultTruthLogic, BooleanSupplier ... conditions) {
        this(defaultTruthLogic, (Sink)null, conditions);
    }

    public AbstractLogical(BooleanSupplier ... conditions) {
        this((Sink)null, conditions);
    }

    @Override
    public void accept(Sink truthLogic) {
        this.accept(Optional.ofNullable(truthLogic).orElse(this.defaultTruthLogic), null);
    }

    public abstract boolean getTruthCondition(List<BooleanSupplier> var1);

    @Override
    public void accept(Sink truthLogic, Sink falseLogic) {
        Optional.ofNullable(this.conditions).ifPresent(___condition -> {
            if (this.getTruthCondition((List<BooleanSupplier>)___condition)) {
                Optional.ofNullable(truthLogic).orElse(Optional.ofNullable(this.defaultTruthLogic).orElse(() -> {})).plummet();
            } else {
                Optional.ofNullable(falseLogic).orElse(Optional.ofNullable(this.defaultFalseLogic).orElse(() -> {})).plummet();
            }
        });
    }
}

