/*
 * Decompiled with CFR 0.152.
 */
package xyz.ronella.trivial.decorator;

import java.util.concurrent.locks.Lock;
import java.util.function.BooleanSupplier;

public class CloseableLock
implements AutoCloseable {
    private final Lock receivedLock;
    private final BooleanSupplier lockOnlyWhen;
    private int lockCount;

    public CloseableLock(Lock lock) {
        this(lock, false);
    }

    public CloseableLock(Lock lock, BooleanSupplier lockOnlyWhen) {
        this(lock, false, lockOnlyWhen);
    }

    public CloseableLock(Lock lock, boolean noLockCall) {
        this(lock, noLockCall, () -> Boolean.TRUE);
    }

    public CloseableLock(Lock lock, boolean noLockCall, BooleanSupplier lockOnlyWhen) {
        this.receivedLock = lock;
        this.lockOnlyWhen = lockOnlyWhen;
        if (!noLockCall) {
            this.lock();
        }
    }

    public void lock() {
        if (this.lockOnlyWhen.getAsBoolean()) {
            this.receivedLock.lock();
            ++this.lockCount;
        }
    }

    public void unlock() {
        if (this.lockCount > 0 && this.lockOnlyWhen.getAsBoolean()) {
            --this.lockCount;
            this.receivedLock.unlock();
        }
    }

    @Override
    public void close() {
        this.unlock();
    }
}

