/*
 * Decompiled with CFR 0.152.
 */
package xyz.ronella.trivial.decorator;

import java.util.Optional;
import java.util.function.Consumer;

public class OptionalString {
    private final Optional<String> optional;

    public OptionalString(Optional<String> optional) {
        this.optional = optional;
    }

    public boolean isEmpty() {
        return this.optional.isEmpty() || this.optional.get().isEmpty();
    }

    public boolean isBlank() {
        return this.optional.isEmpty() || this.optional.get().isBlank();
    }

    public void ifPresentNotBlank(Consumer<String> action) {
        this.optional.ifPresent(text -> {
            if (!text.isBlank()) {
                action.accept((String)text);
            }
        });
    }

    public void ifPresentNotEmpty(Consumer<String> action) {
        this.optional.ifPresent(text -> {
            if (!text.isEmpty()) {
                action.accept((String)text);
            }
        });
    }

    public void ifPresentNotBlankOrElse(Consumer<String> action, Runnable emptyAction) {
        String text = null;
        if (this.optional.isPresent() && !this.optional.get().isBlank()) {
            text = this.optional.get();
        }
        Optional.ofNullable(text).ifPresentOrElse(action, emptyAction);
    }

    public void ifPresentNotEmptyOrElse(Consumer<String> action, Runnable emptyAction) {
        String text = null;
        if (this.optional.isPresent() && !this.optional.get().isEmpty()) {
            text = this.optional.get();
        }
        Optional.ofNullable(text).ifPresentOrElse(action, emptyAction);
    }
}

