/*
 * Decompiled with CFR 0.152.
 */
package xyz.ronella.trivial.decorator;

import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import xyz.ronella.trivial.decorator.CloseableLock;
import xyz.ronella.trivial.functional.Sink;

public class StringBuilderAppender {
    private final StringBuilder builder;
    private final Consumer<StringBuilder> defaultBeforeAppend;
    private final Consumer<StringBuilder> defaultAfterAppend;
    private final Lock instanceLock = new ReentrantLock();
    private boolean hasLocking;

    public StringBuilderAppender(StringBuilder builder, Consumer<StringBuilder> defaultBeforeAppend, Consumer<StringBuilder> defaultAfterAppend) {
        this.builder = Optional.ofNullable(builder).orElseThrow();
        this.defaultBeforeAppend = defaultBeforeAppend;
        this.defaultAfterAppend = defaultAfterAppend;
    }

    public StringBuilderAppender(String string, Consumer<StringBuilder> defaultBeforeAppend, Consumer<StringBuilder> defaultAfterAppend) {
        this(new StringBuilder(string), defaultBeforeAppend, defaultAfterAppend);
    }

    public StringBuilderAppender(Consumer<StringBuilder> defaultBeforeAppend, Consumer<StringBuilder> defaultAfterAppend) {
        this(new StringBuilder(), defaultBeforeAppend, defaultAfterAppend);
    }

    public StringBuilderAppender(StringBuilder builder, Consumer<StringBuilder> defaultBeforeAppend) {
        this(builder, defaultBeforeAppend, null);
    }

    public StringBuilderAppender(String string, Consumer<StringBuilder> defaultBeforeAppend) {
        this(string, defaultBeforeAppend, null);
    }

    public StringBuilderAppender(Consumer<StringBuilder> defaultBeforeAppend) {
        this(defaultBeforeAppend, null);
    }

    public StringBuilderAppender(StringBuilder builder) {
        this(builder, null);
    }

    public StringBuilderAppender(String string) {
        this(string, null);
    }

    public StringBuilderAppender() {
        this((Consumer<StringBuilder>)null);
    }

    public StringBuilderAppender threadSafe() {
        this.hasLocking = true;
        return this;
    }

    private void beforeAndAfterAppendLogic(Consumer<StringBuilder> logic, Consumer<StringBuilder> beforeAppend, Consumer<StringBuilder> afterAppend) {
        try (CloseableLock ___ = new CloseableLock(this.instanceLock, this::isThreadSafe);){
            if (null != beforeAppend) {
                beforeAppend.accept(this.builder);
            } else if (null != this.defaultBeforeAppend) {
                this.defaultBeforeAppend.accept(this.builder);
            }
            logic.accept(this.builder);
            if (null != afterAppend) {
                afterAppend.accept(this.builder);
            } else if (null != this.defaultAfterAppend) {
                this.defaultAfterAppend.accept(this.builder);
            }
        }
    }

    public StringBuilderAppender append(String text, Consumer<StringBuilder> beforeAppend, Consumer<StringBuilder> afterAppend) {
        Optional.ofNullable(text).ifPresent(___text -> this.beforeAndAfterAppendLogic(sb -> sb.append((String)___text), beforeAppend, afterAppend));
        return this;
    }

    private void conditionLogic(BooleanSupplier condition, Sink logic) {
        Optional.ofNullable(condition).ifPresent(___condition -> {
            if (___condition.getAsBoolean()) {
                logic.plummet();
            }
        });
    }

    public StringBuilderAppender append(BooleanSupplier condition, String text, Consumer<StringBuilder> beforeAppend, Consumer<StringBuilder> afterAppend) {
        this.conditionLogic(condition, () -> this.append(text, beforeAppend, afterAppend));
        return this;
    }

    public StringBuilderAppender append(String text, Consumer<StringBuilder> beforeAppend) {
        return this.append(text, beforeAppend, null);
    }

    public StringBuilderAppender append(BooleanSupplier condition, String text, Consumer<StringBuilder> beforeAppend) {
        this.conditionLogic(condition, () -> this.append(text, beforeAppend));
        return this;
    }

    public StringBuilderAppender append(String text) {
        return this.append(text, (Consumer<StringBuilder>)null);
    }

    public StringBuilderAppender append(BooleanSupplier condition, String text) {
        this.conditionLogic(condition, () -> this.append(text));
        return this;
    }

    public String toString() {
        return this.builder.toString();
    }

    public StringBuilder getStringBuilder() {
        return this.builder;
    }

    public StringBuilderAppender append(Consumer<StringBuilder> updateLogic, Consumer<StringBuilder> beforeAppend, Consumer<StringBuilder> afterAppend) {
        Optional.ofNullable(updateLogic).ifPresent(logic -> this.beforeAndAfterAppendLogic(sb -> logic.accept(this.builder), beforeAppend, afterAppend));
        return this;
    }

    public StringBuilderAppender append(BooleanSupplier condition, Consumer<StringBuilder> updateLogic, Consumer<StringBuilder> beforeAppend, Consumer<StringBuilder> afterAppend) {
        this.conditionLogic(condition, () -> this.append(updateLogic, beforeAppend, afterAppend));
        return this;
    }

    public StringBuilderAppender append(Consumer<StringBuilder> updateLogic, Consumer<StringBuilder> beforeAppend) {
        return this.append(updateLogic, beforeAppend, (Consumer<StringBuilder>)null);
    }

    public StringBuilderAppender append(BooleanSupplier condition, Consumer<StringBuilder> updateLogic, Consumer<StringBuilder> beforeAppend) {
        this.conditionLogic(condition, () -> this.append(updateLogic, beforeAppend));
        return this;
    }

    public StringBuilderAppender append(Consumer<StringBuilder> updateLogic) {
        return this.append(updateLogic, (Consumer<StringBuilder>)null);
    }

    public StringBuilderAppender append(BooleanSupplier condition, Consumer<StringBuilder> updateLogic) {
        this.conditionLogic(condition, () -> this.append(updateLogic));
        return this;
    }

    public StringBuilderAppender append(Consumer<StringBuilder> beforeAppend, Consumer<StringBuilder> afterAppend, String ... texts) {
        Optional.ofNullable(texts).ifPresent(___texts -> Arrays.asList(___texts).forEach(___text -> this.append((String)___text, beforeAppend, afterAppend)));
        return this;
    }

    public StringBuilderAppender append(Consumer<StringBuilder> beforeAppend, String ... texts) {
        return this.append(beforeAppend, (Consumer<StringBuilder>)null, texts);
    }

    public StringBuilderAppender append(String ... texts) {
        return this.append((Consumer<StringBuilder>)null, texts);
    }

    public StringBuilderAppender append(BooleanSupplier condition, Consumer<StringBuilder> beforeAppend, Consumer<StringBuilder> afterAppend, String ... texts) {
        Optional.ofNullable(texts).ifPresent(___texts -> Arrays.asList(___texts).forEach(___text -> this.append(condition, (String)___text, beforeAppend, afterAppend)));
        return this;
    }

    public StringBuilderAppender append(BooleanSupplier condition, Consumer<StringBuilder> beforeAppend, String ... texts) {
        return this.append(condition, beforeAppend, (Consumer<StringBuilder>)null, texts);
    }

    public StringBuilderAppender append(BooleanSupplier condition, String ... texts) {
        return this.append(condition, (Consumer<StringBuilder>)null, texts);
    }

    public StringBuilderAppender clear() {
        try (CloseableLock ___ = new CloseableLock(this.instanceLock, this::isThreadSafe);){
            this.builder.delete(0, this.builder.length());
        }
        return this;
    }

    public StringBuilderAppender replace(CharSequence target, CharSequence replacement) {
        try (CloseableLock ___ = new CloseableLock(this.instanceLock, this::isThreadSafe);){
            String tmpText = this.builder.toString().replace(target, replacement);
            this.clear();
            this.builder.append(tmpText);
        }
        return this;
    }

    private boolean isThreadSafe() {
        return this.hasLocking;
    }
}

