/*
 * Decompiled with CFR 0.152.
 */
package xyz.ronella.trivial.handy;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.Scanner;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import xyz.ronella.trivial.functional.NoOperation;
import xyz.ronella.trivial.handy.CommandRunnerException;
import xyz.ronella.trivial.handy.ICommandArray;
import xyz.ronella.trivial.handy.MissingCommandException;

public final class CommandRunner {
    public static final int ERROR_EXIT_CODE = -100;
    public static final BiConsumer<InputStream, InputStream> DEFAULT_OUTPUT_LOGIC = (___output, ___error) -> {
        Scanner outputScanner = new Scanner((InputStream)___output);
        Scanner errorScanner = new Scanner((InputStream)___error);
        while (outputScanner.hasNextLine()) {
            System.out.println(outputScanner.nextLine());
        }
        while (errorScanner.hasNextLine()) {
            System.err.println(errorScanner.nextLine());
        }
    };

    private CommandRunner() {
    }

    public static int runCommand(Supplier<ProcessBuilder> createProcessBuilder, String ... command) throws MissingCommandException {
        return CommandRunner.runCommand(createProcessBuilder, DEFAULT_OUTPUT_LOGIC, command);
    }

    public static int runCommand(Supplier<ProcessBuilder> createProcessBuilder, ICommandArray commandArray) throws MissingCommandException {
        return CommandRunner.runCommand(createProcessBuilder, DEFAULT_OUTPUT_LOGIC, commandArray.getCommand());
    }

    public static int runCommand(Consumer<ProcessBuilder> initProcessBuilder, String ... command) throws MissingCommandException {
        return CommandRunner.runCommand(initProcessBuilder, DEFAULT_OUTPUT_LOGIC, command);
    }

    public static int runCommand(Consumer<ProcessBuilder> initProcessBuilder, ICommandArray commandArray) throws MissingCommandException {
        return CommandRunner.runCommand(initProcessBuilder, DEFAULT_OUTPUT_LOGIC, commandArray);
    }

    public static int runCommand(ICommandArray commandArray) throws MissingCommandException {
        return CommandRunner.runCommand(() -> new ProcessBuilder(new String[0]), commandArray.getCommand());
    }

    public static int runCommand(String ... command) throws MissingCommandException {
        return CommandRunner.runCommand(() -> new ProcessBuilder(new String[0]), command);
    }

    public static int runCommand(BiConsumer<InputStream, InputStream> outputLogic, String ... command) throws MissingCommandException {
        return CommandRunner.runCommand(() -> new ProcessBuilder(new String[0]), outputLogic, command);
    }

    public static int runCommand(BiConsumer<InputStream, InputStream> outputLogic, ICommandArray commandArray) throws MissingCommandException {
        return CommandRunner.runCommand(() -> new ProcessBuilder(new String[0]), outputLogic, commandArray);
    }

    public static Process startProcess(Consumer<Process> initProcess, ICommandArray commandArray) throws MissingCommandException, CommandRunnerException {
        return CommandRunner.startProcess(() -> new ProcessBuilder(new String[0]), initProcess, commandArray);
    }

    public static Process startProcess(ICommandArray commandArray) throws MissingCommandException, CommandRunnerException {
        return CommandRunner.startProcess(() -> new ProcessBuilder(new String[0]), NoOperation.consumer(), commandArray);
    }

    public static int runCommand(Consumer<ProcessBuilder> initProcessBuilder, BiConsumer<InputStream, InputStream> outputLogic, String ... command) throws MissingCommandException {
        return CommandRunner.runCommand(() -> {
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            initProcessBuilder.accept(builder);
            return builder;
        }, outputLogic, command);
    }

    public static int runCommand(Consumer<ProcessBuilder> initProcessBuilder, BiConsumer<InputStream, InputStream> outputLogic, ICommandArray commandArray) throws MissingCommandException {
        return CommandRunner.runCommand(initProcessBuilder, outputLogic, commandArray.getCommand());
    }

    public static Process startProcess(Consumer<ProcessBuilder> initProcessBuilder, Consumer<Process> initProcess, ICommandArray commandArray) throws MissingCommandException, CommandRunnerException {
        return CommandRunner.startProcess(() -> {
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            initProcessBuilder.accept(builder);
            return builder;
        }, initProcess, DEFAULT_OUTPUT_LOGIC, commandArray);
    }

    public static int runCommand(Supplier<ProcessBuilder> createProcessBuilder, BiConsumer<InputStream, InputStream> outputLogic, ICommandArray commandArray) throws MissingCommandException {
        return CommandRunner.runCommand(createProcessBuilder, outputLogic, commandArray.getCommand());
    }

    public static Process startProcess(Supplier<ProcessBuilder> createProcessBuilder, Consumer<Process> initProcess, ICommandArray commandArray) throws MissingCommandException, CommandRunnerException {
        return CommandRunner.startProcess(createProcessBuilder, initProcess, DEFAULT_OUTPUT_LOGIC, commandArray);
    }

    public static int runCommand(Supplier<ProcessBuilder> createProcessBuilder, BiConsumer<InputStream, InputStream> outputLogic, String ... command) throws MissingCommandException {
        return CommandRunner.execute(createProcessBuilder, NoOperation.consumer(), outputLogic, command);
    }

    private static Process processor(Supplier<ProcessBuilder> createProcessBuilder, Consumer<Process> initProcess, BiConsumer<InputStream, InputStream> outputLogic, String ... command) throws MissingCommandException, CommandRunnerException {
        try {
            if (command.length == 0) {
                throw new MissingCommandException();
            }
            ProcessBuilder builder = Optional.of(createProcessBuilder.get()).orElse(new ProcessBuilder(new String[0]));
            builder.command(command);
            Process process = builder.start();
            initProcess.accept(process);
            try (InputStream output = process.getInputStream();
                 InputStream error = process.getErrorStream();){
                outputLogic.accept(output, error);
            }
            return process;
        }
        catch (IOException ioe) {
            throw new CommandRunnerException(ioe.getMessage());
        }
    }

    private static int execute(Supplier<ProcessBuilder> createProcessBuilder, Consumer<Process> initProcess, BiConsumer<InputStream, InputStream> outputLogic, String ... command) throws MissingCommandException {
        try {
            return CommandRunner.processor(createProcessBuilder, initProcess, outputLogic, command).exitValue();
        }
        catch (CommandRunnerException e) {
            System.err.println(e.getMessage());
            return -100;
        }
    }

    public static Process startProcess(Supplier<ProcessBuilder> createProcessBuilder, Consumer<Process> initProcess, BiConsumer<InputStream, InputStream> outputLogic, ICommandArray commandArray) throws MissingCommandException, CommandRunnerException {
        return CommandRunner.processor(createProcessBuilder, initProcess, outputLogic, commandArray.getCommand());
    }
}

