/*
 * Decompiled with CFR 0.152.
 */
package xyz.ronella.trivial.handy;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import xyz.ronella.trivial.functional.Sink;

public final class LogicMapper<TYPE_OUTPUT> {
    private final Map<BooleanSupplier, Sink> logicMap;
    private final Sink initialLogic;
    private final Supplier<TYPE_OUTPUT> finalLogic;

    private LogicMapper(LogicMapperBuilder<TYPE_OUTPUT> builder) {
        this.logicMap = Optional.ofNullable(builder.logicMap).orElse(new LinkedHashMap());
        this.initialLogic = Optional.ofNullable(builder.initialLogic).orElse(() -> {});
        this.finalLogic = Optional.ofNullable(builder.finalLogic).orElse(() -> null);
    }

    public Optional<TYPE_OUTPUT> output() {
        this.initialLogic.plummet();
        this.logicMap.forEach((___condition, ___logic) -> {
            if (Optional.ofNullable(___condition).orElse(() -> Boolean.FALSE).getAsBoolean()) {
                ___logic.plummet();
            }
        });
        return Optional.ofNullable(this.finalLogic.get());
    }

    public void execute() {
        this.output();
    }

    public static <TYPE_OUTPUT> LogicMapperBuilder<TYPE_OUTPUT> getBuilder() {
        return new LogicMapperBuilder();
    }

    public static class LogicMapperBuilder<TYPE_OUTPUT> {
        private final Map<BooleanSupplier, Sink> logicMap;
        private Sink initialLogic;
        private Supplier<TYPE_OUTPUT> finalLogic;
        private final AtomicInteger inlineIdx = new AtomicInteger();

        public LogicMapperBuilder() {
            this.logicMap = new LinkedHashMap<BooleanSupplier, Sink>();
        }

        public LogicMapperBuilder<TYPE_OUTPUT> addLogic(BooleanSupplier condition, Sink logic) {
            this.logicMap.put(condition, logic);
            return this;
        }

        public LogicMapperBuilder<TYPE_OUTPUT> addInlineLogic(Sink logic) {
            this.logicMap.put(() -> {
                Predicate<Integer> dummy = __ -> Boolean.TRUE;
                return dummy.test(this.inlineIdx.incrementAndGet());
            }, logic);
            return this;
        }

        public LogicMapperBuilder<TYPE_OUTPUT> addInitialLogic(Sink logic) {
            this.initialLogic = logic;
            return this;
        }

        public LogicMapperBuilder<TYPE_OUTPUT> addFinalLogic(Supplier<TYPE_OUTPUT> logic) {
            this.finalLogic = logic;
            return this;
        }

        public LogicMapper<TYPE_OUTPUT> build() {
            return new LogicMapper(this);
        }
    }
}

