/*
 * Decompiled with CFR 0.152.
 */
package xyz.ronella.trivial.handy;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public final class PathFinder {
    private final List<File> files;
    private final String filename;
    private final boolean fallbackToCL;

    private PathFinder(PathFinderBuilder builder) {
        this.files = builder.files;
        this.filename = builder.filename;
        this.fallbackToCL = builder.fallbackToCL;
    }

    public Optional<File> getFile() {
        return this.files.stream().filter(File::exists).findFirst();
    }

    public void processInputStream(Consumer<InputStream> process) throws IOException {
        Optional<InputStream> optInputStream = this.getInputStream();
        if (optInputStream.isPresent()) {
            try (InputStream inputStream = optInputStream.get();){
                process.accept(inputStream);
            }
        }
    }

    public Optional<InputStream> getInputStream() throws IOException {
        Optional<InputStream> optInputStream = Optional.empty();
        if (this.getFile().isPresent()) {
            optInputStream = Optional.of(Files.newInputStream(this.getFile().get().toPath(), new OpenOption[0]));
        } else if (this.fallbackToCL) {
            optInputStream = Optional.ofNullable(ClassLoader.getSystemResourceAsStream(this.filename));
        }
        return optInputStream;
    }

    public static PathFinderBuilder getBuilder(String filename) {
        return new PathFinderBuilder(filename);
    }

    public static class PathFinderBuilder {
        private final String filename;
        private final List<File> files;
        private boolean fallbackToCL;

        private PathFinderBuilder(String filename) {
            this.filename = filename;
            this.files = new ArrayList<File>();
        }

        public PathFinder build() {
            return new PathFinder(this);
        }

        public PathFinderBuilder addPaths(List<String> dirs) {
            List paths = dirs.stream().map(___dir -> ___dir.split(File.pathSeparator)).map(___dir -> {
                ArrayList<String> dirList = new ArrayList<String>(Arrays.asList(___dir));
                dirList.add(this.filename);
                String firstEntry = dirList.remove(0);
                return Paths.get(firstEntry, dirList.toArray(new String[0])).toFile();
            }).collect(Collectors.toList());
            if (paths.isEmpty()) {
                paths.add(new File(this.filename));
            }
            this.files.addAll(paths);
            return this;
        }

        public PathFinderBuilder addPaths(String ... dirs) {
            this.addPaths(Arrays.asList(dirs));
            return this;
        }

        public PathFinderBuilder setFallbackToClassloader(boolean fallbackToCL) {
            this.fallbackToCL = fallbackToCL;
            return this;
        }
    }
}

