/*
 * Decompiled with CFR 0.152.
 */
package xyz.ronella.trivial.handy;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import xyz.ronella.trivial.functional.NoOperation;
import xyz.ronella.trivial.functional.Sink;
import xyz.ronella.trivial.handy.IMatcherConfig;
import xyz.ronella.trivial.handy.impl.MatcherConfig;

public final class RegExMatcher {
    private RegExMatcher() {
    }

    public static Matcher match(String pattern, String text, IMatcherConfig config) {
        Pattern compiledPattern = Pattern.compile(pattern);
        Matcher matcher = compiledPattern.matcher(text);
        try {
            Function<Matcher, Boolean> matchLogicOption = Optional.ofNullable(config.getMatchLogic()).orElse(Matcher::find);
            if (matchLogicOption.apply(matcher).booleanValue()) {
                config.getMatchFoundLogic().accept(matcher);
            } else {
                config.getNoMatchFoundLogic().accept(matcher);
            }
        }
        catch (RuntimeException exception) {
            config.getExceptionLogic().accept(exception);
        }
        return matcher;
    }

    public static Matcher find(String pattern, String text) {
        return RegExMatcher.match(pattern, text, MatcherConfig.getBuilder().setMatchLogic(Matcher::find).build());
    }

    public static Matcher find(String pattern, String text, int flags) {
        return RegExMatcher.match(pattern, text, MatcherConfig.getBuilder().setMatchLogic(Matcher::find).build(flags));
    }

    @Deprecated
    public static Matcher findWithMatchLogic(String pattern, String text, Consumer<Matcher> matchFoundLogic) {
        return RegExMatcher.match(pattern, text, MatcherConfig.getBuilder().setMatchLogic(Matcher::find).setMatchFoundLogic(matchFoundLogic).build());
    }

    @Deprecated
    public static Matcher findWithMatchLogic(String pattern, String text, Consumer<Matcher> matchFoundLogic, Consumer<RuntimeException> exceptionLogic) {
        return RegExMatcher.match(pattern, text, MatcherConfig.getBuilder().setMatchLogic(Matcher::find).setMatchFoundLogic(matchFoundLogic).setExceptionLogic(exceptionLogic).build());
    }

    @Deprecated
    public static Matcher findWithNoMatchLogic(String pattern, String text, Consumer<Matcher> matchFoundLogic, Consumer<Matcher> noMatchFoundLogic) {
        return RegExMatcher.match(pattern, text, MatcherConfig.getBuilder().setMatchLogic(Matcher::find).setMatchFoundLogic(matchFoundLogic).setNoMatchFoundLogic(noMatchFoundLogic).build());
    }

    public static Matcher find(String pattern, String text, Consumer<Matcher> matchFoundLogic, Consumer<Matcher> noMatchFoundLogic) {
        return RegExMatcher.match(pattern, text, MatcherConfig.getBuilder().setMatchLogic(Matcher::find).setMatchFoundLogic(matchFoundLogic).setNoMatchFoundLogic(noMatchFoundLogic).build());
    }

    public static Matcher find(String pattern, String text, Consumer<Matcher> matchFoundLogic) {
        return RegExMatcher.match(pattern, text, MatcherConfig.getBuilder().setMatchLogic(Matcher::find).setMatchFoundLogic(matchFoundLogic).setNoMatchFoundLogic(NoOperation.consumer()).build());
    }

    public static Matcher find(String pattern, String text, int flags, Consumer<Matcher> matchFoundLogic, Consumer<Matcher> noMatchFoundLogic) {
        return RegExMatcher.match(pattern, text, MatcherConfig.getBuilder().setMatchLogic(Matcher::find).setMatchFoundLogic(matchFoundLogic).setNoMatchFoundLogic(noMatchFoundLogic).build(flags));
    }

    public static Matcher find(String pattern, String text, int flags, Consumer<Matcher> matchFoundLogic) {
        return RegExMatcher.match(pattern, text, MatcherConfig.getBuilder().setMatchLogic(Matcher::find).setMatchFoundLogic(matchFoundLogic).setNoMatchFoundLogic(NoOperation.consumer()).build(flags));
    }

    @Deprecated
    public static Matcher findWithNoMatchLogic(String pattern, String text, Consumer<Matcher> matchFoundLogic, Consumer<Matcher> noMatchFoundLogic, Consumer<RuntimeException> exceptionLogic) {
        return RegExMatcher.match(pattern, text, MatcherConfig.getBuilder().setMatchLogic(Matcher::find).setMatchFoundLogic(matchFoundLogic).setNoMatchFoundLogic(noMatchFoundLogic).setExceptionLogic(exceptionLogic).build());
    }

    @Deprecated
    public static Matcher match(String pattern, String text, Function<Matcher, Boolean> matchLogic) {
        return RegExMatcher.match(pattern, text, MatcherConfig.getBuilder().setMatchLogic(matchLogic).build());
    }

    @Deprecated
    public static Matcher match(String pattern, String text, Function<Matcher, Boolean> matchLogic, Consumer<RuntimeException> exceptionLogic) {
        return RegExMatcher.match(pattern, text, MatcherConfig.getBuilder().setMatchLogic(matchLogic).setExceptionLogic(exceptionLogic).build());
    }

    @Deprecated
    public static Matcher matchWithMatchLogic(String pattern, String text, Function<Matcher, Boolean> matchLogic, Consumer<Matcher> matchFoundLogic) {
        return RegExMatcher.match(pattern, text, MatcherConfig.getBuilder().setMatchLogic(matchLogic).setMatchFoundLogic(matchFoundLogic).build());
    }

    @Deprecated
    public static Matcher matchWithMatchLogic(String pattern, String text, Function<Matcher, Boolean> matchLogic, Consumer<Matcher> matchFoundLogic, Consumer<RuntimeException> exceptionLogic) {
        return RegExMatcher.match(pattern, text, MatcherConfig.getBuilder().setMatchLogic(matchLogic).setMatchFoundLogic(matchFoundLogic).setExceptionLogic(exceptionLogic).build());
    }

    @Deprecated
    public static Matcher matchWithNoMatchLogic(String pattern, String text, Function<Matcher, Boolean> matchLogic, Consumer<Matcher> matchFoundLogic, Consumer<Matcher> noMatchFoundLogic) {
        return RegExMatcher.match(pattern, text, MatcherConfig.getBuilder().setMatchLogic(matchLogic).setMatchFoundLogic(matchFoundLogic).setNoMatchFoundLogic(noMatchFoundLogic).build());
    }

    @Deprecated
    public static Matcher matchWithNoMatchLogic(String pattern, String text, Function<Matcher, Boolean> matchLogic, Consumer<Matcher> matchFoundLogic, Consumer<Matcher> noMatchFoundLogic, Consumer<RuntimeException> exceptionLogic) {
        return RegExMatcher.match(pattern, text, MatcherConfig.getBuilder().setMatchLogic(matchLogic).setMatchFoundLogic(matchFoundLogic).setNoMatchFoundLogic(noMatchFoundLogic).setExceptionLogic(exceptionLogic).build());
    }

    @Deprecated
    public static Matcher matchByRegEx(String pattern, String text, Function<Matcher, Boolean> matchLogic, Consumer<Matcher> matchFoundLogic, Sink noMatchFoundLogic, Consumer<RuntimeException> exceptionLogic) {
        return RegExMatcher.match(pattern, text, MatcherConfig.getBuilder().setMatchLogic(matchLogic).setMatchFoundLogic(matchFoundLogic).setNoMatchFoundLogic(___matcher -> noMatchFoundLogic.plummet()).setExceptionLogic(exceptionLogic).build());
    }

    @Deprecated
    public static Matcher matchByRegEx(String pattern, String text, Consumer<Matcher> matchFoundLogic, Sink noMatchFoundLogic, Consumer<RuntimeException> exceptionLogic) {
        return RegExMatcher.matchByRegEx(pattern, text, null, matchFoundLogic, noMatchFoundLogic, exceptionLogic);
    }

    @Deprecated
    public static Matcher matchByRegEx(String pattern, String text, Consumer<Matcher> matchFoundLogic, Sink noMatchFoundLogic) {
        return RegExMatcher.matchByRegEx(pattern, text, matchFoundLogic, noMatchFoundLogic, NoOperation.consumer());
    }

    @Deprecated
    public static Matcher matchByRegEx(String pattern, String text, Function<Matcher, Boolean> matchLogic, Consumer<Matcher> matchFoundLogic, Sink noMatchFoundLogic) {
        return RegExMatcher.matchByRegEx(pattern, text, matchLogic, matchFoundLogic, noMatchFoundLogic, NoOperation.consumer());
    }

    @Deprecated
    public static Matcher matchByRegEx(String pattern, String text, Consumer<Matcher> matchFoundLogic) {
        return RegExMatcher.matchByRegEx(pattern, text, matchFoundLogic, NoOperation.sink());
    }

    @Deprecated
    public static Matcher matchByRegEx(String pattern, String text, Function<Matcher, Boolean> matchLogic, Consumer<Matcher> matchFoundLogic) {
        return RegExMatcher.matchByRegEx(pattern, text, matchLogic, matchFoundLogic, NoOperation.sink());
    }

    @Deprecated
    public static Matcher matchByRegEx(String pattern, String text, Consumer<Matcher> matchFoundLogic, Consumer<RuntimeException> exceptionLogic) {
        return RegExMatcher.matchByRegEx(pattern, text, matchFoundLogic, NoOperation.sink(), exceptionLogic);
    }

    @Deprecated
    public static Matcher matchByRegEx(String pattern, String text, Function<Matcher, Boolean> matchLogic, Consumer<Matcher> matchFoundLogic, Consumer<RuntimeException> exceptionLogic) {
        return RegExMatcher.matchByRegEx(pattern, text, matchLogic, matchFoundLogic, NoOperation.sink(), exceptionLogic);
    }

    @Deprecated
    public static Matcher matchByRegEx(String pattern, String text) {
        return RegExMatcher.matchByRegEx(pattern, text, NoOperation.consumer(), NoOperation.sink());
    }

    @Deprecated
    public static Matcher matchByRegEx(String pattern, String text, Function<Matcher, Boolean> matchLogic) {
        return RegExMatcher.matchByRegEx(pattern, text, matchLogic, NoOperation.consumer(), NoOperation.sink());
    }
}

