/*
 * Decompiled with CFR 0.152.
 */
package xyz.ronella.trivial.handy.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BooleanSupplier;
import xyz.ronella.trivial.decorator.ListAdder;
import xyz.ronella.trivial.handy.ICommandArray;

public final class CommandArray
implements ICommandArray {
    private final String program;
    private final List<String> progArgs;
    private final String command;
    private final List<String> arguments;
    private final List<String> zArguments;

    private CommandArray(CommandArrayBuilder builder) {
        this.program = builder.program;
        this.progArgs = builder.progArgs;
        this.command = builder.command;
        this.arguments = builder.arguments;
        this.zArguments = builder.zArguments;
    }

    @Override
    public String[] getCommand() {
        ArrayList lstCommand = new ArrayList();
        ListAdder lstAddrCommand = new ListAdder(lstCommand);
        lstAddrCommand.add(() -> null != this.program, this.program);
        lstAddrCommand.addAll(() -> !this.progArgs.isEmpty(), this.progArgs);
        lstAddrCommand.add(() -> null != this.command, this.command);
        lstAddrCommand.addAll(() -> !this.arguments.isEmpty(), this.arguments);
        lstAddrCommand.addAll(() -> !this.zArguments.isEmpty(), this.zArguments);
        return lstCommand.toArray(new String[0]);
    }

    public static CommandArrayBuilder getBuilder() {
        return new CommandArrayBuilder();
    }

    public static final class CommandArrayBuilder {
        private String program;
        private final List<String> progArgs = new ArrayList<String>();
        private String command;
        private final List<String> arguments = new ArrayList<String>();
        private final List<String> zArguments = new ArrayList<String>();

        private CommandArrayBuilder() {
        }

        public CommandArray build() {
            return new CommandArray(this);
        }

        public CommandArrayBuilder setProgram(String program) {
            this.program = program;
            return this;
        }

        public CommandArrayBuilder setCommand(String command) {
            this.command = command;
            return this;
        }

        public CommandArrayBuilder addPArgs(Collection<String> args) {
            this.progArgs.addAll(args);
            return this;
        }

        public CommandArrayBuilder addPArgs(BooleanSupplier when, Collection<String> args) {
            if (when.getAsBoolean()) {
                this.progArgs.addAll(args);
            }
            return this;
        }

        public CommandArrayBuilder addPArg(String arg) {
            this.progArgs.add(arg);
            return this;
        }

        public CommandArrayBuilder addPArg(BooleanSupplier when, String arg) {
            if (when.getAsBoolean()) {
                this.progArgs.add(arg);
            }
            return this;
        }

        public CommandArrayBuilder addArgs(Collection<String> args) {
            this.arguments.addAll(args);
            return this;
        }

        public CommandArrayBuilder addArgs(BooleanSupplier when, Collection<String> args) {
            if (when.getAsBoolean()) {
                this.arguments.addAll(args);
            }
            return this;
        }

        public CommandArrayBuilder addArg(String arg) {
            this.arguments.add(arg);
            return this;
        }

        public CommandArrayBuilder addArg(BooleanSupplier when, String arg) {
            if (when.getAsBoolean()) {
                this.arguments.add(arg);
            }
            return this;
        }

        public CommandArrayBuilder addZArgs(Collection<String> args) {
            this.zArguments.addAll(args);
            return this;
        }

        public CommandArrayBuilder addZArgs(BooleanSupplier when, Collection<String> args) {
            if (when.getAsBoolean()) {
                this.zArguments.addAll(args);
            }
            return this;
        }

        public CommandArrayBuilder addZArg(String arg) {
            this.arguments.add(arg);
            return this;
        }

        public CommandArrayBuilder addZArg(BooleanSupplier when, String arg) {
            if (when.getAsBoolean()) {
                this.arguments.add(arg);
            }
            return this;
        }
    }
}

