/*
 * Decompiled with CFR 0.152.
 */
package xyz.ronella.trivial.handy.impl;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import xyz.ronella.trivial.functional.NoOperation;
import xyz.ronella.trivial.handy.IMatcherConfig;

public final class MatcherConfig
implements IMatcherConfig {
    private final int patternFlags;
    private final Function<Matcher, Boolean> matchLogic;
    private final Consumer<Matcher> matchFoundLogic;
    private final Consumer<Matcher> noMatchFoundLogic;
    private final Consumer<RuntimeException> exceptionLogic;

    private MatcherConfig(MatcherConfigBuilder builder) {
        this.patternFlags = builder.patternFlags;
        this.matchLogic = builder.matchLogic;
        this.matchFoundLogic = builder.matchFoundLogic;
        this.noMatchFoundLogic = builder.noMatchFoundLogic;
        this.exceptionLogic = builder.exceptionLogic;
    }

    @Override
    public int getPatternFlags() {
        return this.patternFlags;
    }

    @Override
    public Function<Matcher, Boolean> getMatchLogic() {
        return this.matchLogic == null ? NoOperation.function(false) : this.matchLogic;
    }

    @Override
    public Consumer<Matcher> getMatchFoundLogic() {
        return this.matchFoundLogic == null ? NoOperation.consumer() : this.matchFoundLogic;
    }

    @Override
    public Consumer<Matcher> getNoMatchFoundLogic() {
        return this.noMatchFoundLogic == null ? NoOperation.consumer() : this.noMatchFoundLogic;
    }

    @Override
    public Consumer<RuntimeException> getExceptionLogic() {
        return this.exceptionLogic == null ? NoOperation.consumer() : this.exceptionLogic;
    }

    public static MatcherConfigBuilder getBuilder() {
        return new MatcherConfigBuilder();
    }

    public static final class MatcherConfigBuilder {
        private int patternFlags;
        private Function<Matcher, Boolean> matchLogic;
        private Consumer<Matcher> matchFoundLogic;
        private Consumer<Matcher> noMatchFoundLogic;
        private Consumer<RuntimeException> exceptionLogic;

        private MatcherConfigBuilder() {
        }

        public MatcherConfigBuilder setMatchLogic(Function<Matcher, Boolean> matchLogic) {
            this.matchLogic = matchLogic;
            return this;
        }

        public MatcherConfigBuilder setMatchFoundLogic(Consumer<Matcher> matchFoundLogic) {
            this.matchFoundLogic = matchFoundLogic;
            return this;
        }

        public MatcherConfigBuilder setNoMatchFoundLogic(Consumer<Matcher> noMatchFoundLogic) {
            this.noMatchFoundLogic = noMatchFoundLogic;
            return this;
        }

        public MatcherConfigBuilder setExceptionLogic(Consumer<RuntimeException> exceptionLogic) {
            this.exceptionLogic = exceptionLogic;
            return this;
        }

        public MatcherConfig build() {
            return new MatcherConfig(this);
        }

        public MatcherConfig build(int patternFlags) {
            this.patternFlags = patternFlags;
            return new MatcherConfig(this);
        }
    }
}

